/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.items;

import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import thaumicenergistics.ThaumicEnergistics;
import thaumicenergistics.registries.ItemEnum;
import thaumicenergistics.registries.ThEStrings;

public class ItemMaterial
extends Item {
    private IIcon[] icons;

    public ItemMaterial() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(ThaumicEnergistics.ThETab);
    }

    public IIcon func_77617_a(int damage) {
        int index = MathHelper.func_76125_a((int)damage, (int)0, (int)(MaterialTypes.VALUES.length - 1));
        return this.icons[index];
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List itemList) {
        for (MaterialTypes material : MaterialTypes.VALUES) {
            itemList.add(new ItemStack(item, 1, material.getID()));
        }
    }

    public String func_77658_a() {
        return "thaumicenergistics.item.material";
    }

    public String func_77667_c(ItemStack itemStack) {
        int index = MathHelper.func_76125_a((int)itemStack.func_77960_j(), (int)0, (int)(MaterialTypes.VALUES.length - 1));
        return MaterialTypes.VALUES[index].getUnlocalizedName();
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[MaterialTypes.VALUES.length];
        for (MaterialTypes material : MaterialTypes.VALUES) {
            this.icons[material.getID()] = iconRegister.func_94245_a(material.getTextureLocation());
        }
    }

    public static enum MaterialTypes {
        DIFFUSION_CORE(0, "diffusion.core", ThEStrings.Item_DiffusionCore),
        COALESCENCE_CORE(1, "coalescence.core", ThEStrings.Item_CoalescenceCore),
        IRON_GEAR(2, "iron.gear", ThEStrings.Item_IronGear);

        private int ID;
        private String textureLocation;
        private ThEStrings unlocalizedName;
        public static final MaterialTypes[] VALUES;

        private MaterialTypes(int ID, String textureName, ThEStrings unlocalizedName) {
            this.ID = ID;
            this.textureLocation = "thaumicenergistics:material." + textureName;
            this.unlocalizedName = unlocalizedName;
        }

        public int getID() {
            return this.ID;
        }

        public ItemStack getStack() {
            return this.getStack(1);
        }

        public ItemStack getStack(int size) {
            return ItemEnum.MATERIAL.getDMGStack(this.ordinal(), size);
        }

        public String getTextureLocation() {
            return this.textureLocation;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName.getUnlocalized();
        }

        static {
            VALUES = MaterialTypes.values();
        }
    }
}

