/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.items;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.integration.tc.IRestrictedEssentiaContainerItem;
import thaumicenergistics.registries.ThEStrings;
import thaumicenergistics.tileentities.abstraction.TileEVCBase;

public class ItemBlockEssentiaVibrationChamber
extends ItemBlock
implements IRestrictedEssentiaContainerItem {
    public ItemBlockEssentiaVibrationChamber(Block block) {
        super(block);
    }

    private AspectStack getStoredAspectStack(ItemStack evcStack) {
        NBTTagCompound data = evcStack.func_77978_p();
        if (data == null || !data.func_74764_b("StoredEssentia")) {
            return null;
        }
        return AspectStack.loadAspectStackFromNBT(data.func_74775_l("StoredEssentia"));
    }

    private void setStoredAspectStack(ItemStack evcStack, AspectStack aspectStack) {
        NBTTagCompound data = evcStack.func_77978_p();
        if (data == null) {
            data = new NBTTagCompound();
        }
        if (aspectStack == null) {
            data.func_82580_o("StoredEssentia");
        } else {
            NBTTagCompound storedTag = new NBTTagCompound();
            aspectStack.writeToNBT(storedTag);
            data.func_74782_a("StoredEssentia", (NBTBase)storedTag);
        }
        if (data.func_82582_d()) {
            data = null;
        }
        evcStack.func_77982_d(data);
    }

    @Override
    public boolean acceptsAspect(Aspect aspect) {
        return TileEVCBase.acceptsAspect(aspect);
    }

    public void func_77624_a(ItemStack evcStack, EntityPlayer player, List displayList, boolean advancedItemTooltips) {
        if (!evcStack.func_77942_o()) {
            return;
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            AspectStack storedEssentia = this.getStoredAspectStack(evcStack);
            if (storedEssentia != null) {
                displayList.add(String.format("%s x %d", storedEssentia.aspect.getName(), storedEssentia.stackSize));
            }
        } else {
            displayList.add(EnumChatFormatting.WHITE.toString() + EnumChatFormatting.ITALIC.toString() + ThEStrings.Tooltip_CellDetails.getLocalized());
        }
    }

    public AspectList getAspects(ItemStack evcStack) {
        AspectStack stored;
        AspectList list = new AspectList();
        if (evcStack.func_77942_o() && (stored = this.getStoredAspectStack(evcStack)) != null && stored.stackSize > 0L) {
            list.add(stored.aspect, (int)stored.stackSize);
        }
        return list;
    }

    public void setAspects(ItemStack evcStack, AspectList list) {
        AspectStack aspectStack = null;
        if (list.size() > 0) {
            Aspect aspect = list.getAspects()[0];
            aspectStack = new AspectStack(aspect, list.getAmount(aspect));
        }
        this.setStoredAspectStack(evcStack, aspectStack);
    }
}

