/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.inventory;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.util.DimensionalCoord;
import appeng.core.AEConfig;
import appeng.tile.networking.TileWireless;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import thaumicenergistics.api.IThEWirelessEssentiaTerminal;
import thaumicenergistics.aspect.AspectStackComparator;
import thaumicenergistics.grid.EssentiaPassThroughMonitor;
import thaumicenergistics.grid.IEssentiaGrid;
import thaumicenergistics.grid.IMEEssentiaMonitor;
import thaumicenergistics.items.ItemWirelessEssentiaTerminal;

public class HandlerWirelessEssentiaTerminal {
    private static final String NBT_KEY_SORTING_MODE = "SortingMode";
    private IThEWirelessEssentiaTerminal wirelessTerminal;
    private IWirelessAccessPoint accessPoint;
    private double rangeOfAccessPoint;
    private DimensionalCoord locationOfAccessPoint;
    private EntityPlayer player;
    private PlayerSource playerSource = null;
    private ItemStack wirelessItemstack;
    private double wirelessPowerMultiplier = 1.0;

    public HandlerWirelessEssentiaTerminal(EntityPlayer player, IWirelessAccessPoint accessPoint, IThEWirelessEssentiaTerminal wirelessTerminalInterface, ItemStack wirelessTerminalItemstack) {
        this.player = player;
        this.wirelessTerminal = wirelessTerminalInterface;
        this.wirelessItemstack = wirelessTerminalItemstack;
        this.setAccessPoint(accessPoint);
    }

    private static double getSquaredPlayerDistanceFromAP(DimensionalCoord APLocation, EntityPlayer player) {
        int pX = (int)Math.floor(player.field_70165_t);
        int pY = (int)Math.floor(player.field_70163_u);
        int pZ = (int)Math.floor(player.field_70161_v);
        int dX = APLocation.x - pX;
        int dY = APLocation.y - pY;
        int dZ = APLocation.z - pZ;
        int squareDistance = dX * dX + dY * dY + dZ * dZ;
        return squareDistance;
    }

    public static boolean isAPInRangeOfPlayer(DimensionalCoord APLocation, double APRange, EntityPlayer player) {
        if (!APLocation.isInWorld(player.field_70170_p)) {
            return false;
        }
        double squareDistance = HandlerWirelessEssentiaTerminal.getSquaredPlayerDistanceFromAP(APLocation, player);
        return squareDistance <= APRange * APRange;
    }

    public static boolean isTerminalLinked(IThEWirelessEssentiaTerminal wirelessTerminal, ItemStack wirelessTerminalItemstack) {
        return !wirelessTerminal.getEncryptionKey(wirelessTerminalItemstack).isEmpty();
    }

    private boolean isAPInRangeAndActive() {
        return this.accessPoint.isActive() && HandlerWirelessEssentiaTerminal.isAPInRangeOfPlayer(this.locationOfAccessPoint, this.rangeOfAccessPoint, this.player);
    }

    private void setAccessPoint(IWirelessAccessPoint accessPoint) {
        this.accessPoint = accessPoint;
        this.rangeOfAccessPoint = this.accessPoint.getRange();
        this.locationOfAccessPoint = this.accessPoint.getLocation();
        if (this.player != null) {
            this.playerSource = new PlayerSource(this.player, (IActionHost)this.accessPoint);
        }
    }

    public double extractPower(double amount, Actionable mode) {
        if (ItemWirelessEssentiaTerminal.GLOBAL_POWER_MULTIPLIER == 0.0) {
            return amount;
        }
        double adjustedAmount = amount * this.wirelessPowerMultiplier;
        double extractedAmount = 0.0;
        extractedAmount = mode == Actionable.SIMULATE ? Math.min(this.wirelessTerminal.getAECurrentPower(this.wirelessItemstack), adjustedAmount) : this.wirelessTerminal.extractAEPower(this.wirelessItemstack, adjustedAmount);
        return extractedAmount /= this.wirelessPowerMultiplier;
    }

    public BaseActionSource getActionHost() {
        return this.playerSource;
    }

    public IMEEssentiaMonitor getEssentiaMonitor() {
        try {
            IMEEssentiaMonitor essMonitor = (IMEEssentiaMonitor)this.accessPoint.getGrid().getCache(IEssentiaGrid.class);
            PowerRedirector pr = new PowerRedirector();
            EssentiaPassThroughMonitor monitor = new EssentiaPassThroughMonitor(essMonitor, pr);
            return monitor;
        }
        catch (Exception e) {
            return null;
        }
    }

    public AspectStackComparator.ComparatorMode getSortingMode() {
        NBTTagCompound dataTagCompound = this.wirelessTerminal.getWETerminalTag(this.wirelessItemstack);
        if (dataTagCompound.func_74764_b(NBT_KEY_SORTING_MODE)) {
            return AspectStackComparator.ComparatorMode.valueOf(dataTagCompound.func_74779_i(NBT_KEY_SORTING_MODE));
        }
        return AspectStackComparator.ComparatorMode.MODE_ALPHABETIC;
    }

    public ItemStack getTerminalItem() {
        return this.wirelessItemstack;
    }

    public boolean hasPower() {
        return this.wirelessTerminal.getAECurrentPower(this.wirelessItemstack) > 0.0;
    }

    public boolean isConnected() {
        if (!this.hasPower()) {
            return false;
        }
        if (this.isAPInRangeAndActive()) {
            return true;
        }
        IMachineSet accessPoints = this.accessPoint.getGrid().getMachines(TileWireless.class);
        for (IGridNode APNode : accessPoints) {
            IWirelessAccessPoint AP = (IWirelessAccessPoint)APNode.getMachine();
            if (AP.equals(this.accessPoint) || !AP.isActive() || !HandlerWirelessEssentiaTerminal.isAPInRangeOfPlayer(AP.getLocation(), AP.getRange(), this.player)) continue;
            this.setAccessPoint(AP);
            return true;
        }
        return false;
    }

    public void setSortingMode(AspectStackComparator.ComparatorMode mode) {
        NBTTagCompound dataTag = this.wirelessTerminal.getWETerminalTag(this.wirelessItemstack);
        dataTag.func_74778_a(NBT_KEY_SORTING_MODE, mode.name());
    }

    public void updatePowerMultiplier() {
        double distance = HandlerWirelessEssentiaTerminal.getSquaredPlayerDistanceFromAP(this.locationOfAccessPoint, this.player);
        distance = Math.sqrt(distance);
        this.wirelessPowerMultiplier = AEConfig.instance.wireless_getDrainRate(distance);
    }

    private class PowerRedirector
    implements IEnergyGrid {
        public void addNode(IGridNode gridNode, IGridHost machine) {
        }

        public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
            return HandlerWirelessEssentiaTerminal.this.extractPower(amt, mode);
        }

        public double extractAEPower(double amt, Actionable mode, Set<IEnergyGrid> seen) {
            return HandlerWirelessEssentiaTerminal.this.extractPower(amt, mode);
        }

        public double getAvgPowerInjection() {
            return 0.0;
        }

        public double getAvgPowerUsage() {
            return 0.0;
        }

        public double getEnergyDemand(double maxRequired) {
            return 0.0;
        }

        public double getEnergyDemand(double d, Set<IEnergyGrid> seen) {
            return 0.0;
        }

        public double getIdlePowerUsage() {
            return 0.0;
        }

        public double getMaxStoredPower() {
            return 0.0;
        }

        public double getStoredPower() {
            return 0.0;
        }

        public double injectAEPower(double amt, Actionable mode, Set<IEnergyGrid> seen) {
            return amt;
        }

        public double injectPower(double amt, Actionable mode) {
            return amt;
        }

        public boolean isNetworkPowered() {
            return true;
        }

        public void onJoin(IGridStorage sourceStorage) {
        }

        public void onSplit(IGridStorage destinationStorage) {
        }

        public void onUpdateTick() {
        }

        public void populateGridStorage(IGridStorage destinationStorage) {
        }

        public void removeNode(IGridNode gridNode, IGridHost machine) {
        }
    }
}

