/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.inventory;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.parts.misc.PartInterface;
import appeng.tile.misc.TileCondenser;
import appeng.tile.misc.TileInterface;
import net.minecraft.tileentity.TileEntity;
import thaumcraft.api.aspects.IAspectContainer;
import thaumicenergistics.inventory.AbstractHandlerEssentiaStorageBus;
import thaumicenergistics.inventory.HandlerEssentiaStorageBusCondenser;
import thaumicenergistics.inventory.HandlerEssentiaStorageBusContainer;
import thaumicenergistics.inventory.HandlerEssentiaStorageBusInterface;
import thaumicenergistics.parts.AEPartEssentiaStorageBus;

public class HandlerEssentiaStorageBusDuality
extends AbstractHandlerEssentiaStorageBus {
    private AbstractHandlerEssentiaStorageBus internalHandler;
    private HandlerEssentiaStorageBusContainer containerHandler;
    private HandlerEssentiaStorageBusInterface interfaceHandler;
    private HandlerEssentiaStorageBusCondenser condenserHandler;

    public HandlerEssentiaStorageBusDuality(AEPartEssentiaStorageBus part) {
        super(part);
    }

    private void updateInternalHandler() {
        if (this.internalHandler != null) {
            this.internalHandler.filteredAspects = this.filteredAspects;
            this.internalHandler.inverted = this.inverted;
            this.internalHandler.setVoidAllowed(this.isVoidAllowed());
        }
    }

    @Override
    public boolean canAccept(IAEFluidStack fluidStack) {
        if (this.internalHandler != null) {
            return this.internalHandler.canAccept(fluidStack);
        }
        return false;
    }

    @Override
    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource source) {
        if (this.internalHandler != null) {
            return this.internalHandler.extractItems(request, mode, source);
        }
        return null;
    }

    @Override
    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        if (this.internalHandler != null) {
            return this.internalHandler.getAvailableItems(out);
        }
        return out;
    }

    @Override
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, BaseActionSource source) {
        if (this.internalHandler != null) {
            return this.internalHandler.injectItems(input, mode, source);
        }
        return input;
    }

    @Override
    public boolean onNeighborChange() {
        boolean doUpdate = false;
        TileEntity tileEntity = this.getFaceingTile();
        AbstractHandlerEssentiaStorageBus newHandler = null;
        if (tileEntity instanceof TileCondenser) {
            if (this.condenserHandler == null) {
                this.condenserHandler = new HandlerEssentiaStorageBusCondenser(this.partStorageBus);
            }
            newHandler = this.condenserHandler;
        } else if (tileEntity instanceof IAspectContainer) {
            if (this.containerHandler == null) {
                this.containerHandler = new HandlerEssentiaStorageBusContainer(this.partStorageBus);
            }
            newHandler = this.containerHandler;
        } else if (tileEntity instanceof IPartHost) {
            IPart facingPart = this.getFacingPartFromPartHost((IPartHost)tileEntity);
            if (facingPart instanceof PartInterface) {
                if (this.interfaceHandler == null) {
                    this.interfaceHandler = new HandlerEssentiaStorageBusInterface(this.partStorageBus);
                }
                newHandler = this.interfaceHandler;
            }
        } else if (tileEntity instanceof TileInterface) {
            if (this.interfaceHandler == null) {
                this.interfaceHandler = new HandlerEssentiaStorageBusInterface(this.partStorageBus);
            }
            newHandler = this.interfaceHandler;
        }
        if (this.internalHandler != newHandler) {
            if (this.internalHandler != null) {
                this.internalHandler.onNeighborChange();
            }
            this.internalHandler = newHandler;
            doUpdate = true;
        }
        if (this.internalHandler != null) {
            this.updateInternalHandler();
            doUpdate |= this.internalHandler.onNeighborChange();
        }
        return doUpdate;
    }

    @Override
    public void setInverted(boolean isInverted) {
        this.inverted = isInverted;
        if (this.internalHandler != null) {
            this.internalHandler.setInverted(isInverted);
        }
    }

    @Override
    public void setVoidAllowed(boolean isVoidAllowed) {
        super.setVoidAllowed(isVoidAllowed);
        if (this.internalHandler != null) {
            this.internalHandler.setVoidAllowed(isVoidAllowed);
        }
    }

    @Override
    public void tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (this.internalHandler != null) {
            this.internalHandler.tickingRequest(node, TicksSinceLastCall);
        }
    }

    @Override
    public boolean validForPass(int pass) {
        if (this.internalHandler != null) {
            return this.internalHandler.validForPass(pass);
        }
        return false;
    }
}

