/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration.tc;

import appeng.api.config.Actionable;
import appeng.api.storage.data.IAEFluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.common.tiles.TileAlchemyFurnaceAdvancedNozzle;
import thaumcraft.common.tiles.TileAlembic;
import thaumcraft.common.tiles.TileCentrifuge;
import thaumcraft.common.tiles.TileEssentiaReservoir;
import thaumcraft.common.tiles.TileJarFillable;
import thaumcraft.common.tiles.TileJarFillableVoid;
import thaumcraft.common.tiles.TileTubeBuffer;
import thaumicenergistics.api.IThETransportPermissions;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.fluids.GaseousEssentia;
import thaumicenergistics.integration.tc.EssentiaConversionHelper;
import thaumicenergistics.tileentities.TileEssentiaVibrationChamber;

public final class EssentiaTileContainerHelper {
    public static final EssentiaTileContainerHelper INSTANCE = new EssentiaTileContainerHelper();
    public final IThETransportPermissions perms = ThEApi.instance().transportPermissions();

    public FluidStack extractFromContainer(IAspectContainer container, FluidStack request, Actionable mode) {
        if (request == null || request.getFluid() == null || request.amount == 0) {
            return null;
        }
        Fluid fluid = request.getFluid();
        if (!(fluid instanceof GaseousEssentia)) {
            return null;
        }
        Aspect gasAspect = ((GaseousEssentia)fluid).getAspect();
        long amountToDrain_EU = EssentiaConversionHelper.INSTANCE.convertFluidAmountToEssentiaAmount(request.amount);
        long extractedAmount_EU = this.extractFromContainer(container, (int)amountToDrain_EU, gasAspect, mode);
        if (extractedAmount_EU <= 0L) {
            return null;
        }
        return new FluidStack(fluid, (int)EssentiaConversionHelper.INSTANCE.convertEssentiaAmountToFluidAmount(extractedAmount_EU));
    }

    public long extractFromContainer(IAspectContainer container, int amountToDrain, Aspect aspectToDrain, Actionable mode) {
        if (amountToDrain == 0) {
            return 0L;
        }
        if (!this.perms.canExtractFromAspectContainerTile(container)) {
            return 0L;
        }
        int containerAmount = container.getAspects().getAmount(aspectToDrain);
        if (containerAmount == 0) {
            return 0L;
        }
        if (amountToDrain > containerAmount) {
            amountToDrain = containerAmount;
        }
        if (mode == Actionable.MODULATE) {
            container.takeFromContainer(aspectToDrain, amountToDrain);
        }
        return amountToDrain;
    }

    public Aspect getAspectInContainer(IAspectContainer container) {
        AspectStack containerStack = this.getAspectStackFromContainer(container);
        if (containerStack == null) {
            return null;
        }
        return containerStack.aspect;
    }

    public AspectStack getAspectStackFromContainer(IAspectContainer container) {
        if (container == null) {
            return null;
        }
        AspectList aspectList = container.getAspects();
        if (aspectList == null) {
            return null;
        }
        AspectStack aspectStack = new AspectStack();
        aspectStack.aspect = aspectList.getAspectsSortedAmount()[0];
        if (aspectStack.aspect == null) {
            return null;
        }
        aspectStack.stackSize = aspectList.getAmount(aspectStack.aspect);
        return aspectStack;
    }

    public List<AspectStack> getAspectStacksFromContainer(IAspectContainer container) {
        ArrayList<AspectStack> stacks = new ArrayList<AspectStack>();
        if (container == null) {
            return stacks;
        }
        AspectList aspectList = container.getAspects();
        if (aspectList == null) {
            return stacks;
        }
        for (Map.Entry essentia : aspectList.aspects.entrySet()) {
            if (essentia == null || (Integer)essentia.getValue() == 0) continue;
            stacks.add(new AspectStack((Aspect)essentia.getKey(), ((Integer)essentia.getValue()).intValue()));
        }
        return stacks;
    }

    public int getContainerCapacity(IAspectContainer container) {
        return this.perms.getAspectContainerTileCapacity(container);
    }

    public int getContainerStoredAmount(IAspectContainer container) {
        int stored = 0;
        for (AspectStack essentia : this.getAspectStacksFromContainer(container)) {
            if (essentia == null) continue;
            stored += (int)essentia.stackSize;
        }
        return stored;
    }

    public long injectEssentiaIntoContainer(IAspectContainer container, int amountToFill, Aspect aspectToFill, Actionable mode) {
        if (!this.perms.canInjectToAspectContainerTile(container)) {
            return 0L;
        }
        AspectStack storedEssentia = this.getAspectStackFromContainer(container);
        if (storedEssentia != null && container instanceof TileJarFillable ? aspectToFill != storedEssentia.aspect : !container.doesContainerAccept(aspectToFill)) {
            return 0L;
        }
        int containerCurrentCapacity = this.getContainerCapacity(container) - this.getContainerStoredAmount(container);
        if (amountToFill > containerCurrentCapacity) {
            amountToFill = containerCurrentCapacity;
        }
        if (mode == Actionable.MODULATE) {
            int remaining = container.addToContainer(aspectToFill, amountToFill);
            amountToFill -= remaining;
        }
        return amountToFill;
    }

    public long injectFluidIntoContainer(IAspectContainer container, IAEFluidStack fluidStack, Actionable mode) {
        if (fluidStack == null) {
            return 0L;
        }
        if (!this.perms.canInjectToAspectContainerTile(container)) {
            return 0L;
        }
        Fluid fluid = fluidStack.getFluid();
        if (!(fluid instanceof GaseousEssentia)) {
            return 0L;
        }
        Aspect gasAspect = ((GaseousEssentia)fluid).getAspect();
        long amountToFill = EssentiaConversionHelper.INSTANCE.convertFluidAmountToEssentiaAmount(fluidStack.getStackSize());
        long injectedAmount_EU = this.injectEssentiaIntoContainer(container, (int)amountToFill, gasAspect, mode);
        return EssentiaConversionHelper.INSTANCE.convertEssentiaAmountToFluidAmount(injectedAmount_EU);
    }

    public void registerDefaultContainers() {
        this.perms.addAspectContainerTileToExtractPermissions(TileAlembic.class, 32);
        this.perms.addAspectContainerTileToExtractPermissions(TileCentrifuge.class, 0);
        this.perms.addAspectContainerTileToBothPermissions(TileJarFillable.class, 64);
        this.perms.addAspectContainerTileToBothPermissions(TileJarFillableVoid.class, 64);
        this.perms.addAspectContainerTileToExtractPermissions(TileTubeBuffer.class, 8);
        this.perms.addAspectContainerTileToBothPermissions(TileEssentiaReservoir.class, 256);
        this.perms.addAspectContainerTileToExtractPermissions(TileAlchemyFurnaceAdvancedNozzle.class, 0);
        this.perms.addAspectContainerTileToInjectPermissions(TileEssentiaVibrationChamber.class, 64);
    }
}

