/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration;

import appeng.api.config.Upgrades;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.tileentities.TileEssentiaProvider;
import thaumicenergistics.util.EffectiveSide;
import thaumicenergistics.util.ThELog;

public final class IntegrationCore {
    private static final String CLASS_PATH = "thaumicenergistics.integration.Module";
    private static final String MODID_WAILA = "Waila";
    private static final String MODID_NEI = "NEI";
    private static final String MODID_EC2 = "EC2";
    private static final String MODID_CC = "CC";

    @SideOnly(value=Side.CLIENT)
    private static void integrateWithClientMods() {
        IntegrationCore.integrateWithVersionChecker();
        IntegrationCore.integrateWithMod(MODID_NEI);
        IntegrationCore.integrateWithMod(MODID_WAILA);
    }

    private static void integrateWithMod(String modID) {
        try {
            Class<?> module = Class.forName(CLASS_PATH + modID);
            module.newInstance();
            ThELog.info("Successfully integrated with %s", modID);
        }
        catch (Throwable e) {
            ThELog.warning("Skipping integration with %s", modID);
        }
    }

    private static void integrateWithVersionChecker() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("curseProjectName", "223666-thaumic-energistics");
        tag.func_74778_a("curseFilenameParser", "thaumicenergistics-[].jar");
        tag.func_74778_a("modDisplayName", "Thaumic Energistics");
        FMLInterModComms.sendRuntimeMessage((Object)"thaumicenergistics", (String)"VersionChecker", (String)"addCurseCheck", (NBTTagCompound)tag);
    }

    public static void init() {
        long startTime = ThELog.beginSection("Integration");
        try {
            if (EffectiveSide.isClientSide()) {
                IntegrationCore.integrateWithClientMods();
            }
            if (ThEApi.instance().config().blacklistEssentiaFluidInExtraCells()) {
                IntegrationCore.integrateWithMod(MODID_EC2);
            }
            IntegrationCore.integrateWithMod(MODID_CC);
            FMLInterModComms.sendMessage((String)"ThaumicTinkerer", (String)"AddCCBlacklist", (String)TileEssentiaProvider.class.getName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Upgrades.SPEED.registerItem(ThEApi.instance().blocks().ArcaneAssembler.getStack(), 4);
        ThELog.endSection("Integration", startTime);
    }
}

