/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui.widget;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.lib.UtilsFX;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.gui.widget.AbstractWidget;
import thaumicenergistics.gui.widget.IWidgetHost;
import thaumicenergistics.util.GuiHelper;

public abstract class AbstractAspectWidget
extends AbstractWidget {
    private static final ResourceLocation UNKNOWN_TEXTURE = new ResourceLocation("thaumcraft", "textures/aspects/_unknown.png");
    private Aspect aspect;
    private boolean hasDiscovered = false;
    protected String aspectName = "";
    private EntityPlayer player;
    private byte[] aspectColorBytes;

    public AbstractAspectWidget(IWidgetHost hostGui, Aspect aspect, int xPos, int yPos, EntityPlayer player) {
        super(hostGui, xPos, yPos);
        this.player = player;
        this.setAspect(aspect);
    }

    protected void drawAspect() {
        if (this.aspect == null) {
            return;
        }
        if (this.hasDiscovered) {
            UtilsFX.drawTag((int)(this.xPosition + 1), (int)(this.yPosition + 1), (Aspect)this.aspect, (float)0.0f, (int)0, (double)this.field_73735_i);
        } else {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(UNKNOWN_TEXTURE);
            GL11.glColor4ub((byte)this.aspectColorBytes[1], (byte)this.aspectColorBytes[2], (byte)this.aspectColorBytes[3], (byte)this.aspectColorBytes[0]);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            UtilsFX.drawTexturedQuadFull((int)(this.xPosition + 1), (int)(this.yPosition + 1), (double)this.field_73735_i);
            GL11.glDisable((int)3042);
        }
    }

    public Aspect getAspect() {
        return this.aspect;
    }

    public void setAspect(Aspect aspect) {
        this.aspect = aspect;
        if (aspect == null) {
            return;
        }
        AspectStack stack = new AspectStack(aspect, 1L);
        this.aspectName = stack.getAspectName(this.player);
        this.hasDiscovered = stack.hasPlayerDiscovered(this.player);
        this.aspectColorBytes = GuiHelper.INSTANCE.convertPackedColorToARGB(aspect.getColor());
        this.aspectColorBytes[0] = -1;
    }
}

