/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui.abstraction;

import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiScrollbar;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import thaumicenergistics.gui.abstraction.AbstractGuiBase;
import thaumicenergistics.util.GuiHelper;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractGuiWithScrollbar
extends AbstractGuiBase {
    protected final GuiScrollbar scrollBar = new GuiScrollbar();
    private AEBaseGui aeGuiBridge;
    private boolean isScrollBarHeld = false;
    private int scrollHeldPrevY = 0;
    private ScrollbarParams scrollParams;

    public AbstractGuiWithScrollbar(Container container) {
        super(container);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.scrollBar.draw(this.aeGuiBridge);
    }

    protected abstract ScrollbarParams getScrollbarParameters();

    protected void func_73869_a(char key, int keyID) {
        if (keyID == 199) {
            this.scrollBar.click(this.aeGuiBridge, this.scrollParams.scrollbarPosX + 1, this.scrollParams.scrollbarPosY + 1);
            this.scrollBar.wheel(1);
            this.onScrollbarMoved();
        } else if (keyID == 207) {
            this.scrollBar.click(this.aeGuiBridge, this.scrollParams.scrollbarPosX + 1, this.scrollParams.scrollbarVerticalBound);
            this.onScrollbarMoved();
        } else if (keyID == 200) {
            this.scrollBar.wheel(1);
            this.onScrollbarMoved();
        } else if (keyID == 208) {
            this.scrollBar.wheel(-1);
            this.onScrollbarMoved();
        } else {
            super.func_73869_a(key, keyID);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (GuiHelper.INSTANCE.isPointInGuiRegion(this.scrollParams.scrollbarPosY, this.scrollParams.scrollbarPosX, this.scrollParams.scrollbarHeight, this.scrollBar.getWidth(), mouseX, mouseY, this.field_147003_i, this.field_147009_r)) {
            this.isScrollBarHeld = true;
            this.scrollHeldPrevY = mouseY;
            this.scrollBar.click(this.aeGuiBridge, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            this.onScrollbarMoved();
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected abstract void onScrollbarMoved();

    protected void setScrollBarHeight(int newHeight) {
        this.scrollParams.setHeight(newHeight);
        this.scrollBar.setHeight(newHeight);
    }

    public void func_73863_a(int mouseX, int mouseY, float mouseBtn) {
        super.func_73863_a(mouseX, mouseY, mouseBtn);
        if (this.isScrollBarHeld) {
            if (Mouse.isButtonDown((int)0)) {
                if (mouseY == this.scrollHeldPrevY) {
                    return;
                }
                boolean correctForZero = false;
                this.scrollHeldPrevY = mouseY;
                int repY = mouseY - this.field_147009_r;
                if (repY > this.scrollParams.scrollbarVerticalBound) {
                    repY = this.scrollParams.scrollbarVerticalBound;
                } else if (repY <= this.scrollParams.scrollbarPosY) {
                    repY = this.scrollParams.scrollbarPosY;
                    correctForZero = true;
                }
                this.scrollBar.click(this.aeGuiBridge, this.scrollParams.scrollbarPosX + 1, repY);
                if (correctForZero) {
                    this.scrollBar.wheel(1);
                }
                this.onScrollbarMoved();
            } else {
                this.isScrollBarHeld = false;
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.scrollParams = this.getScrollbarParameters();
        this.scrollBar.setLeft(this.scrollParams.scrollbarPosX).setTop(this.scrollParams.scrollbarPosY).setHeight(this.scrollParams.scrollbarHeight);
        this.scrollBar.setRange(0, 0, 1);
        this.aeGuiBridge = new AEBaseGui(this.field_147002_h){

            public void bindTexture(String file) {
                this.bindTexture("appliedenergistics2", file);
            }

            public void bindTexture(String base, String file) {
                AbstractGuiWithScrollbar.this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation(base, "textures/" + file));
            }

            public void drawBG(int arg0, int arg1, int arg2, int arg3) {
            }

            public void drawFG(int arg0, int arg1, int arg2, int arg3) {
            }

            public void func_73729_b(int posX, int posY, int sourceOffsetX, int sourceOffsetY, int width, int height) {
                AbstractGuiWithScrollbar.this.func_73729_b(posX, posY, sourceOffsetX, sourceOffsetY, width, height);
            }
        };
    }

    public class ScrollbarParams {
        int scrollbarPosX;
        int scrollbarPosY;
        int scrollbarHeight;
        int scrollbarVerticalBound;

        public ScrollbarParams(int x, int y, int height) {
            this.scrollbarPosX = x;
            this.scrollbarPosY = y;
            this.setHeight(height);
        }

        void setHeight(int height) {
            this.scrollbarHeight = height;
            this.scrollbarVerticalBound = this.scrollbarHeight + this.scrollbarPosY;
        }
    }
}

