/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.storage.ITerminalHost;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.helpers.IPriorityHost;
import cpw.mods.fml.common.network.IGuiHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.ThaumicEnergistics;
import thaumicenergistics.api.ICraftingIssuerTerminalHost;
import thaumicenergistics.container.ContainerArcaneAssembler;
import thaumicenergistics.container.ContainerEssentiaCell;
import thaumicenergistics.container.ContainerEssentiaCellWorkbench;
import thaumicenergistics.container.ContainerEssentiaVibrationChamber;
import thaumicenergistics.container.ContainerKnowledgeInscriber;
import thaumicenergistics.container.ContainerPriority;
import thaumicenergistics.container.ContainerWirelessEssentiaTerminal;
import thaumicenergistics.gui.GuiArcaneAssembler;
import thaumicenergistics.gui.GuiCraftAmountBridge;
import thaumicenergistics.gui.GuiCraftConfirmBridge;
import thaumicenergistics.gui.GuiEssentiaCellTerminal;
import thaumicenergistics.gui.GuiEssentiaCellWorkbench;
import thaumicenergistics.gui.GuiEssentiaVibrationChamber;
import thaumicenergistics.gui.GuiKnowledgeInscriber;
import thaumicenergistics.gui.GuiPriority;
import thaumicenergistics.inventory.HandlerWirelessEssentiaTerminal;
import thaumicenergistics.parts.AbstractAEPartBase;

public class ThEGuiHandler
implements IGuiHandler {
    private static final int DIRECTION_OFFSET = ForgeDirection.values().length;
    private static final int ID_STEP_VALUE = 10;
    public static final int ESSENTIA_CELL_ID = 10;
    public static final int PRIORITY_ID = 20;
    public static final int CELL_WORKBENCH_ID = 30;
    public static final int WIRELESS_TERMINAL_ID = 40;
    public static final int ARCANE_ASSEMBLER_ID = 50;
    public static final int KNOWLEDGE_INSCRIBER = 60;
    public static final int ESSENTIA_VIBRATION_CHAMBER = 70;
    public static final int AUTO_CRAFTING_AMOUNT = 80;
    public static final int AUTO_CRAFTING_CONFIRM = 90;
    private static Object[] extraData = null;

    private static IPart getPart(ForgeDirection tileSide, World world, int x, int y, int z) {
        IPartHost partHost = (IPartHost)world.func_147438_o(x, y, z);
        if (partHost == null) {
            return null;
        }
        return partHost.getPart(tileSide);
    }

    private static IPart getPartFromSidedID(int ID, World world, int x, int y, int z) {
        ForgeDirection side = ForgeDirection.getOrientation((int)(ID % 10));
        return ThEGuiHandler.getPart(side, world, x, y, z);
    }

    private static Object getPartGuiElement(ForgeDirection tileSide, EntityPlayer player, World world, int x, int y, int z, boolean isServerSide) {
        AbstractAEPartBase part = (AbstractAEPartBase)ThEGuiHandler.getPart(tileSide, world, x, y, z);
        if (part == null) {
            return null;
        }
        if (isServerSide) {
            return part.getServerGuiElement(player);
        }
        return part.getClientGuiElement(player);
    }

    private static boolean isIDInRange(int ID, int BaseID) {
        return ID >= BaseID && ID < BaseID + 10;
    }

    public static int generateSidedID(int ID, ForgeDirection side) {
        return ID + side.ordinal();
    }

    public static void launchGui(AbstractAEPartBase part, EntityPlayer player, World world, int x, int y, int z) {
        if (part.doesPlayerHavePermissionToOpenGui(player)) {
            player.openGui((Object)ThaumicEnergistics.INSTANCE, part.getSide().ordinal(), world, x, y, z);
        }
    }

    public static void launchGui(int ID, EntityPlayer player, World world, int x, int y, int z) {
        player.openGui((Object)ThaumicEnergistics.INSTANCE, ID + DIRECTION_OFFSET, world, x, y, z);
    }

    public static void launchGui(int ID, EntityPlayer player, World world, int x, int y, int z, Object[] extraData) {
        ThEGuiHandler.extraData = extraData;
        player.openGui((Object)ThaumicEnergistics.INSTANCE, ID + DIRECTION_OFFSET, world, x, y, z);
        ThEGuiHandler.extraData = null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ID);
        if (world != null && side != ForgeDirection.UNKNOWN) {
            return ThEGuiHandler.getPartGuiElement(side, player, world, x, y, z, false);
        }
        switch (ID -= DIRECTION_OFFSET) {
            case 10: {
                return GuiEssentiaCellTerminal.NewEssentiaCellGui(player, world, x, y, z);
            }
            case 30: {
                return new GuiEssentiaCellWorkbench(player, world, x, y, z);
            }
            case 40: {
                return GuiEssentiaCellTerminal.NewWirelessEssentiaTerminalGui(player);
            }
            case 50: {
                return new GuiArcaneAssembler(player, world, x, y, z);
            }
            case 60: {
                return new GuiKnowledgeInscriber(player, world, x, y, z);
            }
            case 70: {
                return new GuiEssentiaVibrationChamber(player, world, x, y, z);
            }
        }
        if (ThEGuiHandler.isIDInRange(ID, 20)) {
            IPart part = ThEGuiHandler.getPartFromSidedID(ID, world, x, y, z);
            if (part == null || !(part instanceof IPriorityHost)) {
                return null;
            }
            return new GuiPriority((IPriorityHost)part, player);
        }
        if (ThEGuiHandler.isIDInRange(ID, 80)) {
            IPart part = ThEGuiHandler.getPartFromSidedID(ID, world, x, y, z);
            if (part == null || !(part instanceof ICraftingIssuerTerminalHost)) {
                return null;
            }
            return new GuiCraftAmountBridge(player, (ICraftingIssuerTerminalHost)part);
        }
        if (ThEGuiHandler.isIDInRange(ID, 90)) {
            IPart part = ThEGuiHandler.getPartFromSidedID(ID, world, x, y, z);
            if (part == null || !(part instanceof ICraftingIssuerTerminalHost)) {
                return null;
            }
            return new GuiCraftConfirmBridge(player, (ICraftingIssuerTerminalHost)part);
        }
        return null;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ID);
        if (world != null && side != ForgeDirection.UNKNOWN) {
            return ThEGuiHandler.getPartGuiElement(side, player, world, x, y, z, true);
        }
        switch (ID -= DIRECTION_OFFSET) {
            case 10: {
                return new ContainerEssentiaCell(player, world, x, y, z);
            }
            case 30: {
                return new ContainerEssentiaCellWorkbench(player, world, x, y, z);
            }
            case 40: {
                HandlerWirelessEssentiaTerminal handler = (HandlerWirelessEssentiaTerminal)extraData[0];
                return new ContainerWirelessEssentiaTerminal(player, handler);
            }
            case 50: {
                return new ContainerArcaneAssembler(player, world, x, y, z);
            }
            case 60: {
                return new ContainerKnowledgeInscriber(player, world, x, y, z);
            }
            case 70: {
                return new ContainerEssentiaVibrationChamber(player, world, x, y, z);
            }
        }
        if (ThEGuiHandler.isIDInRange(ID, 20)) {
            IPart part = ThEGuiHandler.getPartFromSidedID(ID, world, x, y, z);
            if (part == null || !(part instanceof IPriorityHost)) {
                return null;
            }
            return new ContainerPriority((IPriorityHost)part, player);
        }
        if (ThEGuiHandler.isIDInRange(ID, 80)) {
            IPart part = ThEGuiHandler.getPartFromSidedID(ID, world, x, y, z);
            if (part == null || !(part instanceof ICraftingIssuerTerminalHost)) {
                return null;
            }
            return new ContainerCraftAmount(player.field_71071_by, (ITerminalHost)((ICraftingIssuerTerminalHost)part));
        }
        if (ThEGuiHandler.isIDInRange(ID, 90)) {
            IPart part = ThEGuiHandler.getPartFromSidedID(ID, world, x, y, z);
            if (part == null || !(part instanceof ICraftingIssuerTerminalHost)) {
                return null;
            }
            return new ContainerCraftConfirm(player.field_71071_by, (ITerminalHost)((ICraftingIssuerTerminalHost)part));
        }
        return null;
    }
}

