/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.fx.ParticleEngine;

@SideOnly(value=Side.CLIENT)
public enum GuiParticle {
    Orb(ParticleEngine.particleTexture, 0, 128, 16, 16, 16, 0, 16),
    Rune(ParticleEngine.particleTexture, 0, 96, 16, 16, 16, 0, 16),
    Wispy(ParticleEngine.particleTexture, 0, 80, 16, 16, 16, 0, 16),
    Knowledge(ParticleEngine.particleTexture, 0, 64, 16, 16, 16, 0, 4);

    private int txU;
    private int txV;
    private int width;
    private int height;
    private int animationUStep;
    private int animationVStep;
    private int FrameCount;
    private ResourceLocation texture;

    private GuiParticle(ResourceLocation textureLocation, int U, int V, int width, int height, int UStep, int VStep, int Frames) {
        this.texture = textureLocation;
        this.txU = U;
        this.txV = V;
        this.width = width;
        this.height = height;
        this.animationUStep = UStep;
        this.animationVStep = VStep;
        this.FrameCount = Frames;
    }

    public static void finishDraw() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    public void drawParticle(Gui gui, int positionX, int positionY, int frameNumber, float red, float green, float blue, boolean needsPrepare) {
        if (needsPrepare) {
            this.prepareDraw();
        }
        int frameIndex = frameNumber % this.FrameCount;
        int U = this.txU + this.animationUStep * frameIndex;
        int V = this.txV + this.animationVStep * frameIndex;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)0.9f);
        gui.func_73729_b(positionX, positionY, U, V, this.width, this.height);
        if (needsPrepare) {
            GuiParticle.finishDraw();
        }
    }

    public void prepareDraw() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
    }
}

