/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.container.ContainerEssentiaCellWorkbench;
import thaumicenergistics.gui.abstraction.AbstractGuiBase;
import thaumicenergistics.gui.buttons.GuiButtonClearCellPartitioning;
import thaumicenergistics.gui.buttons.GuiButtonSetCellPartitioningToCurrent;
import thaumicenergistics.gui.widget.WidgetAspectSlot;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.network.IAspectSlotGui;
import thaumicenergistics.network.packet.server.Packet_S_EssentiaCellWorkbench;
import thaumicenergistics.registries.ThEStrings;
import thaumicenergistics.texture.AEStateIconsEnum;
import thaumicenergistics.texture.GuiTextureManager;
import thaumicenergistics.tileentities.TileEssentiaCellWorkbench;

@SideOnly(value=Side.CLIENT)
public class GuiEssentiaCellWorkbench
extends AbstractGuiBase
implements IAspectSlotGui {
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 251;
    private static final int TITLE_POS_X = 6;
    private static final int TITLE_POS_Y = 6;
    private static final int WIDGET_POS_X = 7;
    private static final int WIDGET_POS_Y = 28;
    private static final int WIDGETS_PER_ROW = 9;
    private static final int WIDGET_ROWS = 7;
    private static final int NUMBER_OF_WIDGETS = 63;
    private static final AEStateIconsEnum CELL_BG_ICON = AEStateIconsEnum.ME_CELL_BACKGROUND;
    private static final int BUTTON_PARTITION_CURRENT_ID = 0;
    private static final int BUTTON_PARTITION_CURRENT_X = -18;
    private static final int BUTTON_PARTITION_CURRENT_Y = 28;
    private static final int BUTTON_CLEAR_ID = 1;
    private static final int BUTTON_CLEAR_X = -18;
    private static final int BUTTON_CLEAR_Y = 8;
    private final EntityPlayer player;
    private final String title;
    private final SimpleAspectWidget[] partitionWidgets;
    public final TileEssentiaCellWorkbench workbench;

    public GuiEssentiaCellWorkbench(EntityPlayer player, World world, int x, int y, int z) {
        super(new ContainerEssentiaCellWorkbench(player, world, x, y, z));
        this.player = player;
        this.field_146999_f = 176;
        this.field_147000_g = 251;
        this.title = ThEStrings.Gui_TitleEssentiaCellWorkbench.getLocalized();
        this.partitionWidgets = new SimpleAspectWidget[63];
        this.workbench = ((ContainerEssentiaCellWorkbench)this.field_147002_h).workbench;
    }

    protected void func_146976_a(float alpha, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiTextureManager.CELL_WORKBENCH.getTexture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AEStateIconsEnum.AE_STATES_TEXTURE);
        this.func_73729_b(this.field_147003_i + ContainerEssentiaCellWorkbench.CELL_SLOT_X, this.field_147009_r + ContainerEssentiaCellWorkbench.CELL_SLOT_Y, CELL_BG_ICON.getU(), CELL_BG_ICON.getV(), CELL_BG_ICON.getWidth(), CELL_BG_ICON.getHeight());
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.title, 6, 6, 0);
        WidgetAspectSlot widgetUnderMouse = null;
        for (int index = 0; index < 63; ++index) {
            SimpleAspectWidget currentWidget = this.partitionWidgets[index];
            currentWidget.drawWidget();
            if (widgetUnderMouse != null || !currentWidget.isMouseOverWidget(mouseX, mouseY)) continue;
            widgetUnderMouse = currentWidget;
        }
        if (widgetUnderMouse != null) {
            widgetUnderMouse.getTooltip(this.tooltip);
        } else {
            this.addTooltipFromButtons(mouseX, mouseY);
        }
        if (this.tooltip.size() > 0) {
            this.drawTooltip(mouseX - this.field_147003_i, mouseY - this.field_147009_r, true);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (SimpleAspectWidget partitionWidget : this.partitionWidgets) {
            if (!partitionWidget.isMouseOverWidget(mouseX, mouseY)) continue;
            Aspect itemAspect = EssentiaItemContainerHelper.INSTANCE.getFilterAspectFromItem(this.player.field_71071_by.func_70445_o());
            Aspect widgetAspect = partitionWidget.getAspect();
            if (widgetAspect == null && itemAspect != null) {
                Packet_S_EssentiaCellWorkbench.sendAddAspect(this.player, this.workbench, itemAspect);
                break;
            }
            if (widgetAspect != null && itemAspect == null) {
                Packet_S_EssentiaCellWorkbench.sendRemoveAspect(this.player, this.workbench, widgetAspect);
                break;
            }
            if (widgetAspect == null || itemAspect == null) break;
            Packet_S_EssentiaCellWorkbench.sendReplaceAspect(this.player, this.workbench, widgetAspect, itemAspect);
            break;
        }
    }

    @Override
    protected void onButtonClicked(GuiButton button, int mouseButton) {
        switch (button.field_146127_k) {
            case 1: {
                Packet_S_EssentiaCellWorkbench.sendClearPartitioning(this.player, this.workbench);
                break;
            }
            case 0: {
                Packet_S_EssentiaCellWorkbench.sendPartitionToContents(this.player, this.workbench);
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (int y = 0; y < 7; ++y) {
            int rowYPosition = 28 + y * 18;
            for (int x = 0; x < 9; ++x) {
                int wPosX = 7 + x * 18;
                int wIndex = x + y * 9;
                this.partitionWidgets[wIndex] = new SimpleAspectWidget(wIndex, wPosX, rowYPosition, this.player);
            }
        }
        this.field_146292_n.add(new GuiButtonSetCellPartitioningToCurrent(0, this.field_147003_i + -18, this.field_147009_r + 28));
        this.field_146292_n.add(new GuiButtonClearCellPartitioning(1, this.field_147003_i + -18, this.field_147009_r + 8));
        Packet_S_EssentiaCellWorkbench.sendGetPartitionList(this.player, this.workbench);
    }

    @Override
    public void updateAspects(List<Aspect> aspectList) {
        int index;
        int count = aspectList.size();
        for (index = 0; index < count; ++index) {
            this.partitionWidgets[index].setAspect(aspectList.get(index));
        }
        for (index = count; index < 63; ++index) {
            this.partitionWidgets[index].setAspect(null);
        }
    }

    private class SimpleAspectWidget
    extends WidgetAspectSlot {
        public SimpleAspectWidget(int ID, int posX, int posY, EntityPlayer player) {
            super(GuiEssentiaCellWorkbench.this, player, null, ID, posX, posY);
        }

        @Override
        public void mouseClicked(Aspect withAspect) {
        }
    }
}

