/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.grid;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPostCacheConstruction;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import java.util.HashMap;
import java.util.HashSet;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.grid.EssentiaMonitor;
import thaumicenergistics.grid.EssentiaWatcher;
import thaumicenergistics.grid.IEssentiaGrid;
import thaumicenergistics.grid.IEssentiaWatcher;
import thaumicenergistics.grid.IEssentiaWatcherHost;
import thaumicenergistics.grid.IMEEssentiaMonitor;
import thaumicenergistics.grid.IMEEssentiaMonitorReceiver;

public class GridEssentiaCache
extends EssentiaMonitor
implements IEssentiaGrid {
    private final IGrid internalGrid;
    private final WatcherManager watcherManger;

    public GridEssentiaCache(IGrid grid) {
        this.internalGrid = grid;
        this.watcherManger = new WatcherManager();
    }

    public void addNode(IGridNode gridNode, IGridHost machine) {
        if (machine instanceof IEssentiaWatcherHost) {
            IEssentiaWatcherHost host = (IEssentiaWatcherHost)machine;
            EssentiaWatcher watcher = new EssentiaWatcher(this.watcherManger, host);
            this.watcherManger.addWatcher(gridNode, watcher);
            host.updateWatcher(watcher);
        }
    }

    @MENetworkEventSubscribe
    public void onGridCacheReady(MENetworkPostCacheConstruction event) {
        IStorageGrid storage = (IStorageGrid)this.internalGrid.getCache(IStorageGrid.class);
        this.wrap((IMEMonitor<IAEFluidStack>)storage.getFluidInventory(), (IEnergyGrid)this.internalGrid.getCache(IEnergyGrid.class), this.internalGrid);
    }

    public void onJoin(IGridStorage sourceStorage) {
        this.cacheNeedsUpdate = true;
    }

    public void onSplit(IGridStorage destinationStorage) {
    }

    public void onUpdateTick() {
        try {
            if (this.cacheNeedsUpdate && this.listeners.size() > 0) {
                this.updateCacheToMatchNetwork();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void populateGridStorage(IGridStorage destinationStorage) {
    }

    public void removeNode(IGridNode gridNode, IGridHost machine) {
        if (machine instanceof IEssentiaWatcherHost) {
            this.watcherManger.removeWatcher(gridNode);
        }
    }

    public class WatcherManager
    implements IMEEssentiaMonitorReceiver {
        private HashMap<IGridNode, IEssentiaWatcher> watchers = new HashMap();
        private HashMap<Aspect, HashSet<IEssentiaWatcher>> watchedAspects = new HashMap();
        private boolean isListeningForChanges = false;

        public void addWatcher(IGridNode node, IEssentiaWatcher watcher) {
            this.watchers.put(node, watcher);
            if (!this.isListeningForChanges) {
                GridEssentiaCache.this.addListener(this, null);
                this.isListeningForChanges = true;
            }
        }

        @Override
        public boolean isValid(Object verificationToken) {
            return this.isListeningForChanges;
        }

        public void onWatcherAddAspect(IEssentiaWatcher watcher, Aspect aspect) {
            HashSet<Object> aWatchers;
            if (!this.watchedAspects.containsKey(aspect)) {
                aWatchers = new HashSet();
                this.watchedAspects.put(aspect, aWatchers);
            } else {
                aWatchers = this.watchedAspects.get(aspect);
            }
            aWatchers.add(watcher);
        }

        public void onWatcherCleared(IEssentiaWatcher watcher, HashSet<Aspect> previouslyTrackedAspects) {
            for (Aspect aspect : previouslyTrackedAspects) {
                this.onWatcherRemoveAspect(watcher, aspect);
            }
        }

        public void onWatcherRemoveAspect(IEssentiaWatcher watcher, Aspect aspect) {
            HashSet<IEssentiaWatcher> aWatchers = this.watchedAspects.get(aspect);
            if (aWatchers != null) {
                aWatchers.remove(watcher);
                if (aWatchers.isEmpty()) {
                    this.watchedAspects.remove(aspect);
                }
            }
        }

        @Override
        public void postChange(IMEEssentiaMonitor fromMonitor, Iterable<AspectStack> changes) {
            if (this.watchedAspects.isEmpty()) {
                return;
            }
            for (AspectStack change : changes) {
                if (!this.watchedAspects.containsKey(change.aspect)) continue;
                HashSet<IEssentiaWatcher> watcherSet = this.watchedAspects.get(change.aspect);
                long fullAmount = GridEssentiaCache.this.getEssentiaAmount(change.aspect);
                for (IEssentiaWatcher watcher : watcherSet) {
                    IEssentiaWatcherHost host = watcher.getHost();
                    if (host == null) continue;
                    host.onEssentiaChange(change.aspect, fullAmount, change.stackSize);
                }
            }
        }

        public void removeWatcher(IGridNode node) {
            IEssentiaWatcher watcher = this.watchers.get(node);
            if (watcher != null) {
                watcher.clear();
                this.watchers.remove(node);
                if (this.watchers.isEmpty()) {
                    this.watchedAspects.clear();
                    GridEssentiaCache.this.removeListener(this);
                    this.isListeningForChanges = false;
                }
            }
        }
    }
}

