/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.grid;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.BaseActionSource;
import java.util.Collection;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.grid.EssentiaMonitor;
import thaumicenergistics.grid.IMEEssentiaMonitor;
import thaumicenergistics.grid.IMEEssentiaMonitorReceiver;

public class EssentiaPassThroughMonitor
extends EssentiaMonitor {
    private final IMEEssentiaMonitor internalMonitor;

    public EssentiaPassThroughMonitor(IMEEssentiaMonitor source, IEnergyGrid energyGrid) {
        this.internalMonitor = source;
        this.energyGrid = energyGrid;
    }

    @Override
    public void addListener(IMEEssentiaMonitorReceiver listener, Object verificationToken) {
        this.internalMonitor.addListener(listener, verificationToken);
    }

    @Override
    public long extractEssentia(Aspect aspect, long amount, Actionable mode, BaseActionSource source, boolean powered) {
        double powerRequest;
        double powerReceived;
        if (powered && (powerReceived = this.energyGrid.extractAEPower(powerRequest = 0.3 * (double)amount, Actionable.SIMULATE, PowerMultiplier.CONFIG)) < powerRequest) {
            return 0L;
        }
        long extractedAmount = this.internalMonitor.extractEssentia(aspect, amount, mode, source, false);
        if (extractedAmount > 0L && powered && mode == Actionable.MODULATE) {
            this.energyGrid.extractAEPower(0.3 * (double)extractedAmount, Actionable.MODULATE, PowerMultiplier.CONFIG);
        }
        return extractedAmount;
    }

    @Override
    public long getEssentiaAmount(Aspect aspect) {
        return this.internalMonitor.getEssentiaAmount(aspect);
    }

    @Override
    public Collection<AspectStack> getEssentiaList() {
        return this.internalMonitor.getEssentiaList();
    }

    @Override
    public long injectEssentia(Aspect aspect, long amount, Actionable mode, BaseActionSource source, boolean powered) {
        double powerRequest;
        double powerReceived;
        if (powered && (powerReceived = this.energyGrid.extractAEPower(powerRequest = 0.3 * (double)amount, Actionable.SIMULATE, PowerMultiplier.CONFIG)) < powerRequest) {
            return 0L;
        }
        long rejectedAmount = this.internalMonitor.injectEssentia(aspect, amount, mode, source, false);
        long injectedAmount = amount - rejectedAmount;
        if (injectedAmount > 0L && powered && mode == Actionable.MODULATE) {
            this.energyGrid.extractAEPower(0.3 * (double)injectedAmount, Actionable.MODULATE, PowerMultiplier.CONFIG);
        }
        return rejectedAmount;
    }

    @Override
    public void removeListener(IMEEssentiaMonitorReceiver listener) {
        this.internalMonitor.removeListener(listener);
    }
}

