/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.features;

import net.minecraft.util.ResourceLocation;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;
import thaumicenergistics.features.AbstractBasicFeature;
import thaumicenergistics.registries.ResearchRegistry;

public class FeatureResearchSetup
extends AbstractBasicFeature {
    private static final ResourceLocation RESEARCH_BACKGROUND = new ResourceLocation("thaumicenergistics", "textures/research/Research.Background.png");
    private static final ResourceLocation TAB_ICON = new ResourceLocation("thaumicenergistics", "textures/research/tab.icon.png");
    private boolean hasFinalizedResearch = false;

    public FeatureResearchSetup() {
        super(true);
    }

    @Override
    protected void registerResearch() {
        ResearchCategories.registerCategory((String)"thaumicenergistics", (ResourceLocation)TAB_ICON, (ResourceLocation)RESEARCH_BACKGROUND);
        ResearchRegistry.ResearchTypes.BASIC.researchItem = new ResearchItem(ResearchRegistry.ResearchTypes.BASIC.getKey(), "thaumicenergistics", new AspectList(), 0, 0, 0, TAB_ICON);
        ResearchRegistry.ResearchTypes.BASIC.researchItem.setPages(new ResearchPage[]{new ResearchPage(ResearchRegistry.ResearchTypes.BASIC.getPageName(1))});
        ResearchRegistry.ResearchTypes.BASIC.researchItem.setStub().setRound().setAutoUnlock();
        ResearchRegistry.ResearchTypes.BASIC.researchItem.registerResearchItem();
    }

    public void finalizeRegistration(AbstractBasicFeature[] featureList) {
        if (this.hasFinalizedResearch) {
            return;
        }
        for (AbstractBasicFeature feature : featureList) {
            if (!feature.isAvailable()) continue;
            for (ResearchRegistry.PseudoResearchTypes type : feature.getPseudoParentTypes()) {
                type.registerPsudeoResearch();
            }
        }
        this.hasFinalizedResearch = true;
    }

    @Override
    public String getFirstValidParentKey(boolean includeSelf) {
        if (includeSelf) {
            return ResearchRegistry.ResearchTypes.BASIC.getKey();
        }
        return "";
    }
}

