/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.container.ContainerWithPlayerInventory;
import thaumicenergistics.container.slot.SlotRestrictive;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.tileentities.TileEssentiaCellWorkbench;
import thaumicenergistics.util.EffectiveSide;

public class ContainerEssentiaCellWorkbench
extends ContainerWithPlayerInventory {
    private static int PLAYER_INV_POSITION_Y = 169;
    private static int HOTBAR_INV_POSITION_Y = PLAYER_INV_POSITION_Y + 58;
    public static int CELL_SLOT_X = 152;
    public static int CELL_SLOT_Y = 8;
    private EntityPlayer player;
    public final TileEssentiaCellWorkbench workbench;
    private final int cellSlotIndex;

    public ContainerEssentiaCellWorkbench(EntityPlayer player, World world, int x, int y, int z) {
        this.player = player;
        this.workbench = (TileEssentiaCellWorkbench)world.func_147438_o(x, y, z);
        SlotRestrictive cellSlot = new SlotRestrictive(this.workbench, 0, CELL_SLOT_X, CELL_SLOT_Y);
        this.func_75146_a(cellSlot);
        this.cellSlotIndex = cellSlot.field_75222_d;
        this.bindPlayerInventory((IInventory)this.player.field_71071_by, PLAYER_INV_POSITION_Y, HOTBAR_INV_POSITION_Y);
        if (EffectiveSide.isServerSide()) {
            this.workbench.registerContainer(this);
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void onCellChanged() {
        this.workbench.onClientRequestPartitionList(this.player);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (EffectiveSide.isServerSide()) {
            this.workbench.removeContainer(this);
        }
    }

    public void onForceSyncCell() {
        this.func_75139_a(this.cellSlotIndex).func_75218_e();
        this.func_75142_b();
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        if (EffectiveSide.isClientSide()) {
            return null;
        }
        Slot slot = (Slot)this.field_75151_b.get(slotNumber);
        if (slot != null && slot.func_75216_d()) {
            boolean didMerge = false;
            ItemStack slotStack = slot.func_75211_c();
            if (slotNumber == this.cellSlotIndex) {
                didMerge = this.mergeSlotWithPlayerInventory(slotStack);
            } else if (this.slotClickedWasInPlayerInventory(slotNumber) || this.slotClickedWasInHotbarInventory(slotNumber)) {
                Slot cellSlot = (Slot)this.field_75151_b.get(this.cellSlotIndex);
                if (!cellSlot.func_75216_d() && cellSlot.func_75214_a(slotStack)) {
                    cellSlot.func_75215_d(slotStack.func_77946_l());
                    slotStack.field_77994_a = 0;
                    didMerge = true;
                }
                if (!didMerge) {
                    Aspect slotAspect = EssentiaItemContainerHelper.INSTANCE.getFilterAspectFromItem(slotStack);
                    if (slotAspect != null) {
                        didMerge = this.workbench.onClientRequestAddAspectToPartitionList(player, slotAspect);
                    }
                    if (!didMerge) {
                        didMerge = this.swapSlotInventoryHotbar(slotNumber, slotStack);
                    }
                }
            }
            if (didMerge) {
                if (slotStack.field_77994_a == 0) {
                    slot.func_75215_d(null);
                } else {
                    slot.func_75218_e();
                }
                this.func_75142_b();
            }
        }
        return null;
    }
}

