/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics;

import appeng.api.AEApi;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thaumicenergistics.ConfigurationHandler;
import thaumicenergistics.api.IThEConfig;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.grid.GridEssentiaCache;
import thaumicenergistics.grid.IEssentiaGrid;
import thaumicenergistics.gui.ThEGuiHandler;
import thaumicenergistics.integration.IntegrationCore;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.integration.tc.EssentiaTileContainerHelper;
import thaumicenergistics.network.NetworkHandler;
import thaumicenergistics.proxy.CommonProxy;
import thaumicenergistics.registries.AEAspectRegister;
import thaumicenergistics.util.ThELog;

@Mod(modid="thaumicenergistics", name="Thaumic Energistics", version="0.9.1.2", dependencies="required-after:appliedenergistics2@[rv3-beta-1,);required-after:Thaumcraft@[4.2.3.5,);after:Waila;after:extracells")
public class ThaumicEnergistics {
    private static LoaderState ThEState = LoaderState.NOINIT;
    public static final String MOD_ID = "thaumicenergistics";
    public static final String VERSION = "0.9.1.2";
    @Mod.Instance(value="thaumicenergistics")
    public static ThaumicEnergistics INSTANCE;
    @SidedProxy(clientSide="thaumicenergistics.proxy.ClientProxy", serverSide="thaumicenergistics.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static IThEConfig config;
    public static CreativeTabs ThETab;

    public static LoaderState getLoaderState() {
        return ThEState;
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        long startTime = ThELog.beginSection("Load");
        proxy.registerRenderers();
        proxy.registerTileEntities();
        NetworkHandler.registerPackets();
        IntegrationCore.init();
        AEApi.instance().registries().gridCache().registerGridCache(IEssentiaGrid.class, GridEssentiaCache.class);
        ThELog.endSection("Load", startTime);
        ThEState = LoaderState.INITIALIZATION;
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        long startTime = ThELog.beginSection("PostInit");
        EssentiaTileContainerHelper.INSTANCE.registerDefaultContainers();
        EssentiaItemContainerHelper.INSTANCE.registerDefaultContainers();
        proxy.registerFeatures();
        proxy.registerSpatialIOMovables();
        proxy.registerFluids();
        try {
            AEAspectRegister.INSTANCE.registerAEAspects();
        }
        catch (Exception e) {
            ThELog.warning("Unable to finish aspect registration due to exception:%n%s%n", e.getMessage());
        }
        ThELog.endSection("PostInit", startTime);
        ThEState = LoaderState.POSTINITIALIZATION;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws Exception {
        long startTime = ThELog.beginSection("PreInit");
        INSTANCE = this;
        config = ConfigurationHandler.loadAndSyncConfigFile(event.getSuggestedConfigurationFile());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new ThEGuiHandler());
        proxy.registerItems();
        proxy.registerBlocks();
        ThELog.endSection("PreInit", startTime);
        ThEState = LoaderState.PREINITIALIZATION;
    }

    static {
        ThETab = new CreativeTabs("ThaumicEnergistics"){

            public ItemStack func_151244_d() {
                return ThEApi.instance().blocks().InfusionProvider.getStack();
            }

            public Item func_78016_d() {
                return ThEApi.instance().blocks().InfusionProvider.getItem();
            }
        };
    }
}

