/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import thaumicenergistics.api.IThEConfig;

class ConfigurationHandler
implements IThEConfig {
    private static ConfigurationHandler INSTANCE;
    private static final String CATEGORY_CRAFTING = "crafting";
    private static final String CATEGORY_CLIENT = "client";
    private static final String CATEGORY_INTEGRATION = "integration";
    private static final int DEFAULT_CONVERSION = 250;
    private static final boolean DEFAULT_ESSENTIAPROVIDER = true;
    private static final boolean DEFAULT_INFUSIONPROVIDER = true;
    private static final boolean DEFAULT_QUARTZ = true;
    private static final boolean DEFAULT_GEARBOX = false;
    private static final boolean DEFAULT_EXTRACELLS_BLIST = true;
    private Configuration configSettings;
    private int conversionMultiplier = 250;
    private boolean allowEssentiaProvider = true;
    private boolean allowInfusionProvider = true;
    private boolean allowCertusDupe = true;
    private boolean gearboxModelDisabled = false;
    private boolean extracellsBlacklist = true;

    private ConfigurationHandler(Configuration config) {
        this.configSettings = config;
        this.synchronizeConfigFile();
    }

    public static IThEConfig loadAndSyncConfigFile(File configFile) {
        if (INSTANCE == null) {
            INSTANCE = new ConfigurationHandler(new Configuration(configFile));
        }
        return INSTANCE;
    }

    private void synchronizeConfigFile() {
        this.conversionMultiplier = this.configSettings.getInt("Essentia Fluid Ratio", "general", 250, 1, 10000, "Controls the conversion ratio of essentia/fluid. 1 essentia is converted to this many milibuckets of fluid. Please be aware that this value effects how much fluid is transferred through the AE system, which also effects transfer speed and power consumption. Very high values may make it impossible to use fluid transfer devices such as the ME IO Port, or anything from EC2.");
        this.allowEssentiaProvider = this.configSettings.getBoolean("Allow Crafting Essentia Provider", CATEGORY_CRAFTING, true, "Controls if the Essentia Provider is allowed to be crafted.");
        this.allowInfusionProvider = this.configSettings.getBoolean("Allow Crafting Infusion Provider", CATEGORY_CRAFTING, true, "Controls if the Infusion Provider is allowed to be crafted.");
        this.allowCertusDupe = this.configSettings.getBoolean("Certus Quartz Duplication", CATEGORY_CRAFTING, true, "Controls if Certus Quartz can be duplicated in the crucible.");
        this.gearboxModelDisabled = this.configSettings.getBoolean("Disable Gearbox Model", CATEGORY_CLIENT, false, "The iron and thaumium gearboxes will be rendered as a standard block.");
        this.extracellsBlacklist = this.configSettings.getBoolean("ExtraCells Blacklist", CATEGORY_INTEGRATION, true, "Prevents extra cells from interacting with essentia gas");
        if (this.configSettings.hasChanged()) {
            this.configSettings.save();
        }
    }

    @Override
    public boolean allowedToCraftEssentiaProvider() {
        return this.allowEssentiaProvider;
    }

    @Override
    public boolean allowedToCraftInfusionProvider() {
        return this.allowInfusionProvider;
    }

    @Override
    public boolean allowedToDuplicateCertusQuartz() {
        return this.allowCertusDupe;
    }

    @Override
    public boolean blacklistEssentiaFluidInExtraCells() {
        return this.extracellsBlacklist;
    }

    @Override
    public int conversionMultiplier() {
        return this.conversionMultiplier;
    }

    @Override
    public boolean gearboxModelDisabled() {
        return this.gearboxModelDisabled;
    }
}

