/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.gui.client;

import cofh.core.gui.GuiBaseAdv;
import cofh.core.gui.element.TabInfo;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.GuiColor;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButton;
import cofh.lib.gui.element.ElementListBox;
import cofh.lib.gui.element.ElementTextField;
import cofh.lib.gui.element.listbox.IListBoxElement;
import cofh.lib.gui.element.listbox.ListBoxElementText;
import cofh.lib.gui.element.listbox.SliderVertical;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalfoundation.gui.container.ContainerLexiconStudy;
import cofh.thermalfoundation.network.PacketTFBase;
import cofh.thermalfoundation.util.LexiconManager;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GuiLexiconStudy
extends GuiBaseAdv {
    static final String TEX_PATH = "thermalfoundation:textures/gui/LexiconStudy.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("thermalfoundation:textures/gui/LexiconStudy.png");
    static final String SEARCH = "         <Search>";
    public String myInfo = "";
    ElementTextField searchBox = new ElementTextField((GuiBase)this, 42, 87, 124, 10){
        boolean searchUp;
        boolean rightClick;
        {
            this.searchUp = true;
            this.rightClick = false;
        }

        public ElementTextField setFocused(boolean bl) {
            if (bl && this.searchUp) {
                this.setText("");
                this.searchUp = false;
            }
            return super.setFocused(bl);
        }

        public boolean onKeyTyped(char c, int n) {
            if (!super.onKeyTyped(c, n)) {
                return false;
            }
            if (this.textLength <= 0) {
                GuiLexiconStudy.this.buildFullOreList();
            } else {
                GuiLexiconStudy.this.buildOreList(this.getText());
            }
            if (GuiLexiconStudy.this.oreList.getElementCount() <= 0) {
                GuiLexiconStudy.this.oreList.setSelectedIndex(-1);
            } else {
                GuiLexiconStudy.this.oreList.setSelectedIndex(0);
            }
            if (GuiLexiconStudy.this.oreList.getSelectedElement() != null) {
                GuiLexiconStudy.this.lexicon.onSelectionChanged((String)GuiLexiconStudy.this.oreList.getSelectedElement().getValue());
            }
            GuiLexiconStudy.this.oreSlider.setLimits(0, GuiLexiconStudy.this.oreList.getElementCount() - 8);
            return true;
        }

        protected void onFocusLost() {
            if (this.textLength <= 0) {
                GuiLexiconStudy.this.buildFullOreList();
                GuiLexiconStudy.this.oreSlider.setLimits(0, GuiLexiconStudy.this.oreList.getElementCount() - 8);
                this.setText(GuiLexiconStudy.SEARCH);
                this.searchUp = true;
            }
        }

        public boolean onMousePressed(int n, int n2, int n3) {
            if (n3 == 1) {
                this.rightClick = true;
                GuiLexiconStudy.this.buildFullOreList();
                GuiLexiconStudy.this.oreList.setSelectedIndex(0);
                GuiLexiconStudy.this.oreSlider.setLimits(0, GuiLexiconStudy.this.oreList.getElementCount() - 8);
                this.setText("");
                this.setFocused(true);
            }
            return super.onMousePressed(n, n2, n3);
        }

        public void onMouseReleased(int n, int n2) {
            if (this.rightClick) {
                this.rightClick = false;
            } else {
                super.onMouseReleased(n, n2);
            }
        }

        public void drawBackground(int n, int n2, float f) {
        }
    };
    ElementListBox oreList = new ElementListBox((GuiBase)this, 22, 104, 162, 84){

        protected void onSelectionChanged(int n, IListBoxElement iListBoxElement) {
            if (n > -1) {
                GuiLexiconStudy.this.lexicon.onSelectionChanged((String)iListBoxElement.getValue());
            }
        }

        protected void onScrollV(int n) {
            GuiLexiconStudy.this.oreSlider.setValue(n);
        }

        protected void onScrollH(int n) {
        }
    };
    SliderVertical oreSlider;
    ElementButton prevOre;
    ElementButton nextOre;
    ElementButton setPreferredOre;
    ElementButton clearPreferredOre;
    ContainerLexiconStudy lexicon;

    public GuiLexiconStudy(InventoryPlayer inventoryPlayer, ContainerLexiconStudy containerLexiconStudy) {
        super((Container)containerLexiconStudy);
        this.lexicon = containerLexiconStudy;
        ((GuiBase)this).texture = TEXTURE;
        ((GuiBase)this).name = "gui.thermalfoundation.lexicon.study";
        ((GuiScreen)this).field_146291_p = false;
        ((GuiBase)this).drawTitle = false;
        ((GuiBase)this).drawInventory = false;
        ((GuiContainer)this).field_146999_f = 206;
        ((GuiContainer)this).field_147000_g = 204;
        this.myInfo = StringHelper.localize((String)"tab.thermalfoundation.lexicon.study.0") + "\n\n" + StringHelper.localize((String)"tab.thermalfoundation.lexicon.study.1");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addTab(new TabInfo((GuiBase)this, this.myInfo).setOffsets(12, 10));
        this.prevOre = new ElementButton((GuiBase)this, 57, 31, "PrevOre", 206, 0, 206, 20, 206, 40, 20, 20, TEX_PATH);
        this.nextOre = new ElementButton((GuiBase)this, 129, 31, "NextOre", 226, 0, 226, 20, 226, 40, 20, 20, TEX_PATH);
        this.setPreferredOre = new ElementButton((GuiBase)this, 78, 59, "SetPreferred", 206, 60, 206, 80, 206, 100, 20, 20, TEX_PATH);
        this.clearPreferredOre = new ElementButton((GuiBase)this, 108, 59, "ClearPreferred", 226, 60, 226, 80, 226, 100, 20, 20, TEX_PATH);
        this.oreList.borderColor = new GuiColor(120, 120, 120, 0).getColor();
        this.oreList.backgroundColor = new GuiColor(0, 0, 0, 48).getColor();
        this.addElement((ElementBase)this.prevOre);
        this.addElement((ElementBase)this.nextOre);
        this.addElement((ElementBase)this.setPreferredOre);
        this.addElement((ElementBase)this.clearPreferredOre);
        this.addElement((ElementBase)this.searchBox);
        this.addElement((ElementBase)this.oreList);
        this.buildFullOreList();
        this.lexicon.onSelectionChanged((String)this.oreList.getSelectedElement().getValue());
        this.searchBox.setText(SEARCH);
        this.oreSlider = new SliderVertical((GuiBase)this, 184, 105, 8, 82, this.oreList.getElementCount() - 8){

            public void onValueChanged(int n) {
                GuiLexiconStudy.this.oreList.scrollToV(n);
            }
        };
        this.addElement((ElementBase)this.oreSlider);
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }

    protected void updateElementInformation() {
        if (this.lexicon.hasMultipleOres()) {
            this.prevOre.setActive();
            this.nextOre.setActive();
            this.prevOre.setToolTip("info.thermalfoundation.lexicon.prevEntry");
            this.nextOre.setToolTip("info.thermalfoundation.lexicon.nextEntry");
        } else {
            this.prevOre.setDisabled();
            this.nextOre.setDisabled();
            this.prevOre.setToolTip("info.thermalfoundation.lexicon.singleEntry");
            this.nextOre.setToolTip("info.thermalfoundation.lexicon.singleEntry");
        }
        if (this.lexicon.canSetPreferred()) {
            this.setPreferredOre.setActive();
            this.setPreferredOre.setToolTip("info.thermalfoundation.lexicon.setPreference");
        } else {
            this.setPreferredOre.setDisabled();
            this.setPreferredOre.clearToolTip();
        }
        if (this.lexicon.hasPreferredOre()) {
            this.clearPreferredOre.setActive();
            this.clearPreferredOre.setToolTip("info.thermalfoundation.lexicon.clearPreference");
        } else {
            this.clearPreferredOre.setDisabled();
            this.clearPreferredOre.clearToolTip();
        }
    }

    public void handleElementButtonClick(String string, int n) {
        if (string.equalsIgnoreCase("PrevOre")) {
            PacketTFBase.sendLexiconStudyPacketToServer(0);
        } else if (string.equalsIgnoreCase("NextOre")) {
            PacketTFBase.sendLexiconStudyPacketToServer(1);
        } else if (string.equalsIgnoreCase("SetPreferred")) {
            PacketTFBase.sendLexiconStudyPacketToServer(2);
        } else if (string.equalsIgnoreCase("ClearPreferred")) {
            PacketTFBase.sendLexiconStudyPacketToServer(3);
        }
    }

    protected void func_146979_b(int n, int n2) {
        ((GuiScreen)this).field_146289_q.func_78276_b(StringHelper.localize((String)((GuiBase)this).name), this.getCenteredOffset(StringHelper.localize((String)((GuiBase)this).name)), 16, 0xDDBB1D);
        super.func_146979_b(n, n2);
    }

    protected void buildOreList(String string) {
        this.oreList.removeAll();
        for (String string2 : LexiconManager.getSortedOreNames()) {
            if (!string2.toLowerCase().contains(string.toLowerCase())) continue;
            this.oreList.add((IListBoxElement)new ListBoxElementText(string2));
        }
    }

    protected void buildFullOreList() {
        this.oreList.removeAll();
        for (String string : LexiconManager.getSortedOreNames()) {
            this.oreList.add((IListBoxElement)new ListBoxElementText(string));
        }
    }
}

