/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import cpw.mods.fml.relauncher.ReflectionHelper;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.setup.Registry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityUtils {
    public static final byte[] YAW_TO_DIRECTION = new byte[]{2, 5, 3, 4};

    public static ForgeDirection getLookingDirection(Entity entity) {
        if (entity.field_70125_A < -45.0f) {
            return ForgeDirection.UP;
        }
        if (entity.field_70125_A > 45.0f) {
            return ForgeDirection.DOWN;
        }
        return ForgeDirection.getOrientation((int)YAW_TO_DIRECTION[MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3]);
    }

    public static EntityPlayer findPlayerByUUID(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        MinecraftServer mcs = MinecraftServer.func_71276_C();
        if (mcs == null) {
            return null;
        }
        List playerList = mcs.func_71203_ab().field_72404_b;
        for (EntityPlayer player : playerList) {
            if (!player.func_110124_au().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    public static Entity findEntityByUUID(List<Entity> list, UUID uuid) {
        if (uuid == null) {
            return null;
        }
        for (Entity entity : list) {
            if (!entity.func_110124_au().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    public static Entity getBottomEntity(Entity entity) {
        Entity ent = entity;
        while (ent != null && ent.field_70154_o != null) {
            ent = ent.field_70154_o;
        }
        return ent;
    }

    public static Entity getTopEntity(Entity entity) {
        Entity ent = entity;
        while (ent != null && ent.field_70153_n != null) {
            ent = ent.field_70153_n;
        }
        return ent;
    }

    public static boolean doesEntityStackHavePlayers(Entity entity) {
        Entity ent = entity;
        while (ent != null) {
            if (ent instanceof EntityPlayer) {
                return true;
            }
            ent = ent.field_70154_o;
        }
        ent = entity.field_70153_n;
        while (ent != null) {
            if (ent instanceof EntityPlayer) {
                return true;
            }
            ent = ent.field_70153_n;
        }
        return false;
    }

    public static boolean doesEntityStackContainEntity(Entity entity, Entity entityInStack) {
        Entity ent = entityInStack;
        while (ent != null) {
            if (ent == entity) {
                return true;
            }
            ent = ent.field_70154_o;
        }
        ent = entityInStack.field_70153_n;
        while (ent != null) {
            if (ent == entity) {
                return true;
            }
            ent = ent.field_70153_n;
        }
        return false;
    }

    public static boolean doesEntityStackHaveBlacklistedEntities(Entity entity) {
        List<String> blacklist = Registry.getTeleportBlacklist();
        Entity ent = entity;
        while (ent != null) {
            if (blacklist.contains(ent.getClass().getSimpleName())) {
                return true;
            }
            ent = ent.field_70154_o;
        }
        ent = entity.field_70153_n;
        while (ent != null) {
            if (blacklist.contains(ent.getClass().getSimpleName())) {
                return true;
            }
            ent = ent.field_70153_n;
        }
        return false;
    }

    public static boolean unmountRider(Entity entity) {
        if (entity != null && entity.field_70153_n != null) {
            entity.field_70153_n.func_70078_a(null);
            return true;
        }
        return false;
    }

    public static boolean unmountRidden(Entity entity) {
        if (entity != null && entity.field_70154_o != null) {
            entity.func_70078_a(null);
            return true;
        }
        return false;
    }

    public static void unmountRiderSimple(Entity entity) {
        if (entity.field_70153_n != null) {
            entity.field_70153_n.field_70154_o = null;
        }
        entity.field_70153_n = null;
    }

    public static boolean isEntityCollidingWithBlockSpace(World world, Entity entity, Block block) {
        AxisAlignedBB bb = entity.field_70121_D;
        int mX = MathHelper.func_76128_c((double)bb.field_72340_a);
        int mY = MathHelper.func_76128_c((double)bb.field_72338_b);
        int mZ = MathHelper.func_76128_c((double)bb.field_72339_c);
        int y2 = mY;
        while ((double)y2 < bb.field_72337_e) {
            int x2 = mX;
            while ((double)x2 < bb.field_72336_d) {
                int z2 = mZ;
                while ((double)z2 < bb.field_72334_f) {
                    if (world.func_147439_a(x2, y2, z2) == block) {
                        return true;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return false;
    }

    public static boolean applyMobPersistence(EntityLiving living) {
        if (!living.func_104002_bU()) {
            boolean canDespawn;
            boolean bl = canDespawn = living instanceof EntityMob && !(living instanceof IBossDisplayData) || living instanceof EntityWaterMob || living instanceof EntityTameable && !((EntityTameable)living).func_70909_n();
            if (!canDespawn) {
                Method method = ReflectionHelper.findMethod(EntityLiving.class, (Object)living, (String[])new String[]{"canDespawn", "v", "func_70692_ba"}, (Class[])new Class[0]);
                try {
                    Object o = method.invoke((Object)living, new Object[0]);
                    if (o instanceof Boolean) {
                        canDespawn = (Boolean)o;
                    }
                }
                catch (ReflectionHelper.UnableToFindMethodException e) {
                    EnderUtilities.logger.error("Error while trying reflect EntityLiving.canDespawn() (UnableToFindMethodException)");
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    EnderUtilities.logger.error("Error while trying reflect EntityLiving.canDespawn() (InvocationTargetException)");
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    EnderUtilities.logger.error("Error while trying reflect EntityLiving.canDespawn() (IllegalAccessException)");
                    e.printStackTrace();
                }
            }
            if (canDespawn) {
                living.func_110163_bv();
                living.field_70170_p.func_72956_a((Entity)living, "enderutilities:jailer", 1.0f, 1.2f);
                return true;
            }
        }
        return false;
    }

    public static boolean spawnEnderCrystal(World world, int x, int y, int z) {
        if (world != null && world.field_73011_w != null) {
            if (world.field_73011_w.field_76574_g == 1 && world.func_147439_a(x, y, z) == Blocks.field_150357_h) {
                List entities = world.func_72872_a(EntityEnderCrystal.class, AxisAlignedBB.func_72330_a((double)(x - 2), (double)(y - 2), (double)(z - 2), (double)(x + 2), (double)(y + 2), (double)(z + 2)));
                if (!entities.isEmpty()) {
                    return false;
                }
                for (int by = y - 6; by < y; ++by) {
                    for (int bx = x - 1; bx <= x + 1; ++bx) {
                        for (int bz = z - 1; bz <= z + 1; ++bz) {
                            if (world.func_147439_a(bx, by, bz) == Blocks.field_150343_Z) continue;
                            return false;
                        }
                    }
                }
                world.func_72876_a(null, (double)x + 0.5, (double)y + 1.0, (double)z + 0.5, 10.0f, true);
                EntityEnderCrystal entityendercrystal = new EntityEnderCrystal(world);
                entityendercrystal.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityendercrystal);
                return true;
            }
            if (world.field_73011_w.field_76574_g != 1) {
                EntityEnderCrystal entityendercrystal = new EntityEnderCrystal(world);
                entityendercrystal.func_70012_b((double)x + 0.5, (double)y + 1.0, (double)z + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityendercrystal);
            }
        }
        return false;
    }

    public static boolean addAITaskAfterTasks(EntityLiving living, EntityAIBase task, boolean replaceMatching, Class<? extends EntityAIBase>[] afterTasks) {
        if (living == null) {
            return false;
        }
        int priority = -1;
        for (EntityAITasks.EntityAITaskEntry taskEntry : living.field_70714_bg.field_75782_a) {
            if (taskEntry.field_75733_a.getClass().equals(task.getClass())) {
                if (replaceMatching) {
                    int p = taskEntry.field_75731_b;
                    living.field_70714_bg.func_85156_a(taskEntry.field_75733_a);
                    living.field_70714_bg.func_75776_a(p, task);
                }
                return true;
            }
            for (Class<? extends EntityAIBase> clazz : afterTasks) {
                if (priority > taskEntry.field_75731_b || !clazz.equals(taskEntry.field_75733_a.getClass())) continue;
                priority = taskEntry.field_75731_b + 1;
            }
        }
        if (priority == -1) {
            priority = 0;
        }
        living.field_70714_bg.func_75776_a(priority, task);
        return true;
    }
}

