/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.BlockUtils;
import fi.dy.masa.enderutilities.util.DimBlockPos;
import fi.dy.masa.enderutilities.util.EnergyBridgeTracker;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEnergyBridge
extends TileEntityEnderUtilities {
    public boolean isActive;
    public boolean isPowered;
    public int timer = 0;
    @SideOnly(value=Side.CLIENT)
    public int beamYMin;
    @SideOnly(value=Side.CLIENT)
    public int beamYMax;

    public TileEntityEnergyBridge() {
        super("energybridge");
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        byte f = nbt.func_74771_c("Flags");
        this.isActive = (f & 1) == 1;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("Flags", (byte)(this.isActive ? 1 : 0));
    }

    @Override
    public NBTTagCompound getDescriptionPacketTag(NBTTagCompound nbt) {
        if ((nbt = super.getDescriptionPacketTag(nbt)) == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74774_a("f", (byte)((this.isPowered ? 2 : 0) | (this.isActive ? 1 : 0)));
        return nbt;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbt = packet.func_148857_g();
        byte f = nbt.func_74771_c("f");
        this.isActive = (f & 1) == 1;
        this.isPowered = (f & 2) == 2;
        this.getBeamEndPoints();
        super.onDataPacket(net, packet);
    }

    public void setState(boolean state) {
        this.isActive = state;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setPowered(boolean value) {
        if (this.isPowered != value) {
            this.isPowered = value;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.func_145832_p() < 2 && ++this.timer >= 40) {
            this.tryAssembleMultiBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.timer = 0;
        }
    }

    public void tryAssembleMultiBlock(World world, int x, int y, int z) {
        if (world.field_73011_w.field_76574_g == 1) {
            this.tryAssembleMultiBlock(world, x, y, z, 4, 0, true);
        } else {
            this.tryAssembleMultiBlock(world, x, y, z, 1, 1, false);
        }
    }

    public void disassembleMultiblock(World world, int x, int y, int z, int oldMeta) {
        if (world.field_73011_w.field_76574_g == 1) {
            this.disassembleMultiblock(world, x, y, z, 4, 0, oldMeta);
        } else {
            this.disassembleMultiblock(world, x, y, z, 1, 1, oldMeta);
        }
    }

    public void tryAssembleMultiBlock(World world, int x, int y, int z, int height, int masterMeta, boolean requireEnderCrystal) {
        ArrayList<BlockPosEU> positions = new ArrayList<BlockPosEU>();
        if (!this.getBlockPositions(world, x, y, z, height, masterMeta, positions) || positions.size() != 6) {
            return;
        }
        boolean isValid = this.isStructureValid(world, x, y, z, height, masterMeta, requireEnderCrystal, positions);
        if (isValid) {
            if (!this.isActive) {
                this.activateMultiBlock(world, positions);
                EnergyBridgeTracker.addBridgeLocation(new DimBlockPos(this.field_145850_b.field_73011_w.field_76574_g, (BlockPosEU)positions.get(0)));
            }
            this.updatePoweredState(world, positions);
        } else if (this.isActive) {
            this.disassembleMultiblock(world, x, y, z, world.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    public void activateMultiBlock(World world, List<BlockPosEU> blockPositions) {
        for (int i = 0; i < 5; ++i) {
            this.setState(world, blockPositions.get(i), true);
        }
    }

    public boolean getBlockPositions(World world, int x, int y, int z, int height, int masterMeta, List<BlockPosEU> blockPositions) {
        blockPositions.clear();
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        if (block != EnderUtilitiesBlocks.machine_1 || meta != masterMeta && meta != 2 || !(te instanceof TileEntityEnergyBridge)) {
            return false;
        }
        BlockPosEU posMaster = new BlockPosEU(x, y, z);
        BlockPosEU posResonatorBase = new BlockPosEU(x, y, z);
        ForgeDirection dir = ForgeDirection.getOrientation((int)((TileEntityEnergyBridge)te).getRotation());
        if (meta != masterMeta) {
            posMaster.add(0, height - 1, 0);
            posMaster.offset(dir, 3);
            posResonatorBase.offset(dir, 3);
        } else {
            posResonatorBase.add(0, -(height - 1), 0);
        }
        blockPositions.add(posMaster);
        blockPositions.add(new BlockPosEU(posResonatorBase, ForgeDirection.NORTH, 3));
        blockPositions.add(new BlockPosEU(posResonatorBase, ForgeDirection.SOUTH, 3));
        blockPositions.add(new BlockPosEU(posResonatorBase, ForgeDirection.EAST, 3));
        blockPositions.add(new BlockPosEU(posResonatorBase, ForgeDirection.WEST, 3));
        blockPositions.add(posResonatorBase);
        return true;
    }

    public boolean isStructureValid(World world, int x, int y, int z, int height, int masterMeta, boolean requireEnderCrystal, List<BlockPosEU> blockPositions) {
        Block blockEb = EnderUtilitiesBlocks.machine_1;
        Class<TileEntityEnergyBridge> classTEEB = TileEntityEnergyBridge.class;
        boolean isValid = false;
        if (BlockUtils.blockMatches(world, blockPositions.get(0), blockEb, masterMeta, classTEEB, ForgeDirection.UNKNOWN) && BlockUtils.blockMatches(world, blockPositions.get(1), blockEb, 2, classTEEB, ForgeDirection.SOUTH) && BlockUtils.blockMatches(world, blockPositions.get(2), blockEb, 2, classTEEB, ForgeDirection.NORTH) && BlockUtils.blockMatches(world, blockPositions.get(3), blockEb, 2, classTEEB, ForgeDirection.WEST) && BlockUtils.blockMatches(world, blockPositions.get(4), blockEb, 2, classTEEB, ForgeDirection.EAST)) {
            if (!requireEnderCrystal) {
                isValid = true;
            } else {
                double xd = blockPositions.get((int)5).posX;
                double d = 0.0;
                double yd = blockPositions.get((int)5).posY;
                double zd = blockPositions.get((int)5).posZ;
                List list = world.func_72872_a(EntityEnderCrystal.class, AxisAlignedBB.func_72330_a((double)(xd - d), (double)(yd - d), (double)(zd - d), (double)(xd + d), (double)(yd + d), (double)(zd + d)));
                if (list.size() == 1) {
                    isValid = true;
                }
            }
        }
        if (isValid) {
            return !this.isObstructed(world, blockEb, height, masterMeta, blockPositions);
        }
        return false;
    }

    public boolean isObstructedQuadrant(World world, BlockPosEU basePosition, ForgeDirection dir, BlockPosEU ... positions) {
        ForgeDirection dirNext = dir.getRotation(ForgeDirection.UP);
        for (BlockPosEU pos : positions) {
            int x = pos.posX * dir.offsetX + pos.posZ * dir.offsetZ;
            int y = pos.posY;
            int z = pos.posX * dirNext.offsetX + pos.posZ * dirNext.offsetZ;
            if (basePosition != null) {
                x += basePosition.posX;
                y += basePosition.posY;
                z += basePosition.posZ;
            }
            if (world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z)) continue;
            return true;
        }
        return false;
    }

    public boolean isObstructed(World world, Block blockEb, int height, int masterMeta, List<BlockPosEU> blockPositions) {
        Block block;
        int y;
        BlockPosEU[] positionsToCheck;
        if (blockPositions.size() != 6) {
            return true;
        }
        BlockPosEU posMaster = new BlockPosEU(blockPositions.get(0));
        BlockPosEU posResonatorMiddle = new BlockPosEU(blockPositions.get(5));
        if (this.isObstructedQuadrant(world, posResonatorMiddle, ForgeDirection.EAST, positionsToCheck = new BlockPosEU[]{new BlockPosEU(1, 0, 0), new BlockPosEU(2, 0, 0), new BlockPosEU(1, 0, 3), new BlockPosEU(1, 0, 2), new BlockPosEU(2, 0, 2), new BlockPosEU(2, 0, 1), new BlockPosEU(3, 0, 1)}) || this.isObstructedQuadrant(world, posResonatorMiddle, ForgeDirection.SOUTH, positionsToCheck) || this.isObstructedQuadrant(world, posResonatorMiddle, ForgeDirection.WEST, positionsToCheck) || this.isObstructedQuadrant(world, posResonatorMiddle, ForgeDirection.NORTH, positionsToCheck)) {
            return true;
        }
        if (masterMeta == 0) {
            if (this.isObstructedQuadrant(world, posMaster, ForgeDirection.EAST, new BlockPosEU(0, -1, 0), new BlockPosEU(0, -2, 0))) {
                return true;
            }
        } else {
            for (y = posMaster.posY - 1; y >= 0; --y) {
                block = world.func_147439_a(posMaster.posX, y, posMaster.posZ);
                if (block.isAir((IBlockAccess)world, posMaster.posX, y, posMaster.posZ) || block.getLightOpacity((IBlockAccess)world, posMaster.posX, y, posMaster.posZ) <= 3) continue;
                if (block == Blocks.field_150357_h) break;
                return true;
            }
        }
        for (y = posMaster.posY + 1; y <= world.func_72940_L(); ++y) {
            block = world.func_147439_a(posMaster.posX, y, posMaster.posZ);
            if (block.isAir((IBlockAccess)world, posMaster.posX, y, posMaster.posZ) || block.getLightOpacity((IBlockAccess)world, posMaster.posX, y, posMaster.posZ) <= 3) continue;
            if (block == Blocks.field_150357_h) break;
            return true;
        }
        return false;
    }

    public void disassembleMultiblock(World world, int x, int y, int z, int height, int masterMeta, int oldMeta) {
        ArrayList<BlockPosEU> positions;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileEntityEnergyBridge)) {
            return;
        }
        BlockPosEU posMaster = new BlockPosEU(x, y, z);
        if (oldMeta == 2) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)((TileEntityEnergyBridge)te).getRotation());
            posMaster.add(0, height - 1, 0);
            posMaster.offset(dir, 3);
        }
        if (!this.getBlockPositions(world, x, y, z, height, masterMeta, positions = new ArrayList<BlockPosEU>())) {
            return;
        }
        this.disableMultiBlock(world, masterMeta, positions);
    }

    public void disableMultiBlock(World world, int masterMeta, List<BlockPosEU> blockPositions) {
        if (blockPositions == null || blockPositions.size() != 6) {
            return;
        }
        Block blockEb = EnderUtilitiesBlocks.machine_1;
        Class<TileEntityEnergyBridge> classTEEB = TileEntityEnergyBridge.class;
        this.setStateWithCheck(world, blockPositions.get(0), blockEb, masterMeta, classTEEB, ForgeDirection.UNKNOWN, false);
        this.setStateWithCheck(world, blockPositions.get(1), blockEb, 2, classTEEB, ForgeDirection.SOUTH, false);
        this.setStateWithCheck(world, blockPositions.get(2), blockEb, 2, classTEEB, ForgeDirection.NORTH, false);
        this.setStateWithCheck(world, blockPositions.get(3), blockEb, 2, classTEEB, ForgeDirection.WEST, false);
        this.setStateWithCheck(world, blockPositions.get(4), blockEb, 2, classTEEB, ForgeDirection.EAST, false);
        EnergyBridgeTracker.removeBridgeLocation(new DimBlockPos(this.field_145850_b.field_73011_w.field_76574_g, blockPositions.get(0)));
    }

    public void setState(World world, BlockPosEU pos, boolean state) {
        TileEntity te = world.func_147438_o(pos.posX, pos.posY, pos.posZ);
        if (te instanceof TileEntityEnergyBridge) {
            ((TileEntityEnergyBridge)te).setState(state);
        }
    }

    public void setStateWithCheck(World world, BlockPosEU pos, Block requiredBlock, int requiredMeta, Class<? extends TileEntity> TEClass, ForgeDirection requiredDirection, boolean state) {
        if (BlockUtils.blockMatches(world, pos, requiredBlock, requiredMeta, TEClass, requiredDirection)) {
            ((TileEntityEnergyBridge)world.func_147438_o(pos.posX, pos.posY, pos.posZ)).setState(state);
        }
    }

    public void updatePoweredState(World world, List<BlockPosEU> positions) {
        if (positions == null || positions.size() != 6) {
            return;
        }
        int dim = world.field_73011_w.field_76574_g;
        boolean powered = EnergyBridgeTracker.dimensionHasEnergyBridge(dim) && (dim == 1 || EnergyBridgeTracker.dimensionHasEnergyBridge(1));
        for (int i = 0; i < 5; ++i) {
            this.updatePoweredState(world, positions.get(i), powered);
        }
    }

    public void updatePoweredState(World world, BlockPosEU pos, boolean value) {
        TileEntity te = world.func_147438_o(pos.posX, pos.posY, pos.posZ);
        if (te instanceof TileEntityEnergyBridge) {
            ((TileEntityEnergyBridge)te).setPowered(value);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void getBeamEndPoints() {
        int ty;
        if (this.func_145832_p() == 0) {
            this.beamYMin = this.field_145848_d - 2;
        } else if (this.func_145832_p() == 1) {
            for (ty = this.field_145848_d; ty >= 0 && this.field_145850_b.func_147439_a(this.field_145851_c, ty, this.field_145849_e) != Blocks.field_150357_h; --ty) {
            }
            this.beamYMin = ty + 1;
        }
        for (ty = this.field_145848_d; ty < this.field_145850_b.func_72800_K() && this.field_145850_b.func_147439_a(this.field_145851_c, ty, this.field_145849_e) != Blocks.field_150357_h; ++ty) {
        }
        this.beamYMax = ty;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }
}

