/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.gui.client.GuiEnderFurnace;
import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.inventory.ContainerEnderFurnace;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesSided;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TileEntityEnderFurnace
extends TileEntityEnderUtilitiesSided {
    public static final int COOKTIME_INC_NOFUEL = 1;
    public static final int COOKTIME_INC_SLOW = 20;
    public static final int COOKTIME_INC_FAST = 60;
    public static final int COOKTIME_DEFAULT = 1200;
    public static final int BURNTIME_USAGE_SLOW = 20;
    public static final int BURNTIME_USAGE_FAST = 120;
    public static final int OUTPUT_BUFFER_SIZE = 1024;
    public static final int OUTPUT_INTERVAL = 20;
    protected static final int[] SLOTS_SIDES = new int[]{0, 1, 2};
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_OUTPUT = 2;
    public boolean fastMode;
    public boolean outputToEnderChest;
    private ItemStack outputBufferStack;
    private ItemStack smeltingResultCache;
    private boolean inputDirty;
    public int burnTimeRemaining;
    public int burnTimeFresh;
    public int cookTime;
    public boolean isBurningLast;
    public boolean isCookingLast;
    private int timer;

    public TileEntityEnderFurnace() {
        super("enderfurnace");
        this.itemStacks = new ItemStack[3];
        this.smeltingResultCache = null;
        this.inputDirty = true;
        this.fastMode = false;
        this.outputToEnderChest = false;
        this.burnTimeRemaining = 0;
        this.cookTime = 0;
        this.timer = 0;
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        byte flags = nbt.func_74771_c("Flags");
        this.fastMode = (flags & 1) == 1;
        this.outputToEnderChest = (flags & 2) == 2;
        this.burnTimeRemaining = nbt.func_74762_e("BurnTimeRemaining");
        this.burnTimeFresh = nbt.func_74762_e("BurnTimeFresh");
        this.cookTime = nbt.func_74762_e("CookTime");
        if (nbt.func_150297_b("OutputBufferAmount", 3) && nbt.func_150297_b("OutputBufferStack", 10)) {
            this.outputBufferStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("OutputBufferStack"));
            this.outputBufferStack.field_77994_a = nbt.func_74762_e("OutputBufferAmount");
        }
        this.inputDirty = true;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        byte flags = 0;
        if (this.fastMode) {
            flags = (byte)(flags | 1);
        }
        if (this.outputToEnderChest) {
            flags = (byte)(flags | 2);
        }
        nbt.func_74774_a("Flags", flags);
        nbt.func_74777_a("BurnTimeRemaining", (short)this.burnTimeRemaining);
        nbt.func_74777_a("BurnTimeFresh", (short)this.burnTimeFresh);
        nbt.func_74777_a("CookTime", (short)this.cookTime);
        if (this.outputBufferStack != null) {
            nbt.func_74782_a("OutputBufferStack", (NBTBase)this.outputBufferStack.func_77955_b(new NBTTagCompound()));
            nbt.func_74768_a("OutputBufferAmount", this.outputBufferStack.field_77994_a);
        }
    }

    @Override
    public NBTTagCompound getDescriptionPacketTag(NBTTagCompound nbt) {
        if ((nbt = super.getDescriptionPacketTag(nbt)) == null) {
            nbt = new NBTTagCompound();
        }
        byte flags = (byte)(this.getRotation() & 7);
        if (this.canSmelt()) {
            flags = (byte)(flags | 0x10);
        }
        if (this.isBurning()) {
            flags = (byte)(flags | 0x20);
        }
        if (this.fastMode) {
            flags = (byte)(flags | 0x40);
        }
        nbt.func_74774_a("f", flags);
        return nbt;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbt = packet.func_148857_g();
        byte flags = nbt.func_74771_c("f");
        this.setRotation((byte)(flags & 7));
        this.isCookingLast = (flags & 0x10) == 16;
        this.isBurningLast = (flags & 0x20) == 32;
        this.fastMode = (flags & 0x40) == 64;
        super.onDataPacket(net, packet);
        this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getOutputBufferAmount() {
        if (this.outputBufferStack == null) {
            return 0;
        }
        return this.outputBufferStack.field_77994_a;
    }

    public ItemStack getOutputBufferStack() {
        return this.outputBufferStack;
    }

    public boolean isBurning() {
        return this.burnTimeRemaining > 0;
    }

    private void updateSmeltingResult() {
        if (this.inputDirty) {
            this.smeltingResultCache = this.itemStacks[0] != null ? FurnaceRecipes.func_77602_a().func_151395_a(this.itemStacks[0]) : null;
            this.inputDirty = false;
        }
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateSmeltingResult();
        boolean dirty = false;
        boolean canSmelt = this.canSmelt();
        boolean hasFuel = this.hasFuelAvailable();
        int cookTimeIncrement = 20;
        if (this.burnTimeRemaining == 0 && !hasFuel) {
            cookTimeIncrement = 1;
        } else if (this.fastMode) {
            cookTimeIncrement = 60;
        }
        if (this.burnTimeRemaining > 0) {
            int btUse;
            int n = btUse = this.fastMode ? 120 : 20;
            if (btUse > this.burnTimeRemaining) {
                if (hasFuel && canSmelt) {
                    this.burnTimeRemaining += this.consumeFuelItem();
                    hasFuel = this.hasFuelAvailable();
                } else {
                    cookTimeIncrement = this.burnTimeRemaining * cookTimeIncrement / btUse;
                    btUse = this.burnTimeRemaining;
                }
            }
            this.burnTimeRemaining -= btUse;
            dirty = true;
        } else if (canSmelt && hasFuel) {
            this.burnTimeRemaining += this.consumeFuelItem();
            hasFuel = this.hasFuelAvailable();
            dirty = true;
        }
        if (canSmelt) {
            this.cookTime += cookTimeIncrement;
            if (this.cookTime >= 1200) {
                this.smeltItem();
                canSmelt = this.canSmelt();
                this.cookTime = canSmelt && this.cookTime > 1200 ? (this.cookTime -= 1200) : 0;
            }
            if (this.burnTimeRemaining == 0 && hasFuel && canSmelt) {
                this.burnTimeRemaining += this.consumeFuelItem();
            }
            dirty = true;
        } else if (this.cookTime > 0) {
            this.cookTime -= Math.min(this.cookTime, 10);
            dirty = true;
        }
        if (this.outputToEnderChest && this.itemStacks[2] != null && ++this.timer >= 20) {
            if (this.moveItemsToEnderChest()) {
                dirty = true;
            }
            this.timer = 0;
        }
        if (this.fillOutputSlotFromBuffer()) {
            dirty = true;
        }
        if (dirty) {
            this.func_70296_d();
        }
        if (this.isBurningLast != this.isBurning() || this.isCookingLast != canSmelt) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.isBurningLast = this.isBurning();
        this.isCookingLast = canSmelt;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            if (this.outputBufferStack == null) {
                this.outputBufferStack = this.smeltingResultCache.func_77946_l();
            } else {
                this.outputBufferStack.field_77994_a += this.smeltingResultCache.field_77994_a;
            }
            if (--this.itemStacks[0].field_77994_a <= 0) {
                this.itemStacks[0] = null;
                this.inputDirty = true;
            }
        }
    }

    public int consumeFuelItem() {
        if (this.itemStacks[1] == null) {
            return 0;
        }
        int burnTime = TileEntityEnderFurnace.consumeFluidFuelDosage(this.itemStacks[1]);
        if (burnTime > 0) {
            this.burnTimeFresh = burnTime;
        } else {
            burnTime = TileEntityEnderFurnace.getItemBurnTime(this.itemStacks[1]);
            if (burnTime > 0) {
                if (--this.itemStacks[1].field_77994_a <= 0) {
                    this.itemStacks[1] = this.itemStacks[1].func_77973_b().getContainerItem(this.itemStacks[1]);
                }
                this.burnTimeFresh = burnTime;
            }
        }
        return burnTime;
    }

    private boolean fillOutputSlotFromBuffer() {
        if (this.outputBufferStack == null) {
            return false;
        }
        if (this.itemStacks[2] == null) {
            this.itemStacks[2] = this.outputBufferStack.func_77946_l();
            this.itemStacks[2].field_77994_a = 0;
        } else if (!InventoryUtils.areItemStacksEqual(this.itemStacks[2], this.outputBufferStack)) {
            return false;
        }
        int size = this.itemStacks[2].field_77994_a;
        int max = Math.min(this.func_70297_j_(), this.itemStacks[2].func_77976_d());
        if (size >= max) {
            return false;
        }
        int amount = Math.min(max - size, this.outputBufferStack.field_77994_a);
        this.itemStacks[2].field_77994_a += amount;
        this.outputBufferStack.field_77994_a -= amount;
        if (this.outputBufferStack.field_77994_a <= 0) {
            this.outputBufferStack = null;
        }
        return true;
    }

    private boolean moveItemsToEnderChest() {
        if (this.itemStacks[2] == null) {
            return false;
        }
        EntityPlayer player = EntityUtils.findPlayerByUUID(this.ownerUUID);
        boolean movedSomething = false;
        if (player != null) {
            ItemStack enderChestStack;
            int i;
            InventoryEnderChest invEnderChest = player.func_71005_bN();
            int invSize = invEnderChest.func_70302_i_();
            int amount = 0;
            for (i = 0; i < invSize; ++i) {
                enderChestStack = invEnderChest.func_70301_a(i);
                if (enderChestStack == null || !InventoryUtils.areItemStacksEqual(this.itemStacks[2], enderChestStack)) continue;
                amount = Math.min(this.itemStacks[2].field_77994_a, invEnderChest.func_70297_j_() - enderChestStack.field_77994_a);
                if ((amount = Math.min(amount, this.itemStacks[2].func_77976_d())) <= 0) continue;
                enderChestStack.field_77994_a += amount;
                this.itemStacks[2].field_77994_a -= amount;
                movedSomething = true;
                if (this.itemStacks[2].field_77994_a > 0) continue;
                this.itemStacks[2] = null;
                return true;
            }
            for (i = 0; i < invSize; ++i) {
                enderChestStack = invEnderChest.func_70301_a(i);
                if (enderChestStack != null) continue;
                amount = Math.min(this.itemStacks[2].field_77994_a, invEnderChest.func_70297_j_());
                if ((amount = Math.min(amount, this.itemStacks[2].func_77976_d())) <= 0) continue;
                ItemStack newStack = this.itemStacks[2].func_77946_l();
                newStack.field_77994_a = amount;
                this.itemStacks[2].field_77994_a -= amount;
                invEnderChest.func_70299_a(i, newStack);
                movedSomething = true;
                if (this.itemStacks[2].field_77994_a > 0) continue;
                this.itemStacks[2] = null;
                return true;
            }
        }
        return movedSomething;
    }

    public boolean hasFuelAvailable() {
        if (this.itemStacks[1] == null) {
            return false;
        }
        return TileEntityEnderFurnace.itemContainsFluidFuel(this.itemStacks[1]) || TileEntityEnderFurnace.getItemBurnTime(this.itemStacks[1]) > 0;
    }

    public boolean canSmelt() {
        if (this.itemStacks[0] == null || this.smeltingResultCache == null) {
            return false;
        }
        int amount = 0;
        if (this.outputBufferStack != null) {
            if (!InventoryUtils.areItemStacksEqual(this.smeltingResultCache, this.outputBufferStack)) {
                return false;
            }
            amount = this.outputBufferStack.field_77994_a;
        }
        return 1024 - amount >= this.smeltingResultCache.field_77994_a;
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block.func_149688_o() == Material.field_151575_d) {
                return 2700;
            }
            if (block == Blocks.field_150402_ci) {
                return 144000;
            }
            if (block == Blocks.field_150376_bx) {
                return 1350;
            }
            if (block == Blocks.field_150345_g) {
                return 900;
            }
        } else {
            if (item == Items.field_151044_h) {
                return 14400;
            }
            if (item == Items.field_151072_bj) {
                return 21600;
            }
            if (item == Items.field_151065_br) {
                return 10800;
            }
            if (item == Items.field_151079_bi) {
                return 9600;
            }
            if (item == Items.field_151061_bv) {
                return 20400;
            }
            if (item == Items.field_151129_at) {
                return 180000;
            }
            if (item == Items.field_151055_y) {
                return 900;
            }
            if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
                return 1800;
            }
            if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
                return 1800;
            }
            if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
                return 1800;
            }
        }
        return GameRegistry.getFuelValue((ItemStack)stack) * 1200 * 3 / 400;
    }

    public static int consumeFluidFuelDosage(ItemStack stack) {
        if (!TileEntityEnderFurnace.itemContainsFluidFuel(stack)) {
            return 0;
        }
        FluidStack fluidStack = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
        int amount = Math.min(250, fluidStack.amount);
        ((IFluidContainerItem)stack.func_77973_b()).drain(stack, amount, true);
        return amount * 15 * 1200 / 100;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityEnderFurnace.itemContainsFluidFuel(stack) || TileEntityEnderFurnace.getItemBurnTime(stack) > 0;
    }

    public static boolean itemContainsFluidFuel(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof IFluidContainerItem)) {
            return false;
        }
        FluidStack fluidStack = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
        if (fluidStack == null || fluidStack.amount <= 0) {
            return false;
        }
        Fluid fluid = fluidStack.getFluid();
        return fluid != null && fluid.getName() != null && fluid.getName().equals("lava");
    }

    @Override
    public ItemStack func_70298_a(int slotNum, int maxAmount) {
        if (slotNum == 0) {
            this.inputDirty = true;
        }
        return super.func_70298_a(slotNum, maxAmount);
    }

    @Override
    public ItemStack func_70304_b(int slotNum) {
        if (slotNum == 0) {
            this.inputDirty = true;
        }
        return super.func_70304_b(slotNum);
    }

    @Override
    public void func_70299_a(int slotNum, ItemStack stack) {
        if (slotNum == 0 && !InventoryUtils.areItemStacksEqual(stack, this.itemStacks[slotNum])) {
            this.inputDirty = true;
        }
        super.func_70299_a(slotNum, stack);
    }

    @Override
    public boolean func_94041_b(int slotNum, ItemStack stack) {
        if (slotNum == 2) {
            return false;
        }
        if (slotNum == 1) {
            return InventoryUtils.areItemStacksEqual(stack, this.itemStacks[slotNum]) || TileEntityEnderFurnace.isItemFuel(stack);
        }
        return InventoryUtils.areItemStacksEqual(stack, this.itemStacks[slotNum]) || FurnaceRecipes.func_77602_a().func_151395_a(stack) != null;
    }

    @Override
    public int[] func_94128_d(int side) {
        return SLOTS_SIDES;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (slot == 1) {
            return !TileEntityEnderFurnace.isItemFuel(stack);
        }
        return slot == 2 && !this.outputToEnderChest;
    }

    @Override
    public ContainerEnderFurnace getContainer(InventoryPlayer inventory) {
        return new ContainerEnderFurnace(this, inventory);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiEnderUtilitiesInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiEnderFurnace(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public void performGuiAction(int element, short action) {
        if (element == 0) {
            this.fastMode = !this.fastMode;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (element == 1) {
            this.outputToEnderChest = !this.outputToEnderChest;
        }
        this.func_70296_d();
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int i) {
        return this.cookTime * i / 1200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int i) {
        if (this.burnTimeFresh == 0) {
            return 0;
        }
        return this.burnTimeRemaining * i / this.burnTimeFresh;
    }
}

