/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.entity.ai.EntityAIControlledByPlayerUsingHarness;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.util.EntityUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemMobHarness
extends ItemEnderUtilities {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemMobHarness() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77655_b("mobharness");
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77978_p() == null || !this.hasTarget(stack)) {
            return super.func_77653_i(stack);
        }
        String target = stack.func_77978_p().func_74779_i("TargetName");
        return super.func_77653_i(stack) + " " + EnumChatFormatting.GREEN + target + EnumChatFormatting.RESET + EnumChatFormatting.WHITE;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition movingobjectposition;
        if (world.field_72995_K) {
            return stack;
        }
        if (player.func_70093_af() && (movingobjectposition = this.func_77621_a(world, player, true)) != null && movingobjectposition.field_72313_a != MovingObjectPosition.MovingObjectType.ENTITY && player.field_70125_A > 80.0f) {
            this.clearData(stack);
        }
        return stack;
    }

    public static boolean addAITask(Entity entity, boolean replaceOld) {
        Entity bottom = EntityUtils.getBottomEntity(entity);
        if (bottom instanceof EntityLiving) {
            ((EntityLiving)bottom).func_70661_as().func_75499_g();
            EntityUtils.addAITaskAfterTasks((EntityLiving)bottom, new EntityAIControlledByPlayerUsingHarness((EntityLiving)bottom, 0.3f), replaceOld, new Class[]{EntityAISwimming.class, EntityAIPanic.class});
            return true;
        }
        return false;
    }

    public boolean handleInteraction(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.func_70093_af()) {
            EntityUtils.unmountRider(entity);
            player.func_70078_a(entity);
            ItemMobHarness.addAITask(entity, true);
            return true;
        }
        if (this.hasTarget(stack)) {
            this.mountTarget(stack, player.field_70170_p, player, entity);
        } else if (player.field_70125_A < -80.0f && player.field_70153_n != null) {
            player.field_70153_n.func_70078_a(null);
        } else if (entity.field_70154_o != null) {
            entity.func_70078_a(null);
        } else {
            this.storeTarget(stack, entity);
        }
        return true;
    }

    public boolean hasTarget(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Mode", 1)) {
            return false;
        }
        byte mode = nbt.func_74771_c("Mode");
        return mode >= 1 && mode <= 2 && nbt.func_150297_b("TargetUUIDMost", 4) && nbt.func_150297_b("TargetUUIDLeast", 4) && nbt.func_150297_b("TargetName", 8);
    }

    public ItemStack storeTarget(ItemStack stack, Entity entity) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        byte mode = (byte)(entity instanceof EntityPlayer ? 2 : 1);
        nbt.func_74778_a("TargetName", entity.func_70005_c_());
        nbt.func_74772_a("TargetUUIDMost", entity.func_110124_au().getMostSignificantBits());
        nbt.func_74772_a("TargetUUIDLeast", entity.func_110124_au().getLeastSignificantBits());
        nbt.func_74774_a("Mode", mode);
        stack.func_77982_d(nbt);
        return stack;
    }

    public boolean mountTarget(ItemStack stack, World world, EntityPlayer player, Entity targetEntity) {
        if (stack == null || stack.func_77978_p() == null || targetEntity == null) {
            return false;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        byte mode = nbt.func_74771_c("Mode");
        UUID storedUUID = new UUID(nbt.func_74763_f("TargetUUIDMost"), nbt.func_74763_f("TargetUUIDLeast"));
        EntityPlayer storedEntity = null;
        double r = 64.0;
        if (storedUUID.equals(targetEntity.func_110124_au())) {
            EntityUtils.unmountRider((Entity)player);
            targetEntity.func_70078_a((Entity)player);
            this.clearData(stack);
            return true;
        }
        if (mode == 1) {
            List entities = world.func_72839_b((Entity)player, AxisAlignedBB.func_72330_a((double)(player.field_70165_t - r), (double)(player.field_70163_u - r), (double)(player.field_70161_v - r), (double)(player.field_70165_t + r), (double)(player.field_70163_u + r), (double)(player.field_70161_v + r)));
            storedEntity = EntityUtils.findEntityByUUID(entities, storedUUID);
        } else if (mode == 2) {
            storedEntity = world.func_152378_a(storedUUID);
        }
        if (storedEntity != null && storedEntity.field_71093_bK == player.field_71093_bK) {
            EntityUtils.unmountRider(targetEntity);
            storedEntity.func_70078_a(targetEntity);
            this.clearData(stack);
            return true;
        }
        if (storedEntity == null) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("enderutilities.chat.message.mobharness.targetnotfoundoroutofrange", new Object[0]));
        }
        return false;
    }

    public boolean clearData(ItemStack stack) {
        if (stack == null || stack.func_77978_p() == null) {
            return false;
        }
        stack.func_77982_d(null);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        if (stack.func_77978_p() == null || !this.hasTarget(stack)) {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.notlinked"));
            return;
        }
        String target = stack.func_77978_p().func_74779_i("TargetName");
        list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.linked") + ": " + EnumChatFormatting.GREEN + target + EnumChatFormatting.RESET + EnumChatFormatting.GRAY);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A());
        this.iconArray = new IIcon[2];
        this.iconArray[0] = iconRegister.func_94245_a(this.func_111208_A());
        this.iconArray[1] = iconRegister.func_94245_a(this.func_111208_A() + ".active");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        if (this.hasTarget(stack)) {
            return this.iconArray[1];
        }
        return this.iconArray[0];
    }
}

