/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.client.effects.Sounds;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import fi.dy.masa.enderutilities.util.teleport.TeleportEntity;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ItemEnderPorter
extends ItemLocationBoundModular {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;
    public static final int ENDER_CHARGE_COST_INTER_DIM_TP = 5000;
    public static final int ENDER_CHARGE_COST_CROSS_DIM_TP = 25000;
    private static final int USE_TIME = 40;

    public ItemEnderPorter() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("enderporter");
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() == 1) {
            return super.func_77658_a() + ".advanced";
        }
        return super.func_77658_a();
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (player == null || player.field_70170_p.field_72995_K || !player.func_70093_af() || !NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
            return false;
        }
        NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (!(target == null || EntityUtils.doesEntityStackHaveBlacklistedEntities(entity) || stack.func_77960_j() != 1 && target.dimension != entity.field_71093_bK)) {
            int cost;
            int n = cost = target.dimension == entity.field_71093_bK ? 5000 : 25000;
            if (!UtilItemModular.useEnderCharge(stack, cost, false)) {
                return false;
            }
            if (!(entity instanceof EntityPlayer) || ((EntityPlayer)entity).func_70093_af()) {
                UtilItemModular.useEnderCharge(stack, cost, true);
                TeleportEntity.teleportEntityUsingModularItem(entity, stack, true, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition movingobjectposition;
        if (player == null || !NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
            return stack;
        }
        if (player.func_70093_af() && (movingobjectposition = this.func_77621_a(world, player, true)) != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return stack;
        }
        NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (!(target == null || EntityUtils.doesEntityStackHaveBlacklistedEntities((Entity)player) || stack.func_77960_j() != 1 && target.dimension != player.field_71093_bK)) {
            int cost;
            int n = cost = target.dimension == player.field_71093_bK ? 5000 : 25000;
            if (!UtilItemModular.useEnderCharge(stack, cost, false)) {
                return stack;
            }
            player.func_71008_a(stack, this.func_77626_a(stack));
            if (!world.field_72995_K) {
                Sounds.playSoundEffectServer(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, "portal.travel", 0.06f, 1.2f);
            }
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int inUseCount) {
        if (player == null || !NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
            return;
        }
        int useTime = 40;
        if (player.field_71075_bZ.field_75098_d) {
            useTime >>= 2;
        }
        if (this.func_77626_a(stack) - inUseCount >= useTime) {
            int cost;
            NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            if (target == null || stack.func_77960_j() == 0 && target.dimension != player.field_71093_bK) {
                return;
            }
            int n = cost = target.dimension == player.field_71093_bK ? 5000 : 25000;
            if (!UtilItemModular.useEnderCharge(stack, cost, true)) {
                return;
            }
            TeleportEntity.teleportEntityUsingModularItem((Entity)player, stack, true, true);
        }
    }

    @Override
    public int getMaxModules(ItemStack stack) {
        return 10;
    }

    @Override
    public int getMaxModules(ItemStack stack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 9;
        }
        return 0;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        list.add(new ItemStack((Item)this, 1, 0));
        list.add(new ItemStack((Item)this, 1, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        int i;
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A() + ".stage.1");
        this.iconArray = new IIcon[14];
        for (i = 0; i < 7; ++i) {
            this.iconArray[i] = iconRegister.func_94245_a(this.func_111208_A() + ".stage." + (i + 1));
        }
        for (i = 0; i < 7; ++i) {
            this.iconArray[7 + i] = iconRegister.func_94245_a(this.func_111208_A() + ".advanced.stage." + (i + 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getItemIconForUseDuration(int index) {
        if (index >= this.iconArray.length) {
            index = this.iconArray.length - 1;
        }
        if (index < 0) {
            index = 0;
        }
        return this.iconArray[index];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        return this.getIcon(stack, renderPass, null, null, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        int index = 0;
        if (player != null && player.func_71011_bu() != null && stack != null) {
            int inUse = stack.func_77988_m() - useRemaining;
            int useTime = 40;
            if (player.field_71075_bZ.field_75098_d) {
                useTime >>= 2;
            }
            if ((index += 7 * inUse / useTime) > 6) {
                index = 6;
            }
        }
        if (stack.func_77960_j() == 1) {
            index += 7;
        }
        return this.getItemIconForUseDuration(index);
    }
}

