/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.item.base.IChunkLoadingItem;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.setup.Registry;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ItemEnderBag
extends ItemLocationBoundModular
implements IChunkLoadingItem,
IKeyBound {
    public static final int ENDER_CHARGE_COST = 200;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemEnderBag() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77655_b("enderbag");
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K || stack == null || stack.func_77978_p() == null) {
            return stack;
        }
        NBTTagCompound bagNbt = stack.func_77978_p();
        NBTHelperTarget targetData = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (targetData == null || targetData.blockName == null) {
            return stack;
        }
        if (targetData.blockName.equals("minecraft:ender_chest")) {
            if (!UtilItemModular.useEnderCharge(stack, 200, true)) {
                return stack;
            }
            bagNbt.func_74757_a("IsOpen", true);
            player.func_71007_a((IInventory)player.func_71005_bN());
            return stack;
        }
        if (!NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
            return stack;
        }
        if (!ItemEnderBag.isTargetBlockWhitelisted(targetData.blockName, targetData.blockMeta) && ItemEnderBag.targetOutsideOfPlayerRange(stack, player)) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"enderutilities.chat.message.enderbag.outofrange")));
            return stack;
        }
        if (!targetData.isTargetBlockUnchanged()) {
            NBTHelperTarget.removeTargetTagFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            bagNbt.func_82580_o("ChunkLoadingRequired");
            bagNbt.func_82580_o("IsOpen");
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("enderutilities.chat.message.bound.block.changed", new Object[0]));
            return stack;
        }
        if (!UtilItemModular.useEnderCharge(stack, 200, false)) {
            return stack;
        }
        if (ChunkLoading.getInstance().loadChunkForcedWithPlayerTicket(player, targetData.dimension, targetData.posX >> 4, targetData.posZ >> 4, 60)) {
            MinecraftServer server = MinecraftServer.func_71276_C();
            if (server == null) {
                return stack;
            }
            WorldServer targetWorld = server.func_71218_a(targetData.dimension);
            if (targetWorld == null) {
                return stack;
            }
            if (!UtilItemModular.useEnderCharge(stack, 200, true)) {
                return stack;
            }
            bagNbt.func_74757_a("ChunkLoadingRequired", true);
            bagNbt.func_74757_a("IsOpen", true);
            float hx = (float)targetData.dPosX - (float)targetData.posX;
            float hy = (float)targetData.dPosY - (float)targetData.posY;
            float hz = (float)targetData.dPosZ - (float)targetData.posZ;
            Block block = targetWorld.func_147439_a(targetData.posX, targetData.posY, targetData.posZ);
            block.func_149727_a((World)targetWorld, targetData.posX, targetData.posY, targetData.posZ, player, targetData.blockFace, hx, hy, hz);
        }
        return stack;
    }

    @Override
    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && player.func_70093_af() && te != null && (te instanceof IInventory || te.getClass() == TileEntityEnderChest.class)) {
            return super.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }
        return false;
    }

    @Override
    public int getMaxModules(ItemStack toolStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        if (!moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) || imodule.getModuleTier(moduleStack) == 1) {
            return this.getMaxModules(toolStack, moduleType);
        }
        return 0;
    }

    public static boolean targetNeedsToBeLoadedOnClient(ItemStack stack) {
        NBTHelperTarget targetData = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (targetData == null || targetData.blockName == null) {
            return false;
        }
        return !targetData.blockName.equals("minecraft:ender_chest") && !ItemEnderBag.isTargetBlockWhitelisted(targetData.blockName, targetData.blockMeta);
    }

    public static boolean targetOutsideOfPlayerRange(ItemStack stack, EntityPlayer player) {
        NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (target == null) {
            return true;
        }
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(target.dimension);
        return !(player instanceof EntityPlayerMP) || world == null || !world.func_73040_p().func_72694_a((EntityPlayerMP)player, target.posX >> 4, target.posZ >> 4);
    }

    public static boolean isTargetBlockWhitelisted(String name, int meta) {
        if (Configs.enderBagListType.getString().equalsIgnoreCase("blacklist")) {
            List<String> list = Registry.getEnderbagBlacklist();
            return !list.contains(name);
        }
        List<String> list = Registry.getEnderbagWhitelist();
        return list.contains(name);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        ItemStack targetStack;
        NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (target != null && (targetStack = new ItemStack(Block.func_149684_b((String)target.blockName), 1, target.blockMeta & 0xF)) != null && targetStack.func_77973_b() != null) {
            String pre = EnumChatFormatting.GREEN.toString();
            String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.WHITE.toString();
            return StatCollector.func_74838_a((String)(this.func_77667_c(stack) + ".name")).trim() + " " + pre + targetStack.func_82833_r() + rst;
        }
        return StatCollector.func_74838_a((String)(this.func_77657_g(stack) + ".name")).trim();
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (target != null && "minecraft:ender_chest".equals(target.blockName)) {
            ItemStack targetStack = new ItemStack(Block.func_149684_b((String)target.blockName), 1, target.blockMeta & 0xF);
            String targetName = targetStack != null && targetStack.func_77973_b() != null ? targetStack.func_82833_r() : "";
            String textPre = EnumChatFormatting.DARK_GREEN.toString();
            String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.target") + ": " + textPre + targetName + rst);
            return;
        }
        super.addInformationSelective(stack, player, list, advancedTooltips, verbose);
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return false;
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity player, int slot, boolean isCurrent) {
        NBTTagCompound nbt;
        super.func_77663_a(stack, world, player, slot, isCurrent);
        if (stack != null && stack.func_77978_p() != null && (nbt = stack.func_77978_p()).func_74764_b("IsOpenDummy")) {
            nbt.func_82580_o("IsOpenDummy");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A() + ".regular.closed");
        this.iconArray = new IIcon[6];
        this.iconArray[0] = iconRegister.func_94245_a(this.func_111208_A() + ".regular.closed");
        this.iconArray[1] = iconRegister.func_94245_a(this.func_111208_A() + ".regular.open");
        this.iconArray[2] = iconRegister.func_94245_a(this.func_111208_A() + ".enderchest.closed");
        this.iconArray[3] = iconRegister.func_94245_a(this.func_111208_A() + ".enderchest.open");
        this.iconArray[4] = iconRegister.func_94245_a(this.func_111208_A() + ".locked.closed");
        this.iconArray[5] = iconRegister.func_94245_a(this.func_111208_A() + ".locked.open");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        int index = 0;
        NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (target != null) {
            NBTHelperPlayer playerData;
            int isOpen = 0;
            if (stack.func_77978_p().func_74767_n("IsOpen")) {
                isOpen = 1;
                ++index;
            }
            if ("minecraft:ender_chest".equals(target.blockName)) {
                index += 2;
            }
            if (renderPass == 1 && (playerData = NBTHelperPlayer.getPlayerDataFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL)) != null && !playerData.isPublic) {
                index = 4 + isOpen;
            }
        }
        return this.iconArray[index < this.iconArray.length ? index : 0];
    }
}

