/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block.machine;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.block.machine.MachineEnderFurnace;
import fi.dy.masa.enderutilities.block.machine.MachineEnergyBridge;
import fi.dy.masa.enderutilities.block.machine.MachineToolWorkstation;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderFurnace;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderInfuser;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnergyBridge;
import fi.dy.masa.enderutilities.tileentity.TileEntityToolWorkstation;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class Machine {
    protected static TIntObjectHashMap<Machine> machines = new TIntObjectHashMap();
    public static Machine enderFurnace = new MachineEnderFurnace(0, 0, "enderfurnace", TileEntityEnderFurnace.class, "pickaxe", 1, 6.0f);
    public static Machine toolWorkstation = new MachineToolWorkstation(0, 1, "toolworkstation", TileEntityToolWorkstation.class, "pickaxe", 1, 6.0f);
    public static Machine enderInfuser = new Machine(0, 2, "enderinfuser", TileEntityEnderInfuser.class, "pickaxe", 1, 6.0f);
    public static Machine energyBridgeTransmitter = new MachineEnergyBridge(1, 0, "energybridge.transmitter", TileEntityEnergyBridge.class, "pickaxe", 1, 6.0f);
    public static Machine energyBridgeReceiver = new MachineEnergyBridge(1, 1, "energybridge.receiver", TileEntityEnergyBridge.class, "pickaxe", 1, 6.0f);
    public static Machine energyBridgeResonator = new MachineEnergyBridge(1, 2, "energybridge.resonator", TileEntityEnergyBridge.class, "pickaxe", 1, 6.0f);
    protected int blockIndex;
    protected int blockMeta;
    protected int machineIndex;
    protected String blockName;
    protected Class<? extends TileEntityEnderUtilities> tileEntityClass;
    protected String toolClass;
    protected int harvestLevel;
    protected float blockHardness;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] icons;

    public Machine(int index, int meta, String name, Class<? extends TileEntityEnderUtilities> TEClass, String tool, int harvestLevel, float hardness) {
        this.blockIndex = index;
        this.blockMeta = meta;
        this.machineIndex = index << 4 | meta & 0xF;
        this.blockName = name;
        this.tileEntityClass = TEClass;
        this.toolClass = tool;
        this.harvestLevel = harvestLevel;
        this.blockHardness = hardness;
        machines.put(this.machineIndex, (Object)this);
    }

    public String getBlockName() {
        return this.blockName;
    }

    public static Machine getMachine(int blockIndex, int meta) {
        return (Machine)machines.get(blockIndex << 4 | meta & 0xF);
    }

    public TileEntity createNewTileEntity() {
        try {
            return this.tileEntityClass.newInstance();
        }
        catch (IllegalAccessException e) {
            EnderUtilities.logger.fatal(String.format("Unable to create instance of TileEntity from %s (IllegalAccessException)", this.tileEntityClass.getName()));
            return null;
        }
        catch (InstantiationException e) {
            EnderUtilities.logger.fatal(String.format("Unable to create instance of TileEntity from %s (InstantiationException)", this.tileEntityClass.getName()));
            return null;
        }
    }

    public boolean isTileEntityValid(TileEntity te) {
        return te != null && te.getClass() == this.tileEntityClass;
    }

    public static String[] getNames(int blockIndex) {
        String[] names = new String[16];
        for (int meta = 0; meta < 16; ++meta) {
            Machine m = Machine.getMachine(blockIndex, meta);
            names[meta] = m != null ? m.blockName : "null";
        }
        return names;
    }

    public static Block setBlockHardness(Block block, int blockIndex) {
        for (int meta = 0; meta < 16; ++meta) {
            Machine m = Machine.getMachine(blockIndex, meta);
            if (m == null) continue;
            block.func_149711_c(m.blockHardness);
            break;
        }
        return block;
    }

    public static Block setBlockHarvestLevels(Block block, int blockIndex) {
        for (int meta = 0; meta < 16; ++meta) {
            Machine m = Machine.getMachine(blockIndex, meta);
            if (m == null) continue;
            block.setHarvestLevel(m.toolClass, m.harvestLevel, meta);
        }
        return block;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase livingBase, ItemStack stack) {
    }

    public void onBlockAdded(World world, int x, int y, int z) {
    }

    public void onBlockPreDestroy(World world, int x, int y, int z, int oldMeta) {
    }

    public boolean breakBlock(World world, int x, int y, int z, Block block, int meta) {
        return false;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float offsetX, float offsetY, float offsetZ) {
        PlayerInteractEvent e = new PlayerInteractEvent(player, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, x, y, z, side, world);
        if (MinecraftForge.EVENT_BUS.post((Event)e) || e.getResult() == Event.Result.DENY || e.useBlock == Event.Result.DENY) {
            return false;
        }
        if (!world.field_72995_K) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te == null || !(te instanceof TileEntityEnderUtilities)) {
                return false;
            }
            if (this.isTileEntityValid(te)) {
                player.openGui((Object)EnderUtilities.instance, 0, world, x, y, z);
            }
        }
        return true;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z, Block block, int meta) {
        return block.func_149750_m();
    }

    @SideOnly(value=Side.CLIENT)
    public static void getSubBlocks(int blockIndex, Block block, Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int meta = 0; meta < 16; ++meta) {
            if (Machine.getMachine(blockIndex, meta) == null) continue;
            list.add(new ItemStack(block, 1, meta));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.icons[1];
        }
        if (side == 3) {
            return this.icons[2];
        }
        return this.icons[4];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(TileEntityEnderUtilities te, int side, int meta) {
        if (side == 0 || side == 1) {
            return this.icons[side];
        }
        if (te != null && side == te.getRotation()) {
            return this.icons[2];
        }
        return this.icons[4];
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[6];
        this.icons[0] = iconRegister.func_94245_a(ReferenceTextures.getTileName(this.blockName) + ".bottom");
        this.icons[1] = iconRegister.func_94245_a(ReferenceTextures.getTileName(this.blockName) + ".top");
        this.icons[2] = iconRegister.func_94245_a(ReferenceTextures.getTileName(this.blockName) + ".front");
        this.icons[3] = iconRegister.func_94245_a(ReferenceTextures.getTileName(this.blockName) + ".back");
        this.icons[4] = iconRegister.func_94245_a(ReferenceTextures.getTileName(this.blockName) + ".left");
        this.icons[5] = iconRegister.func_94245_a(ReferenceTextures.getTileName(this.blockName) + ".right");
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(int blockIndex, IIconRegister iconRegister) {
        for (int meta = 0; meta < 16; ++meta) {
            Machine m = Machine.getMachine(blockIndex, meta);
            if (m == null) continue;
            m.registerIcons(iconRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
    }
}

