/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.leveling.modifiers;

import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.modifiers.tools.ModRedstone;

public class ModXpAwareRedstone
extends ModRedstone {
    public final ModRedstone originalModifier;

    public ModXpAwareRedstone(ModRedstone modifier) {
        super(modifier.effectIndex, ModXpAwareRedstone.ListStackToStackArray(modifier.stacks), ModXpAwareRedstone.ListIntToIntArray(modifier.increase));
        this.originalModifier = modifier;
    }

    public void modify(ItemStack[] input, ItemStack tool) {
        float xp;
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        long oldXP = LevelingLogic.getRequiredXp(tool, tags);
        long oldBoostXP = LevelingLogic.getRequiredBoostXp(tool);
        super.modify(input, tool);
        if (LevelingLogic.hasXp(tags)) {
            long newXP = LevelingLogic.getRequiredXp(tool, tags);
            xp = LevelingLogic.getXp(tags);
            tags.func_74772_a("ToolEXP", (long)Math.round(xp *= (float)newXP / (float)oldXP));
        }
        if (LevelingLogic.hasBoostXp(tags)) {
            long newBoostXP = LevelingLogic.getRequiredBoostXp(tool);
            xp = LevelingLogic.getBoostXp(tags);
            tags.func_74772_a("HeadEXP", (long)Math.round(xp *= (float)newBoostXP / (float)oldBoostXP));
        }
    }

    static int[] ListIntToIntArray(List<Integer> list) {
        int[] arr = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    static ItemStack[] ListStackToStackArray(List<ItemStack> list) {
        ItemStack[] arr = new ItemStack[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }
}

