/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel.api.carving;

import com.cricketcraft.chisel.api.ChiselAPIProps;
import com.cricketcraft.chisel.api.FMPIMC;
import com.cricketcraft.chisel.api.carving.CarvingUtils;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import com.cricketcraft.chisel.api.carving.IVariationInfo;
import com.cricketcraft.chisel.api.carving.VariationInfoBase;
import com.cricketcraft.chisel.api.rendering.TextureType;
import com.cricketcraft.ctmlib.ISubmapManager;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.oredict.OreDictionary;

public class CarvableHelper {
    public static Class<? extends ItemBlock> itemCarvableClass = null;
    private Block theBlock;
    public ArrayList<IVariationInfo> infoList = new ArrayList();
    IVariationInfo[] infoMap = new IVariationInfo[16];
    public boolean forbidChiseling = false;

    public CarvableHelper(Block block) {
        this.theBlock = block;
    }

    public void addVariation(String description, int metadata, ISubmapManager manager) {
        this.addVariation(description, metadata, null, manager);
    }

    public void addVariation(String description, int metadata, Block bb) {
        this.addVariation(description, metadata, null, bb, 0, ChiselAPIProps.MOD_ID);
    }

    public void addVariation(String description, int metadata, Block bb, int blockMeta) {
        this.addVariation(description, metadata, null, bb, blockMeta, ChiselAPIProps.MOD_ID);
    }

    public void addVariation(String description, int metadata, Block bb, int blockMeta, Material material) {
        this.addVariation(description, metadata, null, bb, blockMeta, ChiselAPIProps.MOD_ID);
    }

    public void addVariation(String description, int metadata, String texture) {
        this.addVariation(description, metadata, texture, (ISubmapManager)null);
    }

    public void addVariation(String description, int metadata, String texture, ISubmapManager manager) {
        this.addVariation(description, metadata, texture, null, 0, ChiselAPIProps.MOD_ID, manager, metadata);
    }

    public void addVariation(String description, int metadata, Block bb, String modid) {
        this.addVariation(description, metadata, null, bb, 0, modid);
    }

    public void addVariation(String description, int metadata, Block bb, int blockMeta, String modid) {
        this.addVariation(description, metadata, null, bb, blockMeta, modid);
    }

    public void addVariation(String description, int metadata, Block bb, int blockMeta, Material material, String modid) {
        this.addVariation(description, metadata, null, bb, blockMeta, modid);
    }

    public void addVariation(String description, int metadata, String texture, String modid) {
        this.addVariation(description, metadata, texture, null, 0, modid);
    }

    public void addVariation(String description, int metadata, String texture, Block block, int blockMeta, String modid) {
        this.addVariation(description, metadata, texture, block, blockMeta, modid, null, metadata);
    }

    public void addVariation(String description, int metadata, String texture, int order) {
        this.addVariation(description, metadata, texture, null, 0, ChiselAPIProps.MOD_ID, null, order);
    }

    public void addVariation(String description, int metadata, String texture, Block block, int blockMeta, String modid, ISubmapManager customManager, int order) {
        if (this.infoList.size() >= 16) {
            return;
        }
        IVariationInfo info = FMLCommonHandler.instance().getSide().isClient() ? this.getClientInfo(modid, texture, description, metadata, block, blockMeta, customManager, order) : this.getServerInfo(modid, texture, description, metadata, block, blockMeta, customManager, order);
        this.infoList.add(info);
        this.infoMap[metadata] = info;
    }

    private IVariationInfo getClientInfo(String modid, String texture, String description, int metadata, Block block, int blockMeta, ISubmapManager customManager, int order) {
        ICarvingVariation var = CarvingUtils.getDefaultVariationFor(this.theBlock, metadata, order);
        TextureType type = TextureType.getTypeFor(this, modid, texture);
        if (type == TextureType.CUSTOM && customManager == null && block == null) {
            throw new IllegalArgumentException(String.format("Could not find texture %s, and no custom texture manager was provided.", texture));
        }
        ISubmapManager manager = customManager != null ? customManager : (block != null ? type.createManagerFor(var, block, blockMeta) : type.createManagerFor(var, texture));
        return new VariationInfoBase(var, description, manager);
    }

    private IVariationInfo getServerInfo(String modid, String texture, String description, int metadata, Block block, int blockMeta, ISubmapManager customManager, int order) {
        ICarvingVariation var = CarvingUtils.getDefaultVariationFor(this.theBlock, metadata, order);
        return new VariationInfoBase(var, description, null);
    }

    public IVariationInfo getVariation(int metadata) {
        IVariationInfo info;
        if (metadata < 0 || metadata > 15) {
            metadata = 0;
        }
        if ((info = this.infoMap[metadata]) == null) {
            return null;
        }
        return info;
    }

    public IIcon getIcon(int side, int metadata) {
        IVariationInfo info;
        if (metadata < 0 || metadata > 15) {
            metadata = 0;
        }
        if ((info = this.infoMap[metadata]) == null) {
            return this.getMissingIcon();
        }
        return info.getIcon(side, metadata);
    }

    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        IVariationInfo info;
        int metadata = world.func_72805_g(x, y, z);
        if (metadata < 0 || metadata > 15) {
            metadata = 0;
        }
        if ((info = this.infoMap[metadata]) == null) {
            return this.getMissingIcon();
        }
        return info.getIcon(world, x, y, z, side);
    }

    public void registerAll(Block block, String name) {
        this.registerAll(block, name, itemCarvableClass);
    }

    public void registerBlock(Block block, String name) {
        this.registerBlock(block, name, itemCarvableClass);
    }

    void registerBlock(Block block, String name, Class<? extends ItemBlock> cl) {
        block.func_149663_c("chisel." + name);
        GameRegistry.registerBlock((Block)block, cl, (String)name);
    }

    public void registerAll(Block block, String name, Class<? extends ItemBlock> cl) {
        this.registerBlock(block, name, cl);
        this.registerVariations(name);
    }

    public void registerVariations(String name) {
        for (IVariationInfo info : this.infoList) {
            this.registerVariation(name, info);
        }
    }

    public void registerVariation(String name, IVariationInfo info) {
        Block block = info.getVariation().getBlock();
        if (block.func_149686_d() || block.func_149662_c() || block.func_149721_r()) {
            FMPIMC.registerFMP(block, info.getVariation().getBlockMeta());
        }
        if (this.forbidChiseling) {
            return;
        }
        CarvingUtils.getChiselRegistry().addVariation(name, info.getVariation());
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(String modName, Block block, IIconRegister register) {
        for (IVariationInfo info : this.infoList) {
            info.registerIcons(modName, block, register);
        }
    }

    public void registerSubBlocks(Block block, CreativeTabs tabs, List<ItemStack> list) {
        for (IVariationInfo info : this.infoList) {
            list.add(new ItemStack(block, 1, info.getVariation().getItemMeta()));
        }
    }

    public void registerOre(String ore) {
        OreDictionary.registerOre((String)ore, (Block)this.theBlock);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getMissingIcon() {
        return ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
    }
}

