/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.multiblock;

import cofh.thermaldynamics.block.Attachment;
import cofh.thermaldynamics.core.TickHandler;
import cofh.thermaldynamics.core.WorldGridList;
import cofh.thermaldynamics.debughelper.NoComodSet;
import cofh.thermaldynamics.duct.attachments.relay.Relay;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MultiBlockGrid {
    public NoComodSet<IMultiBlock> nodeSet = new NoComodSet();
    public NoComodSet<IMultiBlock> idleSet = new NoComodSet();
    public WorldGridList worldGrid;
    public boolean signalsUpToDate;
    public int redstoneLevel;
    public byte nextRedstoneLevel = (byte)-128;
    public ArrayList<Relay> relaysIn;
    public ArrayList<Attachment> relaysOut;

    public MultiBlockGrid(WorldGridList worldGridList) {
        this.worldGrid = worldGridList;
        worldGridList.newGrids.add(this);
    }

    public MultiBlockGrid(World world) {
        this(TickHandler.getTickHandler(world));
    }

    public void addIdle(IMultiBlock iMultiBlock) {
        this.idleSet.add(iMultiBlock);
        if (this.nodeSet.contains(iMultiBlock)) {
            this.nodeSet.remove(iMultiBlock);
            this.onMajorGridChange();
        } else {
            boolean bl = false;
            for (byte by = 0; by < ForgeDirection.VALID_DIRECTIONS.length; by = (byte)(by + 1)) {
                if (!iMultiBlock.isSideConnected(by)) continue;
                if (bl) {
                    this.onMajorGridChange();
                    break;
                }
                bl = true;
            }
        }
        this.balanceGrid();
    }

    public void addNode(IMultiBlock iMultiBlock) {
        this.nodeSet.add(iMultiBlock);
        if (this.idleSet.contains(iMultiBlock)) {
            this.idleSet.remove(iMultiBlock);
        }
        this.onMajorGridChange();
        this.balanceGrid();
    }

    public void mergeGrids(MultiBlockGrid multiBlockGrid) {
        if (!multiBlockGrid.nodeSet.isEmpty()) {
            for (IMultiBlock iMultiBlock : multiBlockGrid.nodeSet) {
                iMultiBlock.setGrid(this);
                this.addBlock(iMultiBlock);
            }
            this.onMajorGridChange();
        }
        if (!multiBlockGrid.idleSet.isEmpty()) {
            for (IMultiBlock iMultiBlock : multiBlockGrid.idleSet) {
                iMultiBlock.setGrid(this);
                this.addBlock(iMultiBlock);
            }
            this.onMajorGridChange();
        }
        this.onMinorGridChange();
        multiBlockGrid.destroy();
    }

    public void destroy() {
        this.nodeSet.clear();
        this.idleSet.clear();
        this.worldGrid.oldGrids.add(this);
    }

    public boolean canGridsMerge(MultiBlockGrid multiBlockGrid) {
        return multiBlockGrid.getClass() == this.getClass();
    }

    public void resetMultiBlocks() {
        for (IMultiBlock iMultiBlock : this.nodeSet) {
            iMultiBlock.setValidForForming();
        }
        for (IMultiBlock iMultiBlock : this.idleSet) {
            iMultiBlock.setValidForForming();
        }
    }

    public void tickGrid() {
        Attachment attachment2;
        if (this.nextRedstoneLevel != -128) {
            this.redstoneLevel = this.nextRedstoneLevel;
            this.nextRedstoneLevel = (byte)-128;
            ArrayList<Attachment> arrayList = this.relaysOut;
            if (arrayList != null) {
                for (Attachment attachment2 : arrayList) {
                    attachment2.checkSignal();
                }
            }
        }
        if (this.signalsUpToDate) {
            return;
        }
        this.signalsUpToDate = true;
        if (this.relaysIn == null) {
            this.relaysOut = null;
            for (IMultiBlock iMultiBlock : this.nodeSet) {
                iMultiBlock.addRelays();
            }
        }
        if (this.relaysIn == null) {
            this.nextRedstoneLevel = 0;
            return;
        }
        if (this.relaysOut == null) {
            this.nextRedstoneLevel = 0;
            return;
        }
        int n = 0;
        Iterator<Relay> iterator = this.relaysIn.iterator();
        while (iterator.hasNext() && (n = Math.max(n, ((Relay)(attachment2 = iterator.next())).getPowerLevel())) != 15) {
        }
        this.nextRedstoneLevel = (byte)n;
    }

    public void addSignalInput(Relay relay) {
        if (relay.isInput()) {
            if (this.relaysIn == null) {
                this.relaysIn = new ArrayList();
            }
            this.relaysIn.add(relay);
        }
    }

    public void addSignalOutput(Attachment attachment) {
        if (this.relaysOut == null) {
            this.relaysOut = new ArrayList();
        }
        this.relaysOut.add(attachment);
    }

    public void balanceGrid() {
    }

    public void addBlock(IMultiBlock iMultiBlock) {
        if (iMultiBlock.isNode()) {
            this.addNode(iMultiBlock);
        } else {
            this.addIdle(iMultiBlock);
        }
    }

    public void destroyAndRecreate() {
        this.worldGrid.gridsToRecreate.add(this);
    }

    public void removeBlock(IMultiBlock iMultiBlock) {
        this.destroyNode(iMultiBlock);
        if (iMultiBlock.isNode()) {
            this.nodeSet.remove(iMultiBlock);
            this.onMajorGridChange();
        } else {
            this.idleSet.remove(iMultiBlock);
        }
        if (this.nodeSet.isEmpty() && this.idleSet.isEmpty()) {
            this.worldGrid.oldGrids.add(this);
            return;
        }
        int n = 0;
        for (byte by = 0; by < 6; by = (byte)(by + 1)) {
            if (!iMultiBlock.isSideConnected(by)) continue;
            n = (byte)(n + 1);
        }
        if (n <= 1) {
            this.balanceGrid();
            this.onMinorGridChange();
            return;
        }
        this.onMajorGridChange();
        this.worldGrid.gridsToRecreate.add(this);
    }

    public void onMinorGridChange() {
        this.resetRelays();
    }

    public void onMajorGridChange() {
        this.resetRelays();
    }

    public void resetRelays() {
        this.relaysIn = null;
        this.relaysOut = null;
        this.signalsUpToDate = false;
    }

    public int size() {
        return this.nodeSet.size() + this.idleSet.size();
    }

    public void doTickProcessing(long l) {
    }

    public boolean isTickProcessing() {
        return false;
    }

    public void destroyNode(IMultiBlock iMultiBlock) {
        iMultiBlock.setGrid(null);
    }

    public boolean isFirstMultiblock(IMultiBlock iMultiBlock) {
        return !this.nodeSet.isEmpty() ? this.nodeSet.iterator().next() == iMultiBlock : !this.idleSet.isEmpty() && this.idleSet.iterator().next() == iMultiBlock;
    }

    public abstract boolean canAddBlock(IMultiBlock var1);
}

