/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.entity;

import cofh.core.render.ShaderHelper;
import cofh.lib.util.position.BlockPosition;
import cofh.thermaldynamics.duct.entity.Camera;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import cofh.thermaldynamics.duct.entity.TileTransportDuct;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import org.lwjgl.opengl.GL11;

public class TransportHandler {
    public static final TransportHandler INSTANCE = new TransportHandler();
    @SideOnly(value=Side.CLIENT)
    Camera camera;

    @SubscribeEvent
    public void cancelDamgage(LivingAttackEvent livingAttackEvent) {
        EntityLivingBase entityLivingBase = livingAttackEvent.entityLiving;
        Entity entity = entityLivingBase.field_70154_o;
        if (entity != null && entity.getClass() == EntityTransport.class) {
            EntityTransport entityTransport = (EntityTransport)entity;
            BlockPosition blockPosition = entityTransport.pos;
            if (blockPosition == null) {
                return;
            }
            TileEntity tileEntity = livingAttackEvent.entity.field_70170_p.func_147438_o(blockPosition.x, blockPosition.y, blockPosition.z);
            if (tileEntity != null && !tileEntity.func_145837_r() && tileEntity instanceof TileTransportDuct) {
                livingAttackEvent.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void cancelOverlay(RenderBlockOverlayEvent renderBlockOverlayEvent) {
        EntityPlayer entityPlayer = renderBlockOverlayEvent.player;
        Entity entity = entityPlayer.field_70154_o;
        if (entity != null && entity.getClass() == EntityTransport.class) {
            renderBlockOverlayEvent.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public void renderTravellers(RenderLivingEvent.Pre pre) {
        EntityLivingBase entityLivingBase = pre.entity;
        Entity entity = entityLivingBase.field_70154_o;
        if (entity != null && entity.getClass() == EntityTransport.class) {
            pre.setCanceled(true);
            if (entityLivingBase == Minecraft.func_71410_x().field_71439_g) {
                return;
            }
            float f = ShaderHelper.midGameTick;
            ((EntityTransport)entity).setPosition(f);
            entity.func_70043_V();
            float f2 = entityLivingBase.field_70126_B + (entityLivingBase.field_70177_z - entityLivingBase.field_70126_B) * f;
            entityLivingBase.field_70154_o = null;
            GL11.glPushMatrix();
            float f3 = Math.max(entityLivingBase.field_70131_O, entityLivingBase.field_70130_N);
            GL11.glTranslated((double)pre.x, (double)pre.y, (double)pre.z);
            double d = f3 == 0.0f ? 1.0 : 0.5 / (double)f3;
            GL11.glScaled((double)d, (double)d, (double)d);
            pre.renderer.func_76986_a((Entity)entityLivingBase, 0.0, 0.0, 0.0, f2, f);
            GL11.glPopMatrix();
            entityLivingBase.field_70154_o = entity;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void controlPlayer(TickEvent.ClientTickEvent clientTickEvent) {
        if (clientTickEvent.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityClientPlayerMP entityClientPlayerMP = minecraft.field_71439_g;
        if (entityClientPlayerMP == null) {
            return;
        }
        Entity entity = entityClientPlayerMP.field_70154_o;
        if (entity != null && entity.getClass() == EntityTransport.class) {
            double d = 0.0;
            double d2 = 0.0;
            byte by = ((EntityTransport)entity).direction;
            switch (by) {
                case 0: {
                    d2 = 90.0;
                    break;
                }
                case 1: {
                    d2 = -90.0;
                    break;
                }
                case 2: {
                    d = 180.0;
                    break;
                }
                case 3: {
                    d = 0.0;
                    break;
                }
                case 4: {
                    d = 90.0;
                    break;
                }
                case 5: {
                    d = 270.0;
                    break;
                }
                default: {
                    return;
                }
            }
            entityClientPlayerMP.field_70125_A = (float)((double)entityClientPlayerMP.field_70125_A + Math.sin((d2 - (double)entityClientPlayerMP.field_70125_A) / 180.0 * Math.PI) * 20.0);
            if (d2 == 0.0) {
                entityClientPlayerMP.field_70177_z = (float)((double)entityClientPlayerMP.field_70177_z + Math.sin((d - (double)entityClientPlayerMP.field_70177_z) / 180.0 * Math.PI) * 20.0);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void controlCamera(TickEvent.RenderTickEvent renderTickEvent) {
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityClientPlayerMP entityClientPlayerMP = minecraft.field_71439_g;
        if (entityClientPlayerMP == null) {
            return;
        }
        Entity entity = entityClientPlayerMP.field_70154_o;
        if (entity == null) {
            if (minecraft.field_71451_h != null && minecraft.field_71451_h == this.camera) {
                minecraft.field_71451_h = entityClientPlayerMP;
            }
        } else if (entity.getClass() == EntityTransport.class) {
            EntityTransport entityTransport = (EntityTransport)entity;
            if (this.camera == null) {
                this.camera = new Camera();
            }
            this.camera.copyFromEntityTransport(entityTransport, (EntityPlayer)entityClientPlayerMP);
            minecraft.field_71451_h = this.camera;
        }
    }
}

