/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.core;

import cofh.lib.util.helpers.ServerHelper;
import cofh.thermaldynamics.core.WorldGridList;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.WeakHashMap;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;

public class TickHandler {
    public static TickHandler INSTANCE = new TickHandler();
    public static final WeakHashMap<World, WorldGridList> handlers = new WeakHashMap();
    public static final LinkedHashSet<WeakReference<IMultiBlock>> multiBlocksToCalculate = new LinkedHashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMultiBlockToCalculate(IMultiBlock iMultiBlock) {
        if (iMultiBlock.world() != null) {
            if (ServerHelper.isServerWorld((World)iMultiBlock.world())) {
                TickHandler.getTickHandler((World)iMultiBlock.world()).tickingBlocks.add(iMultiBlock);
            }
        } else {
            LinkedHashSet<WeakReference<IMultiBlock>> linkedHashSet = multiBlocksToCalculate;
            synchronized (linkedHashSet) {
                multiBlocksToCalculate.add(new WeakReference<IMultiBlock>(iMultiBlock));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorldGridList getTickHandler(World world) {
        if (ServerHelper.isClientWorld((World)world)) {
            throw new IllegalStateException("World Grid called client-side");
        }
        WeakHashMap<World, WorldGridList> weakHashMap = handlers;
        synchronized (weakHashMap) {
            WorldGridList worldGridList = handlers.get(world);
            if (worldGridList != null) {
                return worldGridList;
            }
            worldGridList = new WorldGridList(world);
            handlers.put(world, worldGridList);
            return worldGridList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent serverTickEvent) {
        if (serverTickEvent.phase != TickEvent.Phase.END) {
            return;
        }
        LinkedHashSet<WeakReference<IMultiBlock>> linkedHashSet = multiBlocksToCalculate;
        synchronized (linkedHashSet) {
            if (!multiBlocksToCalculate.isEmpty()) {
                Iterator iterator = multiBlocksToCalculate.iterator();
                while (iterator.hasNext()) {
                    IMultiBlock iMultiBlock = (IMultiBlock)((WeakReference)iterator.next()).get();
                    if (iMultiBlock == null) {
                        iterator.remove();
                        continue;
                    }
                    if (iMultiBlock.world() == null) continue;
                    if (ServerHelper.isServerWorld((World)iMultiBlock.world())) {
                        TickHandler.getTickHandler((World)iMultiBlock.world()).tickingBlocks.add(iMultiBlock);
                    }
                    iterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent worldTickEvent) {
        if (handlers.isEmpty()) {
            return;
        }
        WeakHashMap<World, WorldGridList> weakHashMap = handlers;
        synchronized (weakHashMap) {
            WorldGridList worldGridList = handlers.get(worldTickEvent.world);
            if (worldGridList == null) {
                return;
            }
            if (worldTickEvent.phase == TickEvent.Phase.START) {
                worldGridList.tickStart();
            } else {
                worldGridList.tickEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload unload) {
        WeakHashMap<World, WorldGridList> weakHashMap = handlers;
        synchronized (weakHashMap) {
            handlers.remove(unload.world);
        }
    }
}

