/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.gui;

import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.abstraction.EntryAbstract;
import amerifrance.guideapi.api.abstraction.IPage;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.buttons.ButtonBack;
import amerifrance.guideapi.buttons.ButtonNext;
import amerifrance.guideapi.buttons.ButtonPrev;
import amerifrance.guideapi.gui.GuiBase;
import amerifrance.guideapi.gui.GuiCategory;
import amerifrance.guideapi.network.PacketHandler;
import amerifrance.guideapi.network.PacketSyncEntry;
import amerifrance.guideapi.wrappers.PageWrapper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public class GuiEntry
extends GuiBase {
    public ResourceLocation outlineTexture;
    public ResourceLocation pageTexture;
    public Book book;
    public CategoryAbstract category;
    public EntryAbstract entry;
    public List<PageWrapper> pageWrapperList = new ArrayList<PageWrapper>();
    public ButtonBack buttonBack;
    public ButtonNext buttonNext;
    public ButtonPrev buttonPrev;
    public int pageNumber;

    public GuiEntry(Book book, CategoryAbstract category, EntryAbstract entry, EntityPlayer player, ItemStack bookStack) {
        super(player, bookStack);
        this.book = book;
        this.category = category;
        this.entry = entry;
        this.pageTexture = book.pageTexture;
        this.outlineTexture = book.outlineTexture;
        this.pageNumber = 0;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.pageWrapperList.clear();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.buttonBack = new ButtonBack(0, this.guiLeft + this.xSize / 6, this.guiTop, this);
        this.field_146292_n.add(this.buttonBack);
        this.buttonNext = new ButtonNext(1, this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, this);
        this.field_146292_n.add(this.buttonNext);
        this.buttonPrev = new ButtonPrev(2, this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, this);
        this.field_146292_n.add(this.buttonPrev);
        for (IPage page : this.entry.pageList) {
            page.onInit(this.book, this.category, this.entry, this.player, this.bookStack, this);
            this.pageWrapperList.add(new PageWrapper(this, this.book, this.category, this.entry, page, this.guiLeft, this.guiTop, this.player, this.field_146289_q, this.bookStack));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float renderPartialTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.pageTexture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.outlineTexture);
        this.drawTexturedModalRectWithColor(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize, this.book.bookColor);
        if (this.pageNumber < this.pageWrapperList.size() && this.pageWrapperList.get(this.pageNumber).canPlayerSee()) {
            this.pageWrapperList.get(this.pageNumber).draw(mouseX, mouseY, this);
            this.pageWrapperList.get(this.pageNumber).drawExtras(mouseX, mouseY, this);
        }
        this.func_73732_a(this.field_146289_q, String.valueOf(this.pageNumber + 1) + "/" + String.valueOf(this.pageWrapperList.size()), this.guiLeft + this.xSize / 2, this.guiTop + 5 * this.ySize / 6, 0);
        this.drawCenteredStringWithShadow(this.field_146289_q, this.entry.getLocalizedName(), this.guiLeft + this.xSize / 2, this.guiTop - 10, Color.WHITE.getRGB());
        this.buttonPrev.field_146125_m = this.pageNumber != 0;
        this.buttonNext.field_146125_m = this.pageNumber != this.pageWrapperList.size() - 1;
        super.func_73863_a(mouseX, mouseY, renderPartialTicks);
    }

    public void func_73864_a(int mouseX, int mouseY, int typeofClick) {
        super.func_73864_a(mouseX, mouseY, typeofClick);
        for (PageWrapper wrapper : this.pageWrapperList) {
            if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
            if (typeofClick == 0) {
                this.pageWrapperList.get((int)this.pageNumber).page.onLeftClicked(this.book, this.category, this.entry, mouseX, mouseY, this.player, this);
            }
            if (typeofClick != 1) continue;
            this.pageWrapperList.get((int)this.pageNumber).page.onRightClicked(this.book, this.category, this.entry, mouseX, mouseY, this.player, this);
        }
        if (typeofClick == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiCategory(this.book, this.category, this.player, this.bookStack));
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int movement = Mouse.getEventDWheel();
        if (movement < 0) {
            this.nextPage();
        } else if (movement > 0) {
            this.prevPage();
        }
    }

    @Override
    public void func_73869_a(char typedChar, int keyCode) {
        super.func_73869_a(typedChar, keyCode);
        if (keyCode == 14 || keyCode == this.field_146297_k.field_71474_y.field_74313_G.func_151463_i()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiCategory(this.book, this.category, this.player, this.bookStack));
        }
        if ((keyCode == 200 || keyCode == 205) && this.pageNumber + 1 < this.pageWrapperList.size()) {
            this.nextPage();
        }
        if ((keyCode == 208 || keyCode == 203) && this.pageNumber > 0) {
            this.prevPage();
        }
    }

    public void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiCategory(this.book, this.category, this.player, this.bookStack));
        } else if (button.field_146127_k == 1 && this.pageNumber + 1 < this.pageWrapperList.size()) {
            this.nextPage();
        } else if (button.field_146127_k == 2 && this.pageNumber > 0) {
            this.prevPage();
        }
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSyncEntry(this.book.categoryList.indexOf(this.category), this.category.entryList.indexOf(this.entry), this.pageNumber));
    }

    public void nextPage() {
        if (this.pageNumber != this.pageWrapperList.size() - 1) {
            ++this.pageNumber;
        }
    }

    public void prevPage() {
        if (this.pageNumber != 0) {
            --this.pageNumber;
        }
    }
}

