/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.directionhud;

import net.minecraftforge.common.config.Property;

public enum ConfigElement {
    ENABLED("enabled", "bspkrs.dh.configgui.enabled", "Enables or disables the compass HUD display.", Property.Type.BOOLEAN),
    ALIGN_MODE("alignMode", "bspkrs.dh.configgui.alignMode", "Sets the position of the HUD on the screen. Valid alignment strings are topleft, topcenter, topright, middleleft, middlecenter, middleright, bottomleft, bottomcenter, bottomright", Property.Type.STRING, new String[]{"topleft", "topcenter", "topright", "middleleft", "middlecenter", "middleright", "bottomleft", "bottomcenter", "bottomright"}),
    MARKER_COLOR("markerColor", "bspkrs.dh.configgui.markerColor", "Valid color values are 0-9, a-f (color values can be found here: http://www.minecraftwiki.net/wiki/File:Colors.png)", Property.Type.COLOR, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"}),
    COMPASS_INDEX("compassIndex", "bspkrs.dh.configgui.compassIndex", "Index of the selected compass in the compass image file starting at 0. Up to 10 compasses can fit in the image (10 would be index 9). Each compass is 24 pixels tall (two lines of height 12).", Property.Type.INTEGER),
    X_OFFSET("xOffset", "bspkrs.dh.configgui.xOffset", "Horizontal offset from the edge of the screen (when using right alignments the x offset is relative to the right edge of the screen)", Property.Type.INTEGER),
    Y_OFFSET("yOffset", "bspkrs.dh.configgui.yOffset", "Vertical offset from the edge of the screen (when using bottom alignments the y offset is relative to the bottom edge of the screen)", Property.Type.INTEGER),
    Y_OFFSET_BOTTOM_CENTER("yOffsetBottomCenter", "bspkrs.dh.configgui.yOffsetBottomCenter", "Vertical offset used only for the bottomcenter alignment to avoid the vanilla HUD", Property.Type.INTEGER),
    APPLY_X_OFFSET_TO_CENTER("applyXOffsetToCenter", "bspkrs.dh.configgui.applyXOffsetToCenter", "Set to true if you want the xOffset value to be applied when using a center alignment", Property.Type.BOOLEAN),
    APPLY_Y_OFFSET_TO_MIDDLE("applyYOffsetToMiddle", "bspkrs.dh.configgui.applyYOffsetToMiddle", "Set to true if you want the yOffset value to be applied when using a middle alignment", Property.Type.BOOLEAN),
    SHOW_IN_CHAT("showInChat", "bspkrs.dh.configgui.showInChat", "Set to true to show info when chat is open, false to disable info when chat is open", Property.Type.BOOLEAN);

    private String key;
    private String langKey;
    private String desc;
    private Property.Type propertyType;
    private String[] validStrings;

    private ConfigElement(String key, String langKey, String desc, Property.Type propertyType, String[] validStrings) {
        this.key = key;
        this.langKey = langKey;
        this.desc = desc;
        this.propertyType = propertyType;
        this.validStrings = validStrings;
    }

    private ConfigElement(String key, String langKey, String desc, Property.Type propertyType) {
        this(key, langKey, desc, propertyType, new String[0]);
    }

    public String key() {
        return this.key;
    }

    public String languageKey() {
        return this.langKey;
    }

    public String desc() {
        return this.desc;
    }

    public Property.Type propertyType() {
        return this.propertyType;
    }

    public String[] validStrings() {
        return this.validStrings;
    }
}

