/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tweaker;

import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorParadigm;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorRegistry;
import WayofTime.alchemicalWizardry.common.tweaker.MTHelper;
import java.util.Iterator;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bloodmagic.FallingTower")
public class FallingTower {
    @ZenMethod
    public static void addFocus(IItemStack stack, int radius, String[] components) {
        MineTweakerAPI.apply((IUndoableAction)new Add(MTHelper.toStack(stack), radius, components));
    }

    @ZenMethod
    public static void addFocus(IItemStack stack, int radius, String components) {
        MineTweakerAPI.apply((IUndoableAction)new Add(MTHelper.toStack(stack), radius, components.split("\\s*,\\s*")));
    }

    @ZenMethod
    public static void removeFocus(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(MTHelper.toStack(output)));
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack focus;
        private MeteorParadigm paradigm;

        public Remove(ItemStack focus) {
            this.focus = focus;
        }

        public void apply() {
            Iterator<MeteorParadigm> itr = MeteorRegistry.paradigmList.iterator();
            while (itr.hasNext()) {
                MeteorParadigm paradigm = itr.next();
                if (!OreDictionary.itemMatches((ItemStack)paradigm.focusStack, (ItemStack)this.focus, (boolean)false)) continue;
                this.paradigm = paradigm;
                itr.remove();
                break;
            }
        }

        public boolean canUndo() {
            return MeteorRegistry.paradigmList != null && this.paradigm != null;
        }

        public void undo() {
            MeteorRegistry.paradigmList.add(this.paradigm);
        }

        public String describe() {
            return "Removing Falling Tower Focus for " + this.focus.func_82833_r();
        }

        public String describeUndo() {
            return "Restoring Falling Tower Focus for " + this.focus.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        private MeteorParadigm paradigm;

        public Add(ItemStack stack, int radius, String[] components) {
            this.paradigm = new MeteorParadigm(stack, radius);
            this.paradigm.parseStringArray(components);
        }

        public void apply() {
            MeteorRegistry.registerMeteorParadigm(this.paradigm);
        }

        public boolean canUndo() {
            return MeteorRegistry.paradigmList != null;
        }

        public void undo() {
            MeteorRegistry.paradigmList.remove(this.paradigm);
        }

        public String describe() {
            return "Adding Falling Tower Focus for " + this.paradigm.focusStack.func_82833_r();
        }

        public String describeUndo() {
            return "Removing Falling Tower Focus for " + this.paradigm.focusStack.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

