/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.weather;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.gui.GuiPoweredMachineBase;
import crazypants.enderio.machine.obelisk.weather.ContainerWeatherObelisk;
import crazypants.enderio.machine.obelisk.weather.PacketActivateWeather;
import crazypants.enderio.machine.obelisk.weather.TileWeatherObelisk;
import crazypants.enderio.network.PacketHandler;
import java.awt.Color;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class GuiWeatherObelisk
extends GuiPoweredMachineBase<TileWeatherObelisk> {
    private static final NumberFormat fmt = NumberFormat.getNumberInstance();

    public GuiWeatherObelisk(InventoryPlayer inventory, TileWeatherObelisk tileEntity) {
        super(tileEntity, (Container)new ContainerWeatherObelisk(inventory, tileEntity), "weatherObelisk");
        this.addProgressTooltip(79, 29, 18, 31);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.field_146999_f / 2 - 8;
        int y = 8;
        this.addButton(new IconButton((IGuiScreen)this, 0, x - 30, y, (IWidgetIcon)IconEIO.SUN), TileWeatherObelisk.WeatherTask.CLEAR);
        this.addButton(new IconButton((IGuiScreen)this, 1, x, y, (IWidgetIcon)IconEIO.RAIN), TileWeatherObelisk.WeatherTask.RAIN);
        this.addButton(new IconButton((IGuiScreen)this, 2, x + 30, y, (IWidgetIcon)IconEIO.THUNDER), TileWeatherObelisk.WeatherTask.STORM);
        this.refreshButtons();
    }

    private void addButton(IconButton button, TileWeatherObelisk.WeatherTask task) {
        String tt1 = EnumChatFormatting.WHITE + EnderIO.lang.localize("gui.weather.task." + task.name().toLowerCase(Locale.US));
        String tt2 = EnumChatFormatting.AQUA + String.format(EnderIO.lang.localize("gui.weather.requireditem"), EnumChatFormatting.WHITE + task.requiredItem().func_82833_r());
        String tt3 = String.format("%s%s %s%s", EnumChatFormatting.GREEN, fmt.format(task.power), EnumChatFormatting.WHITE, EnderIO.lang.localize("power.rf"));
        button.setToolTip(new String[]{tt1, tt2, tt3});
        button.onGuiInit();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (((TileWeatherObelisk)this.getTileEntity()).func_145831_w().func_82737_E() % 20L == 0L) {
            this.refreshButtons();
        }
    }

    private void refreshButtons() {
        for (GuiButton button : this.field_146292_n) {
            TileWeatherObelisk.WeatherTask[] tasks = TileWeatherObelisk.WeatherTask.values();
            if (button.field_146127_k < 0 || button.field_146127_k >= tasks.length) continue;
            TileWeatherObelisk.WeatherTask task = TileWeatherObelisk.WeatherTask.values()[button.field_146127_k];
            if (TileWeatherObelisk.WeatherTask.worldIsState(task, ((TileWeatherObelisk)this.getTileEntity()).func_145831_w().func_72912_H())) {
                button.field_146124_l = false;
                continue;
            }
            button.field_146124_l = true;
        }
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        this.bindGuiTexture();
        this.func_73729_b(this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        if (this.shouldRenderProgress() && ((TileWeatherObelisk)this.getTileEntity()).activeTask != null) {
            int barHeight = this.getProgressScaled(31);
            Color color = ((TileWeatherObelisk)this.getTileEntity()).activeTask.color;
            GL11.glColor3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
            this.func_73729_b(this.getGuiLeft() + 81, this.getGuiTop() + 58 - barHeight, this.getXSize(), 32 - barHeight, 12, barHeight);
        }
        super.func_146976_a(par1, par2, par3);
    }

    @Override
    protected int getPowerHeight() {
        return super.getPowerHeight() + 20;
    }

    @Override
    protected int getPowerU() {
        return super.getPowerU();
    }

    @Override
    protected int getPowerV() {
        return 34;
    }

    @Override
    protected int getPowerX() {
        return super.getPowerX();
    }

    @Override
    protected int getPowerY() {
        return super.getPowerY();
    }

    protected void func_146284_a(GuiButton b) {
        super.func_146284_a(b);
        if (b.field_146127_k >= 0 && b.field_146127_k <= 2) {
            ((TileWeatherObelisk)this.getTileEntity()).startTask(b.field_146127_k);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketActivateWeather((TileWeatherObelisk)this.getTileEntity(), TileWeatherObelisk.WeatherTask.values()[b.field_146127_k]));
        }
    }
}

