/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk;

import com.enderio.core.client.render.RenderUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.obelisk.ObeliskRenderer;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Timer;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ObeliskSpecialRenderer<T extends TileEntity>
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private ItemStack floatingStack;
    private Random rand = new Random();
    private ObeliskRenderer blockRen;
    private EntityItem ei = null;

    public ObeliskSpecialRenderer(ItemStack itemStack, ObeliskRenderer renderer) {
        this.floatingStack = itemStack;
        this.blockRen = renderer;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        switch (type) {
            case ENTITY: {
                GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
                break;
            }
            case EQUIPPED: {
                GL11.glRotatef((float)22.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.3f, (float)-0.4f, (float)-0.4f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                GL11.glTranslatef((float)0.75f, (float)0.0f, (float)0.0f);
                break;
            }
            case INVENTORY: {
                GL11.glTranslatef((float)8.0f, (float)9.0f, (float)0.0f);
                GL11.glScalef((float)12.0f, (float)12.0f, (float)12.0f);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
                GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
        this.blockRen.renderInventoryBlock(Block.func_149634_a((Item)item.func_77973_b()), item.func_77960_j(), 0, (RenderBlocks)data[0]);
        Timer t = RenderUtil.getTimer();
        this.renderItemStack(null, (World)Minecraft.func_71410_x().field_71441_e, 0.0, 0.0, 0.0, t == null ? 0.0f : t.field_74281_c);
        GL11.glPopMatrix();
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float tick) {
        World world = te.func_145831_w();
        float f = world.func_72957_l(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        int l = world.func_72802_i(te.field_145851_c, te.field_145848_d, te.field_145849_e, 0);
        int l1 = l % 65536;
        int l2 = l / 65536;
        Tessellator.field_78398_a.func_78386_a(f, f, f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)l1, (float)l2);
        this.renderItemStack(te, world, x, y, z, tick);
    }

    private void renderItemStack(T te, World world, double x, double y, double z, float tick) {
        if (this.ei == null) {
            this.ei = new EntityItem(world, 0.0, 0.0, 0.0, this.getFloatingItem(te));
        }
        this.ei.func_92058_a(this.getFloatingItem(te));
        this.ei.field_70290_d = (float)((double)((float)EnderIO.proxy.getTickCount() * 0.05f + tick * 0.05f) % (Math.PI * 2));
        this.ei.field_70292_b = 0;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        RenderHelper.func_74519_b();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.7), (double)(z + 0.5));
        GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
        GL11.glDepthMask((boolean)true);
        if (te != null) {
            this.rand.setSeed(((TileEntity)te).field_145851_c + ((TileEntity)te).field_145848_d + ((TileEntity)te).field_145849_e);
            this.rand.nextBoolean();
            if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
                GL11.glRotatef((float)(this.rand.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            this.ei.field_70290_d += this.rand.nextFloat();
        }
        RenderManager.field_78727_a.func_147940_a((Entity)this.ei, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    protected ItemStack getFloatingItem(T te) {
        return this.floatingStack;
    }
}

