/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class PoweredItemRenderer
implements IItemRenderer {
    private RenderItem ri = new RenderItem();

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.INVENTORY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (data != null && data.length > 0) {
            this.renderToInventory(item, (RenderBlocks)data[0]);
        }
    }

    public void renderToInventory(ItemStack item, RenderBlocks renderBlocks) {
        Minecraft mc = Minecraft.func_71410_x();
        this.ri.renderItemIntoGUI(mc.field_71466_p, mc.func_110434_K(), item, 0, 0, true);
        GL11.glDisable((int)2896);
        if (this.isJustCrafted(item)) {
            return;
        }
        boolean hasEnergyUpgrade = EnergyUpgrade.loadFromItem(item) != null;
        int y = hasEnergyUpgrade ? 12 : 13;
        int bgH = hasEnergyUpgrade ? 4 : 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.renderQuad2D((double)2.0, (double)y, (double)0.0, (double)13.0, (double)bgH, (int)ColorUtil.getRGB((Color)Color.black));
        double maxDam = item.func_77958_k();
        double dispDamage = item.func_77952_i();
        y = hasEnergyUpgrade ? 14 : 13;
        this.renderBar(y, maxDam, dispDamage, Color.green, Color.red);
        if (hasEnergyUpgrade) {
            IEnergyContainerItem armor = (IEnergyContainerItem)item.func_77973_b();
            maxDam = armor.getMaxEnergyStored(item);
            dispDamage = armor.getEnergyStored(item);
            y = 12;
            Color color = new Color(45, 206, 250);
            this.renderBar2(y, maxDam, maxDam - dispDamage, color, color);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2896);
    }

    private boolean isJustCrafted(ItemStack item) {
        return EnergyUpgrade.loadFromItem(item) == null && item.func_77952_i() == 0;
    }

    private void renderBar2(int y, double maxDam, double dispDamage, Color full, Color empty) {
        double ratio = dispDamage / maxDam;
        Vector4f fg = ColorUtil.toFloat((Color)full);
        Vector4f ec = ColorUtil.toFloat((Color)empty);
        fg.interpolate(ec, (float)ratio);
        Vector4f bg = ColorUtil.toFloat((Color)Color.black);
        bg.interpolate(fg, 0.15f);
        int barLength = (int)Math.round(12.0 * (1.0 - ratio));
        RenderUtil.renderQuad2D((double)2.0, (double)y, (double)0.0, (double)12.0, (double)1.0, (Vector4f)bg);
        RenderUtil.renderQuad2D((double)2.0, (double)y, (double)0.0, (double)barLength, (double)1.0, (Vector4f)fg);
    }

    private void renderBar(int y, double maxDam, double dispDamage, Color full, Color empty) {
        double ratio = dispDamage / maxDam;
        Vector4f fg = ColorUtil.toFloat((Color)full);
        Vector4f ec = ColorUtil.toFloat((Color)empty);
        fg.interpolate(ec, (float)ratio);
        Vector4f bg = new Vector4f(0.17, 0.3, 0.1, 0.0);
        int barLength = (int)Math.round(12.0 * (1.0 - ratio));
        RenderUtil.renderQuad2D((double)2.0, (double)y, (double)0.0, (double)12.0, (double)1.0, (Vector4f)bg);
        RenderUtil.renderQuad2D((double)2.0, (double)y, (double)0.0, (double)barLength, (double)1.0, (Vector4f)fg);
    }

    private void renderBar(int y, double maxDam, double dispDamage) {
        int ratio = (int)Math.round(255.0 - dispDamage * 255.0 / maxDam);
        int fgCol = 255 - ratio << 16 | ratio << 8;
        int bgCol = (255 - ratio) / 4 << 16 | 0x3F00;
        int barLength = (int)Math.round(12.0 - dispDamage * 12.0 / maxDam);
        RenderUtil.renderQuad2D((double)2.0, (double)y, (double)0.0, (double)12.0, (double)1.0, (int)bgCol);
        RenderUtil.renderQuad2D((double)2.0, (double)y, (double)0.0, (double)barLength, (double)1.0, (int)fgCol);
    }
}

