/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.VecmathUtil;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4d;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.ItemDarkSteelArmor;
import crazypants.enderio.item.darksteel.ItemDarkSteelSword;
import crazypants.enderio.item.darksteel.PacketDarkSteelPowerPacket;
import crazypants.enderio.item.darksteel.PacketUpgradeState;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.item.darksteel.upgrade.GliderUpgrade;
import crazypants.enderio.item.darksteel.upgrade.IDarkSteelUpgrade;
import crazypants.enderio.item.darksteel.upgrade.IRenderUpgrade;
import crazypants.enderio.item.darksteel.upgrade.JumpUpgrade;
import crazypants.enderio.item.darksteel.upgrade.NightVisionUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SolarUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SpeedUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SwimUpgrade;
import crazypants.enderio.machine.solar.TileEntitySolarPanel;
import crazypants.enderio.network.PacketHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityReddustFX;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovementInput;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.lwjgl.opengl.GL11;

public class DarkSteelController {
    public static final DarkSteelController instance = new DarkSteelController();
    private final AttributeModifier[] walkModifiers = new AttributeModifier[]{new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.WALK_MULTIPLIERS[0], 1), new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.WALK_MULTIPLIERS[1], 1), new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.WALK_MULTIPLIERS[2], 1)};
    private final AttributeModifier[] sprintModifiers = new AttributeModifier[]{new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.SPRINT_MULTIPLIERS[0], 1), new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.SPRINT_MULTIPLIERS[1], 1), new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.SPRINT_MULTIPLIERS[2], 1)};
    private final AttributeModifier swordDamageModifierPowered = new AttributeModifier(new UUID(63242325L, 320981923L), "Weapon modifier", 2.0, 0);
    private boolean wasJumping;
    private int jumpCount;
    private int ticksSinceLastJump;
    private static final EnumSet<PacketUpgradeState.Type> DEFAULT_ACTIVE = EnumSet.of(PacketUpgradeState.Type.SPEED, PacketUpgradeState.Type.STEP_ASSIST, PacketUpgradeState.Type.JUMP);
    private final Map<UUID, EnumSet<PacketUpgradeState.Type>> allActive = new HashMap<UUID, EnumSet<PacketUpgradeState.Type>>();
    private boolean nightVisionActive = false;
    private boolean removeNightvision = false;

    private DarkSteelController() {
        PacketHandler.INSTANCE.registerMessage(PacketDarkSteelPowerPacket.class, PacketDarkSteelPowerPacket.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketUpgradeState.class, PacketUpgradeState.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketUpgradeState.class, PacketUpgradeState.class, PacketHandler.nextID(), Side.CLIENT);
    }

    private EnumSet<PacketUpgradeState.Type> getActiveSet(EntityPlayer player) {
        Object active;
        GameProfile gameProfile = player.func_146103_bH();
        UUID id = gameProfile == null ? null : gameProfile.getId();
        Object object = active = id == null ? null : this.allActive.get(id);
        if (active == null) {
            active = DEFAULT_ACTIVE.clone();
            if (id != null) {
                this.allActive.put(id, (EnumSet<PacketUpgradeState.Type>)active);
            }
        }
        return active;
    }

    public boolean isActive(EntityPlayer player, PacketUpgradeState.Type type) {
        return this.getActiveSet(player).contains((Object)type);
    }

    public void setActive(EntityPlayer player, PacketUpgradeState.Type type, boolean isActive) {
        EnumSet<PacketUpgradeState.Type> set = this.getActiveSet(player);
        if (isActive) {
            set.add(type);
        } else {
            set.remove((Object)type);
        }
    }

    public boolean isGlideActive(EntityPlayer player) {
        return this.isActive(player, PacketUpgradeState.Type.GLIDE);
    }

    public boolean isSpeedActive(EntityPlayer player) {
        return this.isActive(player, PacketUpgradeState.Type.SPEED);
    }

    public boolean isStepAssistActive(EntityPlayer player) {
        return this.isActive(player, PacketUpgradeState.Type.STEP_ASSIST);
    }

    public boolean isJumpActive(EntityPlayer player) {
        return this.isActive(player, PacketUpgradeState.Type.JUMP);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (event.phase == TickEvent.Phase.START) {
            this.updateStepHeightAndFallDistance(player);
            this.updateSpeed(player);
            this.updateSword(player);
            this.updateGlide(player);
            this.updateSwim(player);
            this.updateSolar(player);
        }
    }

    private void updateSolar(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack helm = player.func_71124_b(4);
        SolarUpgrade upgrade = SolarUpgrade.loadFromItem(helm);
        if (upgrade == null) {
            return;
        }
        int RFperSecond = Math.round((float)upgrade.getRFPerSec() * TileEntitySolarPanel.calculateLightRatio(player.field_70170_p, MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)(player.field_70163_u + 1.0)), MathHelper.func_76128_c((double)player.field_70161_v)));
        int leftover = RFperSecond % 20;
        boolean addExtraRF = player.field_70170_p.func_82737_E() % 20L < (long)leftover;
        int toAdd = RFperSecond / 20 + (addExtraRF ? 1 : 0);
        if (toAdd != 0) {
            int nextIndex = player.getEntityData().func_74762_e("dsarmor:solar") % 4;
            for (int i = 0; i < 4 && toAdd > 0; ++i) {
                ItemStack stack = player.field_71071_by.field_70460_b[nextIndex];
                if (stack != null && (EnergyUpgrade.loadFromItem(stack) != null || Config.darkSteelSolarChargeOthers && stack.func_77973_b() instanceof IEnergyContainerItem)) {
                    toAdd -= ((IEnergyContainerItem)stack.func_77973_b()).receiveEnergy(stack, toAdd, false);
                }
                nextIndex = (nextIndex + 1) % 4;
            }
            player.getEntityData().func_74768_a("dsarmor:solar", nextIndex);
        }
    }

    private void updateSwim(EntityPlayer player) {
        ItemStack boots = player.func_71124_b(1);
        SwimUpgrade upgrade = SwimUpgrade.loadFromItem(boots);
        if (upgrade == null) {
            return;
        }
        if (player.func_70090_H()) {
            player.field_70159_w *= 1.1;
            player.field_70179_y *= 1.1;
        }
    }

    private void updateGlide(EntityPlayer player) {
        if (!this.isGlideActive(player) || !this.isGliderUpgradeEquipped(player)) {
            return;
        }
        if (!player.field_70122_E && player.field_70181_x < 0.0 && !player.func_70093_af() && !player.func_70090_H()) {
            double horizontalSpeed = Config.darkSteelGliderHorizontalSpeed;
            double verticalSpeed = Config.darkSteelGliderVerticalSpeed;
            if (player.func_70051_ag()) {
                verticalSpeed = Config.darkSteelGliderVerticalSpeedSprinting;
            }
            Vector3d look = Util.getLookVecEio((EntityPlayer)player);
            Vector3d side = new Vector3d();
            side.cross(new Vector3d(0.0, 1.0, 0.0), look);
            Vector3d playerPos = new Vector3d(player.field_70169_q, player.field_70167_r, player.field_70166_s);
            Vector3d b = new Vector3d(playerPos);
            b.y += 1.0;
            Vector3d c = new Vector3d(playerPos);
            c.add(side);
            Vector4d plane = new Vector4d();
            VecmathUtil.computePlaneEquation((Vector3d)playerPos, (Vector3d)b, (Vector3d)c, (Vector4d)plane);
            double dist = Math.abs(VecmathUtil.distanceFromPointToPlane((Vector4d)plane, (Vector3d)new Vector3d(player.field_70165_t, player.field_70163_u, player.field_70161_v)));
            double minDist = 0.15;
            if (dist < minDist) {
                double dropRate = minDist * 10.0 - dist * 10.0;
                verticalSpeed += verticalSpeed * dropRate * 8.0;
                horizontalSpeed -= 0.02 * dropRate;
            }
            double x = Math.cos(Math.toRadians(player.field_70759_as + 90.0f)) * horizontalSpeed;
            double z = Math.sin(Math.toRadians(player.field_70759_as + 90.0f)) * horizontalSpeed;
            player.field_70159_w += x;
            player.field_70179_y += z;
            player.field_70181_x = verticalSpeed;
            player.field_70143_R = 0.0f;
        }
    }

    public boolean isGliderUpgradeEquipped(EntityPlayer player) {
        ItemStack chestPlate = player.func_71124_b(3);
        GliderUpgrade glideUpgrade = GliderUpgrade.loadFromItem(chestPlate);
        return glideUpgrade != null;
    }

    private void updateSword(EntityPlayer player) {
        if (ItemDarkSteelSword.isEquipped(player)) {
            IAttributeInstance attackInst = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e);
            attackInst.func_111124_b(this.swordDamageModifierPowered);
            ItemStack sword = player.func_71045_bC();
            if (Config.darkSteelSwordPowerUsePerHit <= 0 || EnergyUpgrade.getEnergyStored(sword) >= Config.darkSteelSwordPowerUsePerHit) {
                attackInst.func_111121_a(this.swordDamageModifierPowered);
            }
        }
    }

    private void updateSpeed(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K || !player.field_70122_E) {
            return;
        }
        IAttributeInstance moveInst = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
        if (moveInst.func_111127_a(this.walkModifiers[0].func_111167_a()) != null) {
            moveInst.func_111124_b(this.walkModifiers[0]);
        } else if (moveInst.func_111127_a(this.sprintModifiers[0].func_111167_a()) != null) {
            moveInst.func_111124_b(this.sprintModifiers[0]);
        }
        ItemStack leggings = player.func_71124_b(2);
        SpeedUpgrade speedUpgrade = SpeedUpgrade.loadFromItem(leggings);
        if (leggings != null && leggings.func_77973_b() == DarkSteelItems.itemDarkSteelLeggings && speedUpgrade != null && this.isSpeedActive(player)) {
            double horzMovement = Math.abs(player.field_70140_Q - player.field_70141_P);
            double costModifier = player.func_70051_ag() ? (double)Config.darkSteelSprintPowerCost : (double)Config.darkSteelWalkPowerCost;
            costModifier += costModifier * (double)speedUpgrade.getWalkMultiplier();
            int cost = (int)(horzMovement * costModifier);
            int totalEnergy = this.getPlayerEnergy(player, DarkSteelItems.itemDarkSteelLeggings);
            if (totalEnergy > 0) {
                this.usePlayerEnergy(player, DarkSteelItems.itemDarkSteelLeggings, cost);
                if (player.func_70051_ag()) {
                    moveInst.func_111121_a(this.sprintModifiers[speedUpgrade.getLevel() - 1]);
                } else {
                    moveInst.func_111121_a(this.walkModifiers[speedUpgrade.getLevel() - 1]);
                }
            }
        }
    }

    private void updateStepHeightAndFallDistance(EntityPlayer player) {
        JumpUpgrade jumpUpgrade;
        int costedDistance;
        ItemStack boots = player.func_71124_b(1);
        if (boots != null && boots.func_77973_b() == DarkSteelItems.itemDarkSteelBoots && !player.field_71075_bZ.field_75101_c && (costedDistance = (int)player.field_70143_R) > 0) {
            int energyCost = costedDistance * Config.darkSteelFallDistanceCost;
            int totalEnergy = this.getPlayerEnergy(player, DarkSteelItems.itemDarkSteelBoots);
            if (totalEnergy > 0 && totalEnergy >= energyCost) {
                this.usePlayerEnergy(player, DarkSteelItems.itemDarkSteelBoots, energyCost);
                player.field_70143_R -= (float)costedDistance;
            }
        }
        if ((jumpUpgrade = JumpUpgrade.loadFromItem(boots)) != null && boots != null && boots.func_77973_b() == DarkSteelItems.itemDarkSteelBoots && this.isStepAssistActive(player)) {
            player.field_70138_W = 1.0023f;
        } else if (player.field_70138_W == 1.0023f) {
            player.field_70138_W = 0.5001f;
        }
    }

    void usePlayerEnergy(EntityPlayer player, ItemDarkSteelArmor armor, int cost) {
        ItemStack stack;
        if (cost == 0) {
            return;
        }
        int remaining = cost;
        if (Config.darkSteelDrainPowerFromInventory) {
            for (ItemStack stack2 : player.field_71071_by.field_70462_a) {
                IEnergyContainerItem cont;
                int used;
                if (stack2 == null || !(stack2.func_77973_b() instanceof IEnergyContainerItem) || (remaining -= (used = (cont = (IEnergyContainerItem)stack2.func_77973_b()).extractEnergy(stack2, remaining, false))) > 0) continue;
                return;
            }
        }
        if (armor != null && remaining > 0 && (stack = player.field_71071_by.field_70460_b[3 - armor.field_77881_a]) != null) {
            armor.extractEnergy(stack, remaining, false);
        }
    }

    private int getPlayerEnergy(EntityPlayer player, ItemDarkSteelArmor armor) {
        int res = 0;
        if (Config.darkSteelDrainPowerFromInventory) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (stack == null || !(stack.func_77973_b() instanceof IEnergyContainerItem)) continue;
                IEnergyContainerItem cont = (IEnergyContainerItem)stack.func_77973_b();
                res += cont.extractEnergy(stack, Integer.MAX_VALUE, true);
            }
        }
        if (armor != null) {
            ItemStack stack = player.field_71071_by.field_70460_b[3 - armor.field_77881_a];
            res = armor.getEnergyStored(stack);
        }
        return res;
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.target instanceof EntityPlayerMP) {
            for (PacketUpgradeState.Type type : PacketUpgradeState.Type.values()) {
                PacketHandler.sendTo(new PacketUpgradeState(type, this.isActive((EntityPlayer)event.target, type), event.target.func_145782_y()), (EntityPlayerMP)event.entityPlayer);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            this.updateNightvision((EntityPlayer)player);
            if (player.field_71075_bZ.field_75100_b) {
                return;
            }
            MovementInput input = player.field_71158_b;
            if (input.field_78901_c && !this.wasJumping) {
                this.doJump(player);
            } else if (input.field_78901_c && this.jumpCount < 3 && this.ticksSinceLastJump > 5) {
                this.doJump(player);
            }
            boolean bl = this.wasJumping = !player.field_70122_E;
            if (!this.wasJumping) {
                this.jumpCount = 0;
            }
            ++this.ticksSinceLastJump;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerRender(RenderPlayerEvent.Specials.Post event) {
        if (event.entityLiving.func_70660_b(Potion.field_76441_p) != null) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        ItemStack[] armors = player.field_71071_by.field_70460_b;
        this.dispatchRenders(armors, (RenderPlayerEvent)event, false);
        float yaw = player.field_70758_at + (player.field_70759_as - player.field_70758_at) * event.partialRenderTick;
        float yawOffset = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * event.partialRenderTick;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * event.partialRenderTick;
        GL11.glPushMatrix();
        if (player.func_70093_af()) {
            GL11.glTranslatef((float)0.0f, (float)0.0625f, (float)0.0f);
        }
        GL11.glRotatef((float)yawOffset, (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glRotatef((float)(yaw - 270.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        this.dispatchRenders(armors, (RenderPlayerEvent)event, true);
        GL11.glPopMatrix();
    }

    private void dispatchRenders(ItemStack[] armors, RenderPlayerEvent event, boolean head) {
        for (int i = 0; i < armors.length; ++i) {
            Item item;
            ItemStack stack = armors[i];
            if (stack == null || !((item = stack.func_77973_b()) instanceof IDarkSteelItem)) continue;
            for (IDarkSteelUpgrade upg : DarkSteelRecipeManager.instance.getUpgrades()) {
                if (!upg.hasUpgrade(stack)) continue;
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                IRenderUpgrade render = upg.getRender();
                if (render != null) {
                    upg.getRender().render(event, stack, head);
                }
                GL11.glPopMatrix();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doJump(EntityClientPlayerMP player) {
        if (!this.isJumpActive((EntityPlayer)player)) {
            return;
        }
        ItemStack boots = player.func_71124_b(1);
        JumpUpgrade jumpUpgrade = JumpUpgrade.loadFromItem(boots);
        if (jumpUpgrade == null || boots == null || boots.func_77973_b() != DarkSteelItems.itemDarkSteelBoots) {
            return;
        }
        int requiredPower = Config.darkSteelBootsJumpPowerCost * (int)Math.pow(this.jumpCount + 1, 2.5);
        int availablePower = this.getPlayerEnergy((EntityPlayer)player, DarkSteelItems.itemDarkSteelBoots);
        if (availablePower > 0 && requiredPower <= availablePower && this.jumpCount < jumpUpgrade.getLevel()) {
            ++this.jumpCount;
            player.field_70181_x += 0.15 * Config.darkSteelBootsJumpModifier * (double)this.jumpCount;
            this.ticksSinceLastJump = 0;
            this.usePlayerEnergy((EntityPlayer)player, DarkSteelItems.itemDarkSteelBoots, requiredPower);
            player.field_70170_p.func_72980_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, "EnderIO:ds.jump", 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.5f + 0.75f, false);
            Random rand = player.field_70170_p.field_73012_v;
            for (int i = rand.nextInt(10) + 5; i >= 0; --i) {
                EntityReddustFX fx = new EntityReddustFX(player.field_70170_p, player.field_70165_t + (rand.nextDouble() * 0.5 - 0.25), player.field_70163_u - (double)player.field_70129_M, player.field_70161_v + (rand.nextDouble() * 0.5 - 0.25), 1.0f, 1.0f, 1.0f);
                fx.func_70016_h(player.field_70159_w + (rand.nextDouble() * 0.5 - 0.25), player.field_70181_x / 2.0 + rand.nextDouble() * -0.05, player.field_70179_y + (rand.nextDouble() * 0.5 - 0.25));
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketDarkSteelPowerPacket(requiredPower, DarkSteelItems.itemDarkSteelBoots.field_77881_a));
        }
    }

    private void updateNightvision(EntityPlayer player) {
        if (this.isNightVisionUpgradeEquipped(player) && this.nightVisionActive) {
            player.func_70690_d(new PotionEffect(Potion.field_76439_r.func_76396_c(), 210, 0, true));
        }
        if (!this.isNightVisionUpgradeEquipped(player) && this.nightVisionActive) {
            this.nightVisionActive = false;
            this.removeNightvision = true;
        }
        if (this.removeNightvision) {
            player.func_82170_o(Potion.field_76439_r.func_76396_c());
            this.removeNightvision = false;
        }
    }

    public boolean isNightVisionUpgradeEquipped(EntityPlayer player) {
        ItemStack helmet = player.func_71124_b(4);
        return NightVisionUpgrade.loadFromItem(helmet) != null;
    }

    public void setNightVisionActive(boolean isNightVisionActive) {
        if (this.nightVisionActive && !isNightVisionActive) {
            this.removeNightvision = true;
        }
        this.nightVisionActive = isNightVisionActive;
    }

    public boolean isNightVisionActive() {
        return this.nightVisionActive;
    }
}

