/*
 * Decompiled with CFR 0.152.
 */
package openeye.asm.injectors;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.util.Map;
import openeye.Log;
import openeye.asm.CallHack;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class ExceptionHandlerInjector
extends MethodVisitor {
    private final Method callTarget;
    private final Type callHackType;
    private final String[] excNames;
    private final Map<Label, String> excLabels = Maps.newIdentityHashMap();
    int currentLabel;
    private boolean skipHandlers;

    public ExceptionHandlerInjector(MethodVisitor mv, String ... excNames) {
        super(262144, mv);
        this.excNames = excNames;
        try {
            this.callHackType = Type.getType(CallHack.class);
            this.callTarget = Method.getMethod((java.lang.reflect.Method)CallHack.class.getMethod("callForSilentException", Throwable.class, String.class));
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        super.visitTryCatchBlock(start, end, handler, type);
        if (!this.skipHandlers && "java/lang/Exception".equals(type)) {
            try {
                String name = this.excNames[this.currentLabel++];
                this.excLabels.put(handler, name);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.warn("Invalid method structure, more than two exception handlers. Aborting", new Object[0]);
                this.skipHandlers = true;
            }
        }
    }

    public void visitLabel(Label label) {
        String name;
        super.visitLabel(label);
        if (!this.skipHandlers && (name = this.excLabels.get(label)) != null) {
            this.addHandler(name);
        }
    }

    private void addHandler(String location) {
        Log.info("Adding handler for '%s'", location);
        super.visitInsn(89);
        super.visitLdcInsn((Object)location);
        super.visitMethodInsn(184, this.callHackType.getInternalName(), this.callTarget.getName(), this.callTarget.getDescriptor());
    }
}

