/*
 * Decompiled with CFR 0.152.
 */
package openeye;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Log {
    private static final Logger logger = LogManager.getLogger((String)"OpenEye");
    private static final Throwable stackInfo = new Throwable();

    private Log() {
    }

    private static String getLogLocation(Throwable t) {
        StackTraceElement[] stack = t.getStackTrace();
        if (stack.length < 2) {
            return "";
        }
        StackTraceElement caller = stack[1];
        return caller.getClassName() + "." + caller.getMethodName() + "(" + caller.getFileName() + ":" + caller.getLineNumber() + "): ";
    }

    private static void logWithCaller(Throwable callerStack, Level level, String format, Object ... data) {
        logger.log(level, Log.getLogLocation(callerStack) + String.format(format, data));
    }

    public static void log(Level level, String format, Object ... data) {
        Log.logWithCaller(stackInfo.fillInStackTrace(), level, format, data);
    }

    public static void severe(String format, Object ... data) {
        Log.logWithCaller(stackInfo.fillInStackTrace(), Level.ERROR, format, data);
    }

    public static void warn(String format, Object ... data) {
        Log.logWithCaller(stackInfo.fillInStackTrace(), Level.WARN, format, data);
    }

    public static void info(String format, Object ... data) {
        Log.logWithCaller(stackInfo.fillInStackTrace(), Level.INFO, format, data);
    }

    public static void debug(String format, Object ... data) {
        Log.logWithCaller(stackInfo.fillInStackTrace(), Level.DEBUG, format, data);
    }

    public static void trace(String format, Object ... data) {
        Log.logWithCaller(stackInfo.fillInStackTrace(), Level.TRACE, format, data);
    }

    public static void log(Level level, Throwable ex, String format, Object ... data) {
        logger.log(level, String.format(format, data), ex);
    }

    public static void severe(Throwable ex, String format, Object ... data) {
        Log.log(Level.ERROR, ex, format, data);
    }

    public static void warn(Throwable ex, String format, Object ... data) {
        Log.log(Level.WARN, ex, format, data);
    }

    public static void info(Throwable ex, String format, Object ... data) {
        Log.log(Level.INFO, ex, format, data);
    }
}

