jQuery(document).ready(function() {
    jQuery('#main-body').on('click', '.product-recommendations .product-recommendation .header', function(e) {
        if (jQuery(e.target).is('.btn, .btn span, .btn .fa')) {
            return;
        }
        e.preventDefault();
        if (jQuery('.fa-square', this).length > 0) {
            return;
        }
        jQuery(this).parent().find('.rotate').toggleClass('down');
        jQuery(this).parent().find('.body').slideToggle('fast');
    }).on('click', '.product-recommendations .product-recommendation .btn-add', function() {
        jQuery(this).attr('disabled', 'disabled')
            .find('span.arrow i')
            .removeClass('fa-chevron-right')
            .addClass('fa-spinner fa-spin');
    }).on('click', '.order-button, .order-btn, .btn-order-now', function(e) {
        if (jQuery(this).data('hasRecommendations') == 1) {
            e.preventDefault();
            var href = jQuery(this).attr('href');
            jQuery('i', this).removeClass().addClass('fas fa-spinner fa-spin');
            displayRecommendations(
                href,
                'addproductajax=1',
                true
            ).done(function() {
                window.location = href;
            });
        }
    });
    setRecommendationColors();
    if (document.URL.includes('cart.php?a=checkout') || document.URL.includes('cart.php?a=view')) {
        if (jQuery('#recommendationsModal .product-recommendation:not(.clonable)').length > 0) {
            jQuery('#recommendationsModal').modal('toggle');
        }
    }
});

function modifyLuminance(hex, lum) {
    var rgb = "#",
        c,
        i;
    hex = hex.replace(/[^0-9a-f]/gi, '');
    if (hex.length < 6) {
        hex = hex[0] + hex[0] + hex[1] + hex[1] + hex[2] + hex[2];
    }
    lum = lum || 0;
    for (i = 0; i < 3; i++) {
        c = parseInt(hex.substr((i * 2), 2), 16);
        c = Math.round(Math.min(Math.max(0, (c + (c * lum))), 255)).toString(16);
        rgb += ("00" + c).substr(c.length);
    }
    return rgb;
}

function setRecommendationColors() {
    var shadeColor,
        defaultColor = '#9abb3a';
    jQuery('.product-recommendations .product-recommendation').each(function() {
        var element = jQuery(this),
            primaryColor = element.data('color');
        if (!(primaryColor.length > 0) || (primaryColor.match(/^#[0-9A-Fa-f]{3,6}$/gi) == undefined)) {
            primaryColor = defaultColor;
        }
        shadeColor = modifyLuminance(primaryColor, -0.15);
        element.css('border-color', primaryColor);
        jQuery('.btn-add', element).css('background-color', primaryColor);
        jQuery('.expander', element).css('color', primaryColor);
        jQuery('.price', element).css('color', shadeColor);
        jQuery('.arrow', element).css('background-color', shadeColor);
    });
}

function displayRecommendations(postUrl, postData, postForce) {
    var deferredObject = jQuery.Deferred(),
        hasRecommendations = jQuery('#divProductHasRecommendations').data('value'),
        modal = jQuery('#recommendationsModal'),
        shoppingCartBtn = jQuery('.cart-btn .badge');
    if (postForce || hasRecommendations) {
        jQuery('.cart-body button[type="submit"] i')
            .removeClass('fa-arrow-circle-right')
            .addClass('fa-spinner fa-spin');
        WHMCS.http.jqClient.jsonPost({
            url: postUrl,
            data: postData,
            success: function(data) {
                if (data.success && data.href) {
                    modal.on('hide.bs.modal', function() {
                        window.location = data.href;
                        return false;
                    });
                    jQuery('#btnContinueRecommendationsModal', modal)
                        .attr('href', data.href)
                        .click(function () {
                            jQuery('span', this).removeClass('w-hidden hidden');
                        });
                    jQuery('.modal-body', modal).html('').html(data.html);
                    setRecommendationColors();
                    modal.modal('show');
                    jQuery('i.fa-spinner.fa-spin:visible').removeClass('fa-spinner fa-spin').addClass('fa-check-circle');
                    shoppingCartBtn.text(data.count);
                } else if (!data.success && data.href) {
                    window.location = data.href;
                } else {
                    deferredObject.resolve(false);
                }
            },
            error: function() {
                deferredObject.resolve(false);
            }
        });
    } else {
        deferredObject.resolve(false);
    }
    return deferredObject.promise();
}
