/*
 * Decompiled with CFR 0.152.
 */
package com.quantcast.qfs.hadoop;

import com.quantcast.qfs.access.KfsAccess;
import com.quantcast.qfs.access.KfsAccessBase;
import com.quantcast.qfs.access.KfsFileAttr;
import com.quantcast.qfs.hadoop.CloseableIterator;
import com.quantcast.qfs.hadoop.IFSImpl;
import com.quantcast.qfs.hadoop.QFSInputStream;
import com.quantcast.qfs.hadoop.QFSOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

class QFSImpl
implements IFSImpl {
    protected KfsAccess kfsAccess = null;
    private FileSystem.Statistics statistics;
    private final long BLOCK_SIZE = 0x4000000L;
    private final String CREATE_PARAMS_DEFAULT = "S";
    private final String CREATE_PARAMS;
    private final boolean CREATE_FORCE_TYPE_FLAG;
    private final FileStatusCreator statusCreator = new FileStatusCreator();

    public QFSImpl(String metaServerHost, int metaServerPort, FileSystem.Statistics stats, Configuration cfg) throws IOException {
        this.kfsAccess = new KfsAccess(metaServerHost, metaServerPort);
        long kMaxUserGroupId = 0xFFFFFFFFL;
        long kDefaultUser = -1L;
        long kDefaultGroup = -1L;
        long euser = cfg.getLong("fs.qfs.euser", -1L);
        long egroup = cfg.getLong("fs.qfs.egroup", -1L);
        String groupsCfgName = "fs.qfs.egroups";
        String groupsSeparator = ",";
        String groupsCfg = cfg.get("fs.qfs.egroups", "");
        long[] groups = null;
        this.CREATE_PARAMS = cfg.get("fs.qfs.createParams", "S");
        this.CREATE_FORCE_TYPE_FLAG = cfg.getBoolean("fs.qfs.create.forceType", false);
        if (-1L != euser && (euser < 0L || 0xFFFFFFFFL <= euser)) {
            throw new IOException("invalid effective user id: " + euser);
        }
        if (-1L != egroup && (egroup < 0L || 0xFFFFFFFFL <= egroup)) {
            throw new IOException("invalid effective group id: " + egroup);
        }
        if (groupsCfg.contains(",")) {
            try {
                String[] tokens = groupsCfg.split(",");
                if (0 < tokens.length) {
                    groups = new long[tokens.length];
                    for (int i = 0; i < tokens.length; ++i) {
                        groups[i] = Long.parseLong(tokens[i]);
                        if (groups[i] >= 0L && 0xFFFFFFFFL > groups[i]) continue;
                        throw new IOException("invalid group id: " + groups[i]);
                    }
                }
            }
            catch (Exception ex) {
                throw new IOException("failed to parse configuration setting fs.qfs.egroups " + ex.getMessage());
            }
        }
        if (-1L != euser || -1L != egroup || null != groups) {
            this.kfsAccess.kfs_setEUserAndEGroup(euser, egroup, groups);
        }
        this.statistics = stats;
    }

    @Override
    public boolean exists(String path) throws IOException {
        return this.kfsAccess.kfs_exists(path);
    }

    @Override
    public boolean isDirectory(String path) throws IOException {
        return this.kfsAccess.kfs_isDirectory(path);
    }

    @Override
    public boolean isFile(String path) throws IOException {
        return this.kfsAccess.kfs_isFile(path);
    }

    @Override
    public String[] readdir(String path) throws IOException {
        return this.kfsAccess.kfs_readdir(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileStatus[] readdirplus(Path path) throws IOException {
        try (KfsAccessBase.DirectoryIterator itr = null;){
            KfsAccess kfsAccess = this.kfsAccess;
            Objects.requireNonNull(kfsAccess);
            itr = new KfsAccessBase.DirectoryIterator(kfsAccess, path.toUri().getPath());
            ArrayList<FileStatus> ret = new ArrayList<FileStatus>();
            String prefix = path.toString();
            if (!prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            while (itr.next()) {
                if (itr.filename.compareTo(".") == 0 || itr.filename.compareTo("..") == 0) continue;
                ret.add(this.statusCreator.create(itr.isDirectory ? 0L : itr.filesize, itr.isDirectory, itr.isDirectory ? 1 : itr.replication, itr.isDirectory ? 0L : 0x4000000L, itr.modificationTime, itr.creationTime, FsPermission.createImmutable((short)((short)itr.mode)), itr.ownerName, itr.groupName, 1 == itr.extAttrTypes ? itr.extAttrs : null, new Path(prefix + itr.filename)));
            }
            FileStatus[] fileStatusArray = ret.toArray(new FileStatus[0]);
            return fileStatusArray;
        }
    }

    @Override
    public FileStatus stat(Path path) throws IOException {
        KfsFileAttr fa = new KfsFileAttr();
        String pn = path.toUri().getPath();
        this.kfsAccess.kfs_retToIOException(this.kfsAccess.kfs_stat(pn, fa), pn);
        return this.statusCreator.create(path, fa);
    }

    @Override
    public FileStatus lstat(Path path) throws IOException {
        KfsFileAttr fa = new KfsFileAttr();
        String pn = path.toUri().getPath();
        this.kfsAccess.kfs_retToIOException(this.kfsAccess.kfs_lstat(pn, fa), pn);
        Path lp = 1 == fa.extAttrTypes ? new Path(fa.extAttrs) : null;
        return this.statusCreator.create(path, fa);
    }

    @Override
    public KfsFileAttr fullStat(Path path) throws IOException {
        KfsFileAttr fa = new KfsFileAttr();
        String pn = path.toUri().getPath();
        this.kfsAccess.kfs_retToIOException(this.kfsAccess.kfs_stat(pn, fa), pn);
        return fa;
    }

    @Override
    public int mkdirs(String path, int mode) throws IOException {
        return this.kfsAccess.kfs_mkdirs(path, mode);
    }

    @Override
    public int mkdir(String path, int mode) throws IOException {
        return this.kfsAccess.kfs_mkdir(path, mode);
    }

    @Override
    public int rename2(String source, String dest, boolean overwrite) throws IOException {
        return this.kfsAccess.kfs_rename(source, dest, overwrite);
    }

    @Override
    public int rename(String source, String dest) throws IOException {
        String renameTarget;
        if (this.kfsAccess.kfs_isDirectory(dest)) {
            String sourceBasename = new File(source).getName();
            renameTarget = dest.endsWith("/") ? dest + sourceBasename : dest + "/" + sourceBasename;
        } else {
            renameTarget = dest;
        }
        return this.kfsAccess.kfs_rename(source, renameTarget);
    }

    @Override
    public int rmdir(String path) throws IOException {
        return this.kfsAccess.kfs_rmdir(path);
    }

    @Override
    public int rmdirs(String path) throws IOException {
        return this.kfsAccess.kfs_rmdirs(path);
    }

    @Override
    public int remove(String path) throws IOException {
        return this.kfsAccess.kfs_remove(path);
    }

    @Override
    public long filesize(String path) throws IOException {
        return this.kfsAccess.kfs_filesize(path);
    }

    @Override
    public short getReplication(String path) throws IOException {
        return this.kfsAccess.kfs_getReplication(path);
    }

    @Override
    public short setReplication(String path, short replication) throws IOException {
        return this.kfsAccess.kfs_setReplication(path, replication);
    }

    @Override
    public String[][] getDataLocation(String path, long start, long len) throws IOException {
        return this.kfsAccess.kfs_getDataLocation(path, start, len);
    }

    @Override
    public String[][] getBlocksLocation(String path, long start, long len) throws IOException {
        return this.kfsAccess.kfs_getBlocksLocation(path, start, len);
    }

    @Override
    public long getModificationTime(String path) throws IOException {
        return this.kfsAccess.kfs_getModificationTime(path);
    }

    @Override
    public FSDataOutputStream create(String path, short replication, int bufferSize, boolean overwrite, int mode) throws IOException {
        boolean append = false;
        return this.create(path, replication, bufferSize, overwrite, mode, false);
    }

    @Override
    public FSDataOutputStream create(String path, short replication, int bufferSize, boolean overwrite, int mode, boolean append) throws IOException {
        return new FSDataOutputStream((OutputStream)this.createQFSOutputStream(this.kfsAccess, path, replication, overwrite, append, mode), this.statistics);
    }

    @Override
    public FSDataOutputStream create(String path, boolean overwrite, String createParams, int mode, boolean forceType) throws IOException {
        if (createParams == null || createParams.length() == 0) {
            createParams = this.CREATE_PARAMS;
            forceType = this.CREATE_FORCE_TYPE_FLAG;
        }
        return new FSDataOutputStream((OutputStream)this.createQFSOutputStream(this.kfsAccess, path, overwrite, createParams, mode, forceType), this.statistics);
    }

    @Override
    public FSDataInputStream open(String path, int bufferSize) throws IOException {
        return new FSDataInputStream((InputStream)((Object)this.createQFSInputStream(this.kfsAccess, path, this.statistics)));
    }

    @Override
    public FSDataOutputStream append(String path, short replication, int bufferSize) throws IOException {
        boolean append = true;
        boolean overwrite = false;
        int mode = 438;
        return new FSDataOutputStream((OutputStream)this.createQFSOutputStream(this.kfsAccess, path, replication, false, true, 438), this.statistics);
    }

    @Override
    public void setPermission(String path, int mode) throws IOException {
        this.kfsAccess.kfs_retToIOException(this.kfsAccess.kfs_chmod(path, mode), path);
    }

    @Override
    public void setOwner(String path, String username, String groupname) throws IOException {
        this.kfsAccess.kfs_retToIOException(this.kfsAccess.kfs_chown(path, username, groupname), path);
    }

    @Override
    public int getUMask() throws IOException {
        return this.kfsAccess.kfs_getUMask();
    }

    @Override
    public void setUMask(int mask) throws IOException {
        this.kfsAccess.kfs_setUMask(mask);
    }

    @Override
    public void retToIoException(int ret) throws IOException {
        this.kfsAccess.kfs_retToIOException(ret);
    }

    @Override
    public Path getLinkTarget(Path path) throws IOException {
        KfsFileAttr fa = new KfsFileAttr();
        String pn = path.toUri().getPath();
        this.kfsAccess.kfs_retToIOException(this.kfsAccess.kfs_lstat(pn, fa), pn);
        if (1 != fa.extAttrTypes) {
            throw new IOException(path + ": not a symlink");
        }
        return new Path(fa.extAttrs);
    }

    protected QFSOutputStream createQFSOutputStream(KfsAccess kfsAccess, String path, short replication, boolean overwrite, boolean append, int mode) throws IOException {
        String createParams = null;
        boolean forceType = false;
        return append || "S" == this.CREATE_PARAMS ? new QFSOutputStream(kfsAccess, path, replication, overwrite, append, mode) : new QFSOutputStream(kfsAccess, path, overwrite, createParams, mode, false);
    }

    protected QFSOutputStream createQFSOutputStream(KfsAccess kfsAccess, String path, boolean overwrite, String createParams, int mode, boolean forceType) throws IOException {
        return new QFSOutputStream(kfsAccess, path, overwrite, createParams, mode, forceType);
    }

    protected QFSInputStream createQFSInputStream(KfsAccess kfsAccess, String path, FileSystem.Statistics stats) throws IOException {
        return new QFSInputStream(kfsAccess, path, stats);
    }

    @Override
    public CloseableIterator<FileStatus> getFileStatusIterator(FileSystem fs, Path path) throws IOException {
        return new KfsFileStatusIterator(fs, path);
    }

    @Override
    public void symlink(String target, String link, int mode, boolean overwrite) throws IOException {
        this.kfsAccess.kfs_retToIOException(this.kfsAccess.kfs_symlink(target, link, mode, overwrite));
    }

    class FileStatusCreator {
        private Constructor<FileStatus> constr;

        public FileStatusCreator() {
            try {
                this.constr = FileStatus.class.getConstructor(Long.TYPE, Boolean.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, FsPermission.class, String.class, String.class, Path.class, Path.class);
            }
            catch (NoSuchMethodException ex) {
                this.constr = null;
            }
        }

        public FileStatus create(long length, boolean isdir, int blockReplication, long blockSize, long modificationTime, long accessTime, FsPermission permission, String owner, String group, String symlink, Path path) throws IOException {
            if (null != this.constr) {
                Path link = null == symlink ? null : new Path(symlink);
                try {
                    return this.constr.newInstance(length, isdir, blockReplication, blockSize, modificationTime, accessTime, permission, owner, group, link, path);
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }
            return new FileStatus(length, isdir, blockReplication, blockSize, modificationTime, accessTime, permission, owner, group, path);
        }

        public FileStatus create(Path path, KfsFileAttr fa) throws IOException {
            String lp = 1 == fa.extAttrTypes ? fa.extAttrs : null;
            return this.create(fa.isDirectory ? 0L : fa.filesize, fa.isDirectory, fa.isDirectory ? 1 : fa.replication, fa.isDirectory ? 0L : 0x4000000L, fa.modificationTime, fa.creationTime, FsPermission.createImmutable((short)((short)fa.mode)), fa.ownerName, fa.groupName, lp, path);
        }
    }

    public class KfsFileStatusIterator
    implements CloseableIterator<FileStatus> {
        final Path path;
        final FileSystem fileSystem;
        private final FileStatusCreator statusCreator;
        String prefix;
        KfsAccessBase.DirectoryIterator itr;
        FileStatus current;

        public KfsFileStatusIterator(FileSystem fs, Path p) throws IOException {
            FileStatus status;
            this.statusCreator = new FileStatusCreator();
            this.fileSystem = fs;
            this.path = p;
            this.prefix = this.path.toString();
            if (!this.prefix.endsWith("/")) {
                this.prefix = this.prefix + "/";
            }
            if (!(status = this.fileSystem.getFileStatus(this.path)).isDir()) {
                throw new IOException(this.path + " is not a directory");
            }
            KfsAccess kfsAccess = QFSImpl.this.kfsAccess;
            Objects.requireNonNull(kfsAccess);
            this.itr = new KfsAccessBase.DirectoryIterator(kfsAccess, this.path.toUri().getPath());
            this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public FileStatus next() {
            FileStatus oldCurrent = this.current;
            this.getNext();
            return oldCurrent;
        }

        @Override
        public void remove() {
            this.close();
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public void close() {
            if (this.itr != null) {
                try {
                    this.itr.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.itr = null;
                    this.current = null;
                }
            }
        }

        private void getNext() {
            this.current = null;
            if (this.itr == null) {
                throw new NoSuchElementException();
            }
            try {
                while (this.itr.next()) {
                    if (this.itr.filename.compareTo(".") == 0 || this.itr.filename.compareTo("..") == 0) continue;
                    this.current = this.statusCreator.create(this.itr.isDirectory ? 0L : this.itr.filesize, this.itr.isDirectory, this.itr.isDirectory ? 1 : this.itr.replication, this.itr.isDirectory ? 0L : 0x4000000L, this.itr.modificationTime, this.itr.creationTime, FsPermission.createImmutable((short)((short)this.itr.mode)), this.itr.ownerName, this.itr.groupName, 1 == this.itr.extAttrTypes ? this.itr.extAttrs : null, new Path(this.prefix + this.itr.filename).makeQualified(this.fileSystem));
                    break;
                }
            }
            catch (IOException e) {
                this.close();
                throw new RuntimeException("Error while iterating " + this.path, e);
            }
            if (this.current == null) {
                this.close();
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

