/*
 * Decompiled with CFR 0.152.
 */
package com.quantcast.qfs.hadoop;

import com.quantcast.qfs.access.KfsAccess;
import com.quantcast.qfs.access.KfsOutputChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class QFSOutputStream
extends OutputStream {
    private final KfsOutputChannel kfsChannel;

    public QFSOutputStream(KfsAccess kfsAccess, String path, short replication, boolean overwrite, boolean append, int mode) throws IOException {
        if (append) {
            this.kfsChannel = kfsAccess.kfs_append_ex(path, replication, mode);
        } else {
            long bufferSize = -1L;
            long readAheadSize = -1L;
            boolean exclusive = !overwrite;
            this.kfsChannel = kfsAccess.kfs_create_ex(path, replication, exclusive, -1L, -1L, mode);
        }
        if (this.kfsChannel == null) {
            throw new IOException("QFS internal error -- null channel");
        }
    }

    public QFSOutputStream(KfsAccess kfsAccess, String path, boolean overwrite, String createParams, int mode, boolean forceTypeFlag) throws IOException {
        boolean exclusive = !overwrite;
        this.kfsChannel = kfsAccess.kfs_create_ex(path, exclusive, createParams, mode, forceTypeFlag);
        if (this.kfsChannel == null) {
            throw new IOException("QFS internal error -- null channel");
        }
    }

    public long getPos() throws IOException {
        return this.kfsChannel.tell();
    }

    @Override
    public void write(int v) throws IOException {
        byte[] b = new byte[]{(byte)v};
        this.write(b, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.kfsChannel.write(ByteBuffer.wrap(b, off, len));
    }

    @Override
    public void flush() throws IOException {
        this.kfsChannel.sync();
    }

    @Override
    public synchronized void close() throws IOException {
        this.flush();
        this.kfsChannel.close();
    }

    public void setIoBufferSize(long bufferSize) {
        this.kfsChannel.setIoBufferSize(bufferSize);
    }
}

