/*
 * Decompiled with CFR 0.152.
 */
package com.quantcast.qfs.access;

import com.quantcast.qfs.access.KfsAccess;
import com.quantcast.qfs.access.KfsDelegation;
import com.quantcast.qfs.access.KfsFileAttr;
import com.quantcast.qfs.access.KfsInputChannel;
import com.quantcast.qfs.access.KfsOutputChannel;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;

public class KfsTest {
    private static final Random randGen = new Random(100L);

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: KfsTest <meta server> <port>");
            System.exit(1);
        }
        try {
            KfsFileAttr attr;
            int ret;
            long egid;
            int port = Integer.parseInt(args[1].trim());
            KfsAccess kfsAccess = new KfsAccess(args[0], port);
            String basedir = "jtest";
            String euidp = System.getProperty("kfs.euid");
            String egidp = System.getProperty("kfs.egid");
            long euid = euidp != null && euidp.length() > 0 ? Long.decode(euidp) : -1L;
            long l = egid = egidp != null && egidp.length() > 0 ? Long.decode(egidp) : -1L;
            if (euid != -1L || egid != -1L) {
                kfsAccess.kfs_retToIOException(kfsAccess.kfs_setEUserAndEGroup(euid, egid, null));
            }
            KfsDelegation dtoken = null;
            try {
                boolean allowDelegationFlag = true;
                long delegationValidForSec = 86400L;
                KfsDelegation result = kfsAccess.kfs_createDelegationToken(true, 86400L);
                System.out.println("create delegation token: ");
                System.out.println("delegation:  " + result.delegationAllowedFlag);
                System.out.println("issued:      " + result.issuedTime);
                System.out.println("token valid: " + result.tokenValidForSec);
                System.out.println("valid:       " + result.delegationValidForSec);
                System.out.println("token:       " + result.token);
                System.out.println("key:         " + result.key);
                dtoken = result;
            }
            catch (IOException ex) {
                String msg = ex.getMessage();
                if (msg == null) {
                    msg = "null";
                }
                System.out.println("create delegation token error: " + msg);
            }
            if (dtoken != null) {
                try {
                    kfsAccess.kfs_renewDelegationToken(dtoken);
                    System.out.println("renew delegation token: ");
                    System.out.println("delegation:  " + dtoken.delegationAllowedFlag);
                    System.out.println("issued:      " + dtoken.issuedTime);
                    System.out.println("token valid: " + dtoken.tokenValidForSec);
                    System.out.println("valid:       " + dtoken.delegationValidForSec);
                    System.out.println("token:       " + dtoken.token);
                    System.out.println("key:         " + dtoken.key);
                }
                catch (IOException ex) {
                    String msg = ex.getMessage();
                    if (msg == null) {
                        msg = "null";
                    }
                    System.out.println("renew delegation token error: " + msg);
                    throw ex;
                }
                try {
                    KfsDelegation ctoken = new KfsDelegation();
                    ctoken.token = dtoken.token;
                    ctoken.key = dtoken.key;
                    kfsAccess.kfs_cancelDelegationToken(ctoken);
                }
                catch (IOException ex) {
                    String msg = ex.getMessage();
                    if (msg == null) {
                        msg = "null";
                    }
                    System.out.println("cancel delegation token error: " + msg);
                    throw ex;
                }
                try {
                    kfsAccess.kfs_renewDelegationToken(dtoken);
                }
                catch (IOException ex) {
                    String msg = ex.getMessage();
                    if (msg == null) {
                        msg = "null";
                    }
                    System.out.println("renew canceled delegation token error: " + msg);
                    dtoken = null;
                }
                if (dtoken != null) {
                    throw new IOException("Token renew after cancellation succeeded");
                }
            }
            if (!kfsAccess.kfs_exists(basedir)) {
                kfsAccess.kfs_retToIOException(kfsAccess.kfs_mkdirs(basedir));
            }
            if (!kfsAccess.kfs_isDirectory(basedir)) {
                throw new IOException("QFS doesn't think " + basedir + " is a dir!");
            }
            String fname = "foo.1";
            String path = basedir + "/" + "foo.1";
            KfsOutputChannel outputChannel = kfsAccess.kfs_create(path);
            long mTime = kfsAccess.kfs_getModificationTime(path);
            Date d = new Date(mTime);
            System.out.println("Modification time for: " + path + " is: " + d.toString());
            String[] entries = kfsAccess.kfs_readdir(basedir);
            if (entries == null) {
                throw new IOException(basedir + ": readdir failed");
            }
            System.out.println("Readdir returned: ");
            for (String entrie : entries) {
                System.out.println(entrie);
            }
            String absent = basedir + "/must not exist";
            entries = kfsAccess.kfs_readdir(absent);
            if (entries != null) {
                throw new IOException(absent + ": kfs_readdir: " + absent + " non null, size: " + entries.length);
            }
            int numBytes = 2048;
            char[] dataBuf = new char[numBytes];
            KfsTest.generateData(dataBuf, numBytes);
            String s = new String(dataBuf);
            byte[] buf = s.getBytes();
            ByteBuffer b = ByteBuffer.wrap(buf, 0, buf.length);
            int res = outputChannel.write(b);
            if (res != buf.length) {
                throw new IOException(path + ": was able to write only: " + res);
            }
            outputChannel.sync();
            outputChannel.close();
            String symName = "foo.1.sym";
            String slPath = basedir + "/" + "foo.1.sym";
            boolean overwrite = false;
            kfsAccess.kfs_retToIOException(kfsAccess.kfs_symlink(path + ".1", slPath, 511, overwrite), "kfs_symlink " + slPath);
            res = kfsAccess.kfs_symlink(path + "2", slPath, 511, overwrite);
            if (0 == res) {
                throw new IOException(slPath + ": symlink succeeded: " + res);
            }
            System.out.println(slPath + ": " + res);
            overwrite = true;
            kfsAccess.kfs_retToIOException(kfsAccess.kfs_symlink("foo.1", slPath, 511, overwrite), "kfs_symlink overwrite " + slPath);
            KfsFileAttr slattr = new KfsFileAttr();
            kfsAccess.kfs_retToIOException(kfsAccess.kfs_lstat(slPath, slattr), "kfs_lstat overwrite " + slPath);
            System.out.println(KfsTest.attrToString(slattr, "\n"));
            if (1 != slattr.extAttrTypes) {
                throw new IOException(slPath + ": lstat extAttrTypes: " + slattr.extAttrTypes + " expected: " + 1);
            }
            if (null == slattr.extAttrs || !slattr.extAttrs.equals("foo.1")) {
                throw new IOException(slPath + ": lstat: " + slattr.extAttrs + " expected: " + "foo.1");
            }
            kfsAccess.kfs_retToIOException(kfsAccess.kfs_stat(slPath, slattr), "kfs_stat " + slPath);
            System.out.println(KfsTest.attrToString(slattr, "\n"));
            if (null != slattr.extAttrs) {
                throw new IOException(slPath + ": stat: " + slattr.extAttrs);
            }
            KfsFileAttr[] fattr = kfsAccess.kfs_readdirplus(basedir);
            if (fattr == null) {
                throw new IOException(basedir + ": kfs_readdirplus failed");
            }
            System.out.println("kfs_readdirplus returned: ");
            for (KfsFileAttr fattr1 : fattr) {
                System.out.println(KfsTest.attrToString(fattr1, "\n"));
            }
            fattr = kfsAccess.kfs_readdirplus(absent);
            if (fattr != null) {
                throw new IOException("kfs_readdirplus: " + fattr + ": non null, size: " + fattr.length);
            }
            System.out.println("Trying to lookup blocks for file: " + path);
            String[][] locs = kfsAccess.kfs_getDataLocation(path, 10L, 512L);
            if (locs == null) {
                throw new IOException(path + ": kfs_getDataLocation failed");
            }
            System.out.println("Block Locations:");
            for (int i = 0; i < locs.length; ++i) {
                System.out.print("chunk " + i + " : ");
                for (String loc : locs[i]) {
                    System.out.print(loc + " ");
                }
                System.out.println();
            }
            locs = kfsAccess.kfs_getBlocksLocation(path, 10L, 512L);
            if (locs == null) {
                throw new IOException(path + ": kfs_getBlocksLocation failed");
            }
            if (locs.length < 1 || locs[0].length != 1) {
                throw new IOException(path + ": kfs_getBlocksLocation invalid first slot length");
            }
            long blockSize = Long.parseLong(locs[0][0], 16);
            if (blockSize < 0L) {
                kfsAccess.kfs_retToIOException((int)blockSize, path);
            }
            System.out.println("block size: " + blockSize);
            for (int i = 1; i < locs.length; ++i) {
                System.out.print("chunk " + (i - 1) + " : ");
                for (String loc : locs[i]) {
                    System.out.print(loc + " ");
                }
                System.out.println();
            }
            long sz = kfsAccess.kfs_filesize(path);
            if (sz != (long)buf.length) {
                System.out.println("System thinks the file's size is: " + sz);
            }
            if ((ret = kfsAccess.kfs_stat(path, attr = new KfsFileAttr())) != 0) {
                throw new IOException(path + ": stat failed: " + ret);
            }
            System.out.println("stat: \n" + KfsTest.attrToString(attr, "\n"));
            String npath = basedir + "/foo.2";
            kfsAccess.kfs_rename(path, npath);
            if (kfsAccess.kfs_exists(path)) {
                throw new IOException(path + " still exists after rename!");
            }
            KfsOutputChannel outputChannel1 = kfsAccess.kfs_create(path);
            if (outputChannel1 != null) {
                outputChannel1.close();
            }
            if (!kfsAccess.kfs_exists(path)) {
                throw new IOException(path + " doesn't exist");
            }
            if (kfsAccess.kfs_rename(npath, path, false) == 0) {
                throw new IOException("rename with overwrite disabled succeeded!");
            }
            kfsAccess.kfs_retToIOException(kfsAccess.kfs_remove(path), "kfs_remove: " + path);
            kfsAccess.kfs_retToIOException(kfsAccess.kfs_remove(slPath), "kfs_remove: " + slPath);
            if (!kfsAccess.kfs_isFile(npath)) {
                throw new IOException(npath + " is not a normal file!");
            }
            KfsInputChannel inputChannel = kfsAccess.kfs_open(npath);
            if (inputChannel == null) {
                throw new IOException("open on " + npath + "failed!");
            }
            buf = new byte[128];
            res = inputChannel.read(ByteBuffer.wrap(buf, 0, 128));
            if (res != 128) {
                throw new IOException(npath + ": was able to read only: " + res);
            }
            s = new String(buf);
            for (int i = 0; i < 128; ++i) {
                if (dataBuf[i] == s.charAt(i)) continue;
                System.out.println("Data mismatch at char: " + i);
            }
            inputChannel.seek(40L);
            sz = inputChannel.tell();
            if (sz != 40L) {
                System.out.println("After seek, we are at: " + sz);
            }
            inputChannel.close();
            KfsTest.testUtimes(kfsAccess, npath);
            kfsAccess.kfs_retToIOException(kfsAccess.kfs_remove(npath), "kfs_remove: " + npath);
            KfsTest.testDirs(kfsAccess, basedir + "/");
            String rtest = basedir + "/rtest";
            String testPath = rtest + "/a/b/../../c/../d";
            kfsAccess.kfs_retToIOException(kfsAccess.kfs_mkdirs(testPath));
            if (!kfsAccess.kfs_exists(testPath)) {
                throw new IOException(testPath + " doesn't exist");
            }
            kfsAccess.kfs_create(testPath + "/test_file").close();
            kfsAccess.kfs_retToIOException(kfsAccess.kfs_rmdirs(rtest));
            if (kfsAccess.kfs_exists(rtest)) {
                throw new IOException(rtest + " exist");
            }
            KfsTest.testCreateAPI(kfsAccess, basedir);
            KfsTest.testDisableReadAhead(kfsAccess, basedir);
            Iterator<Map.Entry<String, String>> it = kfsAccess.kfs_getStats().entrySet().iterator();
            System.out.println("Clients stats:");
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                System.out.println(entry.getKey() + ": " + entry.getValue());
            }
            KfsTest.testUtimes(kfsAccess, basedir);
            kfsAccess.kfs_retToIOException(kfsAccess.kfs_rmdir(basedir));
            System.out.println("All done...Test passed!");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.println(e.getMessage());
            System.out.println("Test failed");
            System.exit(1);
        }
    }

    private static void generateData(char[] buf, int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            buf[i] = (char)(97 + randGen.nextInt(26));
        }
    }

    private static String attrToString(KfsFileAttr attr, String delim) {
        return "filename: " + attr.filename + delim + "isDirectory: " + attr.isDirectory + delim + "filesize: " + attr.filesize + delim + "modificationTime: " + attr.modificationTime + delim + "attrChangeTime: " + attr.attrChangeTime + delim + "creationTime: " + attr.creationTime + delim + "replication: " + attr.replication + delim + "striperType: " + attr.striperType + delim + "numStripes: " + attr.numStripes + delim + "numRecoveryStripes: " + attr.numRecoveryStripes + delim + "stripeSize: " + attr.stripeSize + delim + "minSTier: " + attr.minSTier + delim + "maxSTier: " + attr.maxSTier + delim + "owner: " + attr.owner + delim + "group: " + attr.group + delim + "mode: " + attr.mode + delim + "fileId: " + attr.fileId + delim + "dirCount: " + attr.dirCount + delim + "fileCount: " + attr.fileCount + delim + "chunkCount: " + attr.chunkCount + delim + "ownerName: " + attr.ownerName + delim + "groupName: " + attr.groupName + delim + "extAttrTypes: " + attr.extAttrTypes + delim + "extAttrs: " + attr.extAttrs;
    }

    private static void testDirs(KfsAccess fs, String root) throws IOException {
        String oldDir = root + "old";
        String newDir = root + "new";
        for (int i = 0; i < 4; ++i) {
            fs.kfs_retToIOException(fs.kfs_mkdirs(oldDir));
            System.out.println("Pass " + i + ": " + oldDir + " exists " + fs.kfs_exists(oldDir));
            if (fs.kfs_exists(newDir)) {
                KfsTest.delete(fs, newDir);
            }
            KfsTest.rename(fs, oldDir, newDir);
        }
        KfsTest.delete(fs, newDir);
    }

    private static void rename(KfsAccess kfsAccess, String source, String dest) throws IOException {
        String renameTarget;
        if (kfsAccess.kfs_isDirectory(dest)) {
            String sourceBasename = new File(source).getName();
            renameTarget = dest.endsWith("/") ? dest + sourceBasename : dest + "/" + sourceBasename;
        } else {
            renameTarget = dest;
        }
        kfsAccess.kfs_retToIOException(kfsAccess.kfs_rename(source, renameTarget));
    }

    private static void delete(KfsAccess kfsAccess, String path) throws IOException {
        kfsAccess.kfs_retToIOException(kfsAccess.kfs_isFile(path) ? kfsAccess.kfs_remove(path) : kfsAccess.kfs_rmdirs(path));
    }

    private static void testCreateAPI(KfsAccess kfsAccess, String baseDir) throws IOException {
        kfsAccess.kfs_retToIOException(kfsAccess.kfs_setUMask(0));
        String filePath1 = baseDir + "/sample_file.1";
        boolean exclusiveFlag = true;
        String createParams = "1,6,3,1048576,2,15,15";
        boolean forceTypeFlag = true;
        KfsOutputChannel outputChannel = kfsAccess.kfs_create_ex(filePath1, true, "1,6,3,1048576,2,15,15", 384, true);
        KfsTest.verifyFileAttr(kfsAccess, outputChannel, filePath1, 384);
        String filePath2 = baseDir + "/sample_file.2";
        outputChannel = kfsAccess.kfs_create_ex(filePath2, 1, true, -1L, -1L, 6, 3, 0x100000, 2, false, 438, 15, 15);
        KfsTest.verifyFileAttr(kfsAccess, outputChannel, filePath2, 438);
        KfsTest.delete(kfsAccess, filePath1);
        KfsTest.delete(kfsAccess, filePath2);
    }

    private static void verifyFileAttr(KfsAccess kfsAccess, KfsOutputChannel outputChannel, String filePath, int mode) throws IOException {
        int numBytes = 0x100000;
        char[] dataBuf = new char[0x100000];
        KfsTest.generateData(dataBuf, 0x100000);
        String s = new String(dataBuf);
        byte[] buf = s.getBytes();
        ByteBuffer b = ByteBuffer.wrap(buf, 0, buf.length);
        int res = outputChannel.write(b);
        if (res != buf.length) {
            throw new IOException(filePath + ": was able to write only: " + res);
        }
        outputChannel.sync();
        outputChannel.close();
        KfsFileAttr attr = new KfsFileAttr();
        kfsAccess.kfs_retToIOException(kfsAccess.kfs_stat(filePath, attr));
        if (0x100000L != attr.filesize || attr.replication != 1 || attr.striperType != 2 || attr.numStripes != 6 || attr.numRecoveryStripes != 3 || attr.stripeSize != 0x100000 || mode != attr.mode) {
            throw new IOException(filePath + ": file attributes mismatch");
        }
    }

    private static void testDisableReadAhead(KfsAccess kfsAccess, String baseDir) throws IOException {
        int i;
        String filePath = baseDir + "/sample_file.1";
        String createParams = "S";
        KfsOutputChannel outputChannel = kfsAccess.kfs_create_ex(filePath, true, "S");
        int numBytes = 0x100000;
        char[] dataBuf = new char[0x100000];
        KfsTest.generateData(dataBuf, 0x100000);
        String s = new String(dataBuf);
        byte[] buf = s.getBytes();
        ByteBuffer b = ByteBuffer.wrap(buf, 0, buf.length);
        int res = outputChannel.write(b);
        if (res != buf.length) {
            throw new IOException(filePath + ": was able to write only: " + res);
        }
        outputChannel.sync();
        outputChannel.close();
        KfsInputChannel inputChannel = kfsAccess.kfs_open(filePath);
        inputChannel.setReadAheadSize(0L);
        byte[] dstBuf = new byte[128];
        res = inputChannel.read(ByteBuffer.wrap(dstBuf, 0, 128));
        if (res != 128) {
            throw new IOException(filePath + ": was able to read only: " + res);
        }
        s = new String(dstBuf);
        for (int i2 = 0; i2 < 128; ++i2) {
            if (dataBuf[i2] == s.charAt(i2)) continue;
            throw new IOException(filePath + ": data mismatch at char: " + i2);
        }
        inputChannel.seek(512L);
        long pos = inputChannel.tell();
        if (pos != 512L) {
            throw new IOException(filePath + "failed to seek to byte 512. Pos: " + pos);
        }
        res = inputChannel.read(ByteBuffer.wrap(dstBuf, 0, 128));
        if (res != 128) {
            throw new IOException(filePath + ": was able to read only: " + res);
        }
        s = new String(dstBuf);
        for (i = 0; i < 128; ++i) {
            if (dataBuf[512 + i] == s.charAt(i)) continue;
            throw new IOException(filePath + ": data mismatch at char " + i + " after seeking to byte 512");
        }
        inputChannel.seek(0L);
        pos = inputChannel.tell();
        if (pos != 0L) {
            throw new IOException(filePath + ": failed to seek to the beginning. pos: " + pos);
        }
        inputChannel.setReadAheadSize(0x100000L);
        res = inputChannel.read(ByteBuffer.wrap(dstBuf, 0, 128));
        if (res != 128) {
            throw new IOException(filePath + ": was able to read only: " + res);
        }
        s = new String(dstBuf);
        for (i = 0; i < 128; ++i) {
            if (dataBuf[i] == s.charAt(i)) continue;
            throw new IOException(filePath + ": data mismatch at char " + i + " after seeking to the beginning");
        }
        inputChannel.close();
        KfsTest.delete(kfsAccess, filePath);
    }

    private static void testUtimes(KfsAccess kfsAccess, String path) throws IOException {
        KfsFileAttr attr = new KfsFileAttr();
        kfsAccess.kfs_retToIOException(kfsAccess.kfs_stat(path, attr), path);
        long mtimeMs = attr.modificationTime - 5001L;
        long atimeMs = attr.creationTime - 10001L;
        long ctimeMs = attr.attrChangeTime - 8001L;
        kfsAccess.kfs_retToIOException(kfsAccess.kfs_setUTimes(path, mtimeMs * 1000L, atimeMs * 1000L, ctimeMs * 1000L), path);
        for (int pass = 0; pass < 2; ++pass) {
            kfsAccess.kfs_retToIOException(kfsAccess.kfs_stat(path, attr), path);
            if (mtimeMs != attr.modificationTime || atimeMs != attr.creationTime || ctimeMs != attr.attrChangeTime) {
                StringBuilder stringBuilder = new StringBuilder().append(path).append(": kfs_setUTimes result mismatch:  mtime: ").append(mtimeMs).append(" -> ").append(attr.modificationTime).append(" atime: ").append(atimeMs).append(" -> ").append(attr.creationTime).append(" ctime: ").append(ctimeMs).append(" -> ").append(attr.attrChangeTime).append(" pass: ").append(pass).append(" SET_TIME_TIME_NOT_VALID: ");
                Object[] objectArray = new Object[1];
                Objects.requireNonNull(kfsAccess);
                objectArray[0] = Long.MIN_VALUE;
                throw new IOException(stringBuilder.append(String.format("0x%x", objectArray)).toString());
            }
            Objects.requireNonNull(kfsAccess);
            Objects.requireNonNull(kfsAccess);
            kfsAccess.kfs_retToIOException(kfsAccess.kfs_setUTimes(path, mtimeMs * 1000L, Long.MIN_VALUE, Long.MIN_VALUE), path);
        }
    }
}

