/*
 * Decompiled with CFR 0.152.
 */
package com.quantcast.qfs.access;

import com.quantcast.qfs.access.KfsDelegation;
import com.quantcast.qfs.access.KfsFileAttr;
import com.quantcast.qfs.access.KfsInputChannel;
import com.quantcast.qfs.access.KfsOutputChannel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

class KfsAccessBase {
    public final int DEFAULT_APPEND_REPLICATION = 2;
    public final int DEFAULT_REPLICATION = 1;
    public final int DEFAULT_NUM_STRIPES = 6;
    public final int DEFAULT_NUM_RECOVERY_STRIPES = 3;
    public final int DEFAULT_STRIPE_SIZE = 65536;
    public final int DEFAULT_STRIPER_TYPE = 2;
    public final long SET_TIME_TIME_NOT_VALID = Long.MIN_VALUE;
    private long cPtr;

    private static native long initF(String var0);

    private static native long initS(String var0, int var1);

    protected static final native void destroy(long var0);

    private static native int cd(long var0, String var2);

    private static native int mkdir(long var0, String var2, int var3);

    private static native int mkdirs(long var0, String var2, int var3);

    private static native int rmdir(long var0, String var2);

    private static native int rmdirs(long var0, String var2);

    private static native String[] readdir(long var0, String var2, boolean var3);

    private static native String[][] getDataLocation(long var0, String var2, long var3, long var5);

    private static native String[][] getBlocksLocation(long var0, String var2, long var3, long var5);

    private static native short getReplication(long var0, String var2);

    private static native short setReplication(long var0, String var2, int var3);

    private static native long getModificationTime(long var0, String var2);

    private static native int create(long var0, String var2, int var3, boolean var4, int var5, int var6, int var7, int var8, boolean var9, int var10, int var11, int var12);

    private static native int create2(long var0, String var2, boolean var3, String var4);

    private static native int create2ex(long var0, String var2, boolean var3, String var4, int var5, boolean var6);

    private static native int remove(long var0, String var2);

    private static native int rename(long var0, String var2, String var3, boolean var4);

    private static native int symlink(long var0, String var2, String var3, int var4, boolean var5);

    private static native int open(long var0, String var2, String var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private static native int exists(long var0, String var2);

    private static native int isFile(long var0, String var2);

    private static native int isDirectory(long var0, String var2);

    private static native long filesize(long var0, String var2);

    private static native long setDefaultIoBufferSize(long var0, long var2);

    private static native long getDefaultIoBufferSize(long var0);

    private static native long setDefaultReadAheadSize(long var0, long var2);

    private static native long getDefaultReadAheadSize(long var0);

    private static native long setIoBufferSize(long var0, int var2, long var3);

    private static native long getIoBufferSize(long var0, int var2);

    private static native long setReadAheadSize(long var0, int var2, long var3);

    private static native long getReadAheadSize(long var0, int var2);

    private static native int setUTimes(long var0, String var2, long var3, long var5, long var7);

    private static native int compareChunkReplicas(long var0, String var2, StringBuffer var3);

    private static native void setFileAttributeRevalidateTime(long var0, int var2);

    private static native int chmod(long var0, String var2, int var3);

    private static native int chmodr(long var0, String var2, int var3);

    private static native int fchmod(long var0, int var2, int var3);

    private static native int chowns(long var0, String var2, String var3, String var4);

    private static native int chownsr(long var0, String var2, String var3, String var4);

    private static native int chown(long var0, String var2, long var3, long var5);

    private static native int chownr(long var0, String var2, long var3, long var5);

    private static native int fchowns(long var0, int var2, String var3, String var4);

    private static native int fchown(long var0, int var2, long var3, long var5);

    private static native int setEUserAndEGroup(long var0, long var2, long var4, long[] var6);

    private static native int stat(long var0, String var2, KfsFileAttr var3);

    private static native int lstat(long var0, String var2, KfsFileAttr var3);

    private static native String strerror(long var0, int var2);

    private static native boolean isnotfound(long var0, int var2);

    private static native int close(long var0, int var2);

    private static native long seek(long var0, int var2, long var3);

    private static native long tell(long var0, int var2);

    private static native int setUMask(long var0, int var2);

    private static native int getUMask(long var0);

    private static native String createDelegationToken(long var0, boolean var2, long var3, KfsDelegation var5);

    private static native String renewDelegationToken(long var0, KfsDelegation var2);

    private static native String cancelDelegationToken(long var0, KfsDelegation var2);

    private static native String[] getStats(long var0);

    protected KfsAccessBase(String configFn) throws IOException {
        this.cPtr = KfsAccessBase.initF(configFn);
        if (this.cPtr == 0L) {
            throw new IOException("Unable to initialize KFS Client");
        }
    }

    protected KfsAccessBase(String metaServerHost, int metaServerPort) throws IOException {
        this.cPtr = KfsAccessBase.initS(metaServerHost, metaServerPort);
        if (this.cPtr == 0L) {
            throw new IOException("Unable to initialize KFS Client");
        }
    }

    public final int kfs_cd(String path) {
        return KfsAccessBase.cd(this.cPtr, path);
    }

    public final int kfs_mkdirs(String path) {
        return KfsAccessBase.mkdirs(this.cPtr, path, 511);
    }

    public final int kfs_mkdirs(String path, int mode) {
        return KfsAccessBase.mkdirs(this.cPtr, path, mode);
    }

    public final int kfs_mkdir(String path, int mode) {
        return KfsAccessBase.mkdir(this.cPtr, path, mode);
    }

    public final int kfs_rmdir(String path) {
        return KfsAccessBase.rmdir(this.cPtr, path);
    }

    public final int kfs_rmdirs(String path) {
        return KfsAccessBase.rmdirs(this.cPtr, path);
    }

    public final String[] kfs_readdir(String path) {
        return this.kfs_readdir(path, false);
    }

    public final String[] kfs_readdir(String path, boolean prefetchAttr) {
        return KfsAccessBase.readdir(this.cPtr, path, prefetchAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final KfsFileAttr[] kfs_readdirplus(String path) {
        try (DirectoryIterator itr = null;){
            itr = new DirectoryIterator(path);
            ArrayList<KfsFileAttr> ret = new ArrayList<KfsFileAttr>();
            while (itr.next()) {
                KfsFileAttr entry = new KfsFileAttr();
                entry.modificationTime = itr.modificationTime;
                entry.attrChangeTime = itr.attrChangeTime;
                entry.creationTime = itr.creationTime;
                entry.filesize = itr.filesize;
                entry.replication = itr.replication;
                entry.isDirectory = itr.isDirectory;
                entry.filename = itr.filename;
                entry.numStripes = itr.numStripes;
                entry.numRecoveryStripes = itr.numRecoveryStripes;
                entry.striperType = itr.striperType;
                entry.stripeSize = itr.stripeSize;
                entry.owner = itr.owner;
                entry.group = itr.group;
                entry.mode = itr.mode;
                entry.ownerName = itr.ownerName;
                entry.groupName = itr.groupName;
                entry.fileId = itr.fileId;
                entry.dirCount = itr.dirCount;
                entry.fileCount = itr.fileCount;
                entry.chunkCount = itr.chunkCount;
                entry.minSTier = itr.minSTier;
                entry.maxSTier = itr.maxSTier;
                entry.extAttrTypes = itr.extAttrTypes;
                entry.extAttrs = itr.extAttrs;
                ret.add(entry);
            }
            KfsFileAttr[] kfsFileAttrArray = ret.toArray(new KfsFileAttr[0]);
            return kfsFileAttrArray;
        }
        return null;
    }

    public final KfsOutputChannel kfs_append(String path) {
        return this.kfs_append(path, 2);
    }

    public final KfsOutputChannel kfs_append(String path, int numReplicas) {
        try {
            return this.kfs_append_ex(path, numReplicas, 438);
        }
        catch (IOException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final KfsOutputChannel kfs_append_ex(String path, int numReplicas, int mode) throws IOException {
        int fd = KfsAccessBase.open(this.cPtr, path, "a", numReplicas > 0 ? numReplicas : 2, 0, 0, 0, 1, mode);
        this.kfs_retToIOException(fd, path);
        KfsOutputChannel chan = null;
        try {
            boolean append = true;
            chan = new KfsOutputChannel(this, fd, true);
        }
        finally {
            if (chan == null) {
                KfsAccessBase.close(this.cPtr, fd);
            }
        }
        return chan;
    }

    public final KfsOutputChannel kfs_create(String path) {
        return this.kfs_create(path, 1);
    }

    public final KfsOutputChannel kfs_create(String path, int numReplicas) {
        return this.kfs_create(path, numReplicas, false);
    }

    public final KfsOutputChannel kfs_create(String path, int numReplicas, boolean exclusive) {
        return this.kfs_create(path, numReplicas, exclusive, -1L, -1L);
    }

    public final KfsOutputChannel kfs_create(String path, int numReplicas, boolean exclusive, long bufferSize, long readAheadSize) {
        try {
            return this.kfs_create_ex(path, numReplicas, exclusive, bufferSize, readAheadSize, 438);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public final KfsOutputChannel kfs_create_ex(String path, int numReplicas, boolean exclusive, long bufferSize, long readAheadSize, int mode) throws IOException {
        boolean forceStriperType = false;
        return this.kfs_create_ex(path, 1, exclusive, bufferSize, readAheadSize, 6, 3, 65536, 2, false, mode);
    }

    public final void kfs_close(int fd) throws IOException {
        this.kfs_retToIOException(KfsAccessBase.close(this.cPtr, fd));
    }

    public final KfsOutputChannel kfs_create_ex(String path, int numReplicas, boolean exclusive, long bufferSize, long readAheadSize, int numStripes, int numRecoveryStripes, int stripeSize, int stripedType, boolean forceType, int mode) throws IOException {
        int minSTier = 15;
        int maxSTier = 15;
        return this.kfs_create_ex(path, numReplicas, exclusive, bufferSize, readAheadSize, numStripes, numRecoveryStripes, stripeSize, stripedType, forceType, mode, minSTier, maxSTier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final KfsOutputChannel kfs_create_ex(String path, int numReplicas, boolean exclusive, long bufferSize, long readAheadSize, int numStripes, int numRecoveryStripes, int stripeSize, int stripedType, boolean forceType, int mode, int minSTier, int maxSTier) throws IOException {
        int fd = KfsAccessBase.create(this.cPtr, path, numReplicas, exclusive, numStripes, numRecoveryStripes, stripeSize, stripedType, forceType, mode, minSTier, maxSTier);
        this.kfs_retToIOException(fd, path);
        if (bufferSize >= 0L) {
            KfsAccessBase.setIoBufferSize(this.cPtr, fd, bufferSize);
        }
        if (readAheadSize >= 0L) {
            KfsAccessBase.setReadAheadSize(this.cPtr, fd, readAheadSize);
        }
        KfsOutputChannel chan = null;
        try {
            boolean append = false;
            chan = new KfsOutputChannel(this, fd, false);
        }
        finally {
            if (chan == null) {
                KfsAccessBase.close(this.cPtr, fd);
            }
        }
        return chan;
    }

    public final KfsOutputChannel kfs_create_ex(String path, boolean exclusive, String createParams, int mode, boolean forceTypeFlag) throws IOException {
        return this.kfs_create_ex_fd(KfsAccessBase.create2ex(this.cPtr, path, exclusive, createParams, mode, forceTypeFlag), path);
    }

    public final KfsOutputChannel kfs_create_ex(String path, boolean exclusive, String createParams) throws IOException {
        return this.kfs_create_ex_fd(KfsAccessBase.create2(this.cPtr, path, exclusive, createParams), path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KfsOutputChannel kfs_create_ex_fd(int fd, String path) throws IOException {
        this.kfs_retToIOException(fd, path);
        KfsOutputChannel chan = null;
        try {
            boolean append = false;
            chan = new KfsOutputChannel(this, fd, false);
        }
        finally {
            if (chan == null) {
                KfsAccessBase.close(this.cPtr, fd);
            }
        }
        return chan;
    }

    private int kfs_open_ro(String path) {
        return KfsAccessBase.open(this.cPtr, path, "r", 1, 6, 3, 65536, 2, 0);
    }

    public final KfsInputChannel kfs_open(String path) {
        return this.kfs_open(path, -1L, -1L);
    }

    public final KfsInputChannel kfs_open(String path, long bufferSize, long readAheadSize) {
        try {
            return this.kfs_open_ex(path, bufferSize, readAheadSize);
        }
        catch (IOException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final KfsInputChannel kfs_open_ex(String path, long bufferSize, long readAheadSize) throws IOException {
        int fd = this.kfs_open_ro(path);
        this.kfs_retToIOException(fd, path);
        if (bufferSize >= 0L) {
            KfsAccessBase.setIoBufferSize(this.cPtr, fd, bufferSize);
        }
        if (readAheadSize >= 0L) {
            KfsAccessBase.setReadAheadSize(this.cPtr, fd, readAheadSize);
        }
        KfsInputChannel chan = null;
        try {
            chan = new KfsInputChannel(this, fd);
        }
        finally {
            if (chan == null) {
                KfsAccessBase.close(this.cPtr, fd);
            }
        }
        return chan;
    }

    public final int kfs_remove(String path) {
        return KfsAccessBase.remove(this.cPtr, path);
    }

    public final int kfs_rename(String oldpath, String newpath) {
        return KfsAccessBase.rename(this.cPtr, oldpath, newpath, true);
    }

    public final int kfs_rename(String oldpath, String newpath, boolean overwrite) {
        return KfsAccessBase.rename(this.cPtr, oldpath, newpath, overwrite);
    }

    public final int kfs_symlink(String target, String linkpath, int mode, boolean overwrite) {
        return KfsAccessBase.symlink(this.cPtr, target, linkpath, mode, overwrite);
    }

    public final boolean kfs_exists(String path) {
        return KfsAccessBase.exists(this.cPtr, path) == 1;
    }

    public final boolean kfs_isFile(String path) {
        return KfsAccessBase.isFile(this.cPtr, path) == 1;
    }

    public final boolean kfs_isDirectory(String path) {
        return KfsAccessBase.isDirectory(this.cPtr, path) == 1;
    }

    public final long kfs_filesize(String path) {
        return KfsAccessBase.filesize(this.cPtr, path);
    }

    public final String[][] kfs_getDataLocation(String path, long start, long len) {
        return KfsAccessBase.getDataLocation(this.cPtr, path, start, len);
    }

    public final String[][] kfs_getBlocksLocation(String path, long start, long len) {
        String[][] ret = KfsAccessBase.getBlocksLocation(this.cPtr, path, start, len);
        if (ret == null) {
            throw new OutOfMemoryError();
        }
        if (ret.length < 1 || ret[0].length != 1) {
            throw new Error("getBlocksLocation internal error");
        }
        return ret;
    }

    public final short kfs_getReplication(String path) {
        return KfsAccessBase.getReplication(this.cPtr, path);
    }

    public final short kfs_setReplication(String path, int numReplicas) {
        return KfsAccessBase.setReplication(this.cPtr, path, numReplicas);
    }

    public final long kfs_getModificationTime(String path) {
        return KfsAccessBase.getModificationTime(this.cPtr, path);
    }

    public final int kfs_setModificationTime(String path, long time) {
        return this.kfs_setUTimes(path, time * 1000L, Long.MIN_VALUE, Long.MIN_VALUE);
    }

    public final int kfs_setUTimes(String path, long mtimeUsec, long atimeUsec, long ctimeUsec) {
        return KfsAccessBase.setUTimes(this.cPtr, path, mtimeUsec, atimeUsec, ctimeUsec);
    }

    public final boolean kfs_compareChunkReplicas(String path, StringBuffer md5sum) throws IOException {
        int ret = KfsAccessBase.compareChunkReplicas(this.cPtr, path, md5sum);
        this.kfs_retToIOException(ret);
        return ret == 0;
    }

    public final long kfs_setDefaultIoBufferSize(long size) {
        return KfsAccessBase.setDefaultIoBufferSize(this.cPtr, size);
    }

    public final long kfs_getDefaultIoBufferSize(long ptr) {
        return KfsAccessBase.getDefaultIoBufferSize(this.cPtr);
    }

    public final long kfs_setDefaultReadAheadSize(long size) {
        return KfsAccessBase.setDefaultReadAheadSize(this.cPtr, size);
    }

    public final long kfs_getDefaultReadAheadSize(long ptr) {
        return KfsAccessBase.getDefaultReadAheadSize(this.cPtr);
    }

    public final long kfs_setIoBufferSize(int fd, long size) {
        return KfsAccessBase.setIoBufferSize(this.cPtr, fd, size);
    }

    public final long kfs_getIoBufferSize(int fd) {
        return KfsAccessBase.getIoBufferSize(this.cPtr, fd);
    }

    public final long kfs_setReadAheadSize(int fd, long size) {
        return KfsAccessBase.setReadAheadSize(this.cPtr, fd, size);
    }

    public final long kfs_getReadAheadSize(int fd) {
        return KfsAccessBase.getReadAheadSize(this.cPtr, fd);
    }

    public final void kfs_setFileAttributeRevalidateTime(int secs) {
        KfsAccessBase.setFileAttributeRevalidateTime(this.cPtr, secs);
    }

    public final int kfs_chmod(String path, int mode) {
        return KfsAccessBase.chmod(this.cPtr, path, mode);
    }

    public final int kfs_chmodr(String path, int mode) {
        return KfsAccessBase.chmodr(this.cPtr, path, mode);
    }

    public final int kfs_chmod(int fd, int mode) {
        return KfsAccessBase.fchmod(this.cPtr, fd, mode);
    }

    public final int kfs_chown(String path, String user, String group) {
        return KfsAccessBase.chowns(this.cPtr, path, user, group);
    }

    public final int kfs_chownr(String path, String user, String group) {
        return KfsAccessBase.chownsr(this.cPtr, path, user, group);
    }

    public final int kfs_chown(String path, long user, long group) {
        return KfsAccessBase.chown(this.cPtr, path, user, group);
    }

    public final int kfs_chownr(String path, long user, long group) {
        return KfsAccessBase.chownr(this.cPtr, path, user, group);
    }

    public final int kfs_chown(int fd, String user, String group) {
        return KfsAccessBase.fchowns(this.cPtr, fd, user, group);
    }

    public final int kfs_chown(int fd, long user, long group) {
        return KfsAccessBase.fchown(this.cPtr, fd, user, group);
    }

    public final int kfs_setEUserAndEGroup(long user, long group, long[] groups) {
        return KfsAccessBase.setEUserAndEGroup(this.cPtr, user, group, groups);
    }

    public final int kfs_stat(String path, KfsFileAttr attr) {
        return KfsAccessBase.stat(this.cPtr, path, attr);
    }

    public final int kfs_lstat(String path, KfsFileAttr attr) {
        return KfsAccessBase.lstat(this.cPtr, path, attr);
    }

    public final void kfs_retToIOException(int ret) throws IOException {
        this.kfs_retToIOException(ret, null);
    }

    public final void kfs_retToIOException(int ret, String path) throws IOException {
        String msg;
        if (ret >= 0) {
            return;
        }
        String es = KfsAccessBase.strerror(this.cPtr, ret);
        if (es == null) {
            throw new OutOfMemoryError();
        }
        String string = msg = path == null ? es : path + ": " + es;
        if (KfsAccessBase.isnotfound(this.cPtr, ret)) {
            throw new FileNotFoundException(msg);
        }
        throw new IOException(msg);
    }

    public final long kfs_seek(int fd, long offset) throws IOException {
        long ret = KfsAccessBase.seek(this.cPtr, fd, offset);
        if (ret < 0L) {
            this.kfs_retToIOException((int)ret);
        }
        return ret;
    }

    public final long kfs_tell(int fd) throws IOException {
        long ret = KfsAccessBase.tell(this.cPtr, fd);
        if (ret < 0L) {
            this.kfs_retToIOException((int)ret);
        }
        return ret;
    }

    public final int kfs_setUMask(int umask) throws IOException {
        int ret = KfsAccessBase.setUMask(this.cPtr, umask);
        if (ret < 0) {
            this.kfs_retToIOException(ret);
        }
        return ret;
    }

    public final int kfs_getUMask() throws IOException {
        int ret = KfsAccessBase.getUMask(this.cPtr);
        if (ret < 0) {
            this.kfs_retToIOException(ret);
        }
        return ret;
    }

    public final KfsDelegation kfs_createDelegationToken(boolean allowDelegationFlag, long validTime) throws IOException {
        KfsDelegation result = new KfsDelegation();
        String error = KfsAccessBase.createDelegationToken(this.cPtr, allowDelegationFlag, validTime, result);
        if (error != null) {
            throw new IOException(error);
        }
        if (result.key == null || result.token == null) {
            throw new OutOfMemoryError();
        }
        return result;
    }

    public final void kfs_renewDelegationToken(KfsDelegation token) throws IOException {
        String error = KfsAccessBase.renewDelegationToken(this.cPtr, token);
        if (error != null) {
            throw new IOException(error);
        }
        if (token.key == null || token.token == null) {
            throw new OutOfMemoryError();
        }
    }

    public final void kfs_cancelDelegationToken(KfsDelegation token) throws IOException {
        String error = KfsAccessBase.cancelDelegationToken(this.cPtr, token);
        if (error != null) {
            throw new IOException(error);
        }
    }

    public final Map<String, String> kfs_getStats() throws IOException {
        String[] stats = KfsAccessBase.getStats(this.cPtr);
        if (stats == null) {
            throw new IOException("internal error: null stats array");
        }
        if (stats.length % 2 != 0) {
            throw new IOException("internal error: invalid stats array size: " + stats.length);
        }
        TreeMap<String, String> ret = new TreeMap<String, String>();
        for (int i = 0; i < stats.length; i += 2) {
            ret.put(stats[i], stats[i + 1]);
        }
        return ret;
    }

    protected final void kfs_destroy() {
        if (this.cPtr != 0L) {
            long ptr = this.cPtr;
            this.cPtr = 0L;
            KfsAccessBase.destroy(ptr);
        }
    }

    final long getCPtr() {
        return this.cPtr;
    }

    static {
        try {
            System.loadLibrary("qfs_access");
        }
        catch (UnsatisfiedLinkError e) {
            throw new RuntimeException("Unable to load qfs_access native library", e);
        }
    }

    public final class DirectoryIterator {
        public long modificationTime;
        public long attrChangeTime;
        public long creationTime;
        public long filesize;
        public int replication;
        public boolean isDirectory;
        public int numStripes;
        public int numRecoveryStripes;
        public int striperType;
        public int stripeSize;
        public byte minSTier;
        public byte maxSTier;
        public String filename;
        public long owner;
        public long group;
        public int mode;
        public String ownerName;
        public String groupName;
        public long dirCount;
        public long fileCount;
        public long chunkCount;
        public long fileId;
        public int extAttrTypes;
        public String extAttrs;
        private KfsInputChannel input;
        private ByteBuffer buf;
        private int limit;
        private final CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        private long prevOwner;
        private long prevGroup;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DirectoryIterator(String path) throws IOException {
            int fd = KfsAccessBase.open(KfsAccessBase.this.cPtr, path, "opendir", 0, 0, 0, 0, 0, 0);
            KfsAccessBase.this.kfs_retToIOException(fd, path);
            this.input = null;
            try {
                this.input = new KfsInputChannel(KfsAccessBase.this, fd);
            }
            finally {
                if (this.input == null) {
                    KfsAccessBase.close(KfsAccessBase.this.cPtr, fd);
                }
            }
        }

        private String readString(int len) throws IOException {
            if (len <= 0) {
                return "";
            }
            int end = this.buf.position() + len;
            this.buf.limit(end);
            String str = this.decoder.reset().decode(this.buf).toString();
            this.buf.position(end).limit(this.limit);
            return str;
        }

        private void skip(int len) throws IOException {
            if (len > 0) {
                this.buf.position(this.buf.position() + len);
            }
        }

        public boolean next() throws IOException {
            int nameLen;
            do {
                if (this.buf == null || !this.buf.hasRemaining()) {
                    if (this.input == null) {
                        return false;
                    }
                    this.buf = this.input.readNext();
                    int n = this.limit = this.buf == null ? 0 : this.buf.limit();
                    if (this.limit <= 0) {
                        this.close();
                        return false;
                    }
                }
                this.modificationTime = this.buf.getLong();
                this.attrChangeTime = this.buf.getLong();
                this.creationTime = this.buf.getLong();
                this.filesize = this.buf.getLong();
                this.replication = this.buf.getInt();
                nameLen = this.buf.getInt();
                this.isDirectory = this.buf.get() != 0;
                this.numStripes = this.buf.getInt();
                this.numRecoveryStripes = this.buf.getInt();
                this.striperType = this.buf.getInt();
                this.stripeSize = this.buf.getInt();
                this.owner = this.buf.getInt();
                this.group = this.buf.getInt();
                this.mode = this.buf.getShort();
                this.fileId = this.buf.getLong();
                this.fileCount = this.isDirectory ? this.buf.getLong() : 0L;
                this.dirCount = this.isDirectory ? this.buf.getLong() : 0L;
                this.chunkCount = this.isDirectory ? 0L : this.buf.getLong();
                this.minSTier = this.buf.get();
                this.maxSTier = this.buf.get();
                int onameLen = this.buf.getInt();
                int gnameLen = this.buf.getInt();
                this.extAttrTypes = this.buf.getInt();
                int exAtLen = 0 == this.extAttrTypes ? 0 : this.buf.getInt();
                this.owner &= 0xFFFFFFFFL;
                this.group &= 0xFFFFFFFFL;
                this.mode &= 0xFFFF;
                this.filename = this.readString(nameLen);
                if (this.owner == this.prevOwner && this.ownerName != null) {
                    this.skip(onameLen);
                } else {
                    this.prevOwner = this.owner;
                    this.ownerName = this.readString(onameLen);
                }
                if (this.group == this.prevGroup && this.groupName != null) {
                    this.skip(gnameLen);
                } else {
                    this.prevGroup = this.group;
                    this.groupName = this.readString(gnameLen);
                }
                String string = this.extAttrs = 0 < exAtLen ? this.readString(exAtLen) : null;
            } while (nameLen <= 0);
            return true;
        }

        public void close() {
            if (this.input == null) {
                return;
            }
            this.buf = null;
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.input = null;
        }
    }
}

