/*
 * Decompiled with CFR 0.152.
 */
package com.quantcast.qfs.hadoop;

import com.quantcast.qfs.access.KfsFileAttr;
import com.quantcast.qfs.hadoop.CloseableIterator;
import com.quantcast.qfs.hadoop.IFSImpl;
import com.quantcast.qfs.hadoop.QFSImpl;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

public class QuantcastFileSystem
extends FileSystem {
    protected FileSystem localFs = null;
    protected IFSImpl qfsImpl = null;
    protected URI uri = null;
    protected Path workingDir = null;

    public QuantcastFileSystem() {
    }

    QuantcastFileSystem(IFSImpl fsimpl, URI uri) {
        this.qfsImpl = fsimpl;
        this.uri = uri;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        try {
            if (this.qfsImpl == null) {
                this.qfsImpl = uri.getHost() == null ? this.createIFSImpl(conf.get("fs.qfs.metaServerHost", ""), conf.getInt("fs.qfs.metaServerPort", -1), this.statistics, conf) : this.createIFSImpl(uri.getHost(), uri.getPort(), this.statistics, conf);
            }
            this.localFs = FileSystem.getLocal((Configuration)conf);
            this.uri = URI.create(uri.getScheme() + "://" + (uri.getAuthority() == null ? "/" : uri.getAuthority()));
            this.workingDir = new Path("/user", System.getProperty("user.name")).makeQualified(uri, null);
            this.qfsImpl.setUMask(FsPermission.getUMask((Configuration)conf).toShort());
        }
        catch (Exception e) {
            throw new IOException("Unable to initialize QFS using uri " + uri);
        }
    }

    protected IFSImpl createIFSImpl(String metaServerHost, int metaServerPort, FileSystem.Statistics stats, Configuration conf) throws IOException {
        return new QFSImpl(metaServerHost, metaServerPort, stats, conf);
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public void setWorkingDirectory(Path dir) {
        try {
            this.workingDir = this.makeAbsolute(dir).makeQualified(this.uri, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Path makeAbsolute(Path path) throws IOException {
        if (path.isAbsolute()) {
            this.checkPath(path);
            return path;
        }
        if (null == this.workingDir) {
            throw new IOException(path + ": absolute path required");
        }
        return new Path(this.workingDir, path);
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        return this.qfsImpl.mkdirs(this.makeAbsolute(path).toUri().getPath(), permission.toShort()) == 0;
    }

    @Deprecated
    public boolean isDirectory(Path path) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        return this.qfsImpl.isDirectory(srep);
    }

    @Deprecated
    public boolean isFile(Path path) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        return this.qfsImpl.isFile(srep);
    }

    public FileStatus[] listStatusInternal(Path path) throws IOException {
        FileStatus[] fileStatusArray;
        Path absolute = this.makeAbsolute(path).makeQualified(this.uri, null);
        FileStatus fs = this.qfsImpl.stat(absolute);
        if (fs.isDir()) {
            fileStatusArray = this.qfsImpl.readdirplus(absolute);
        } else {
            FileStatus[] fileStatusArray2 = new FileStatus[1];
            fileStatusArray = fileStatusArray2;
            fileStatusArray2[0] = fs;
        }
        return fileStatusArray;
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        try {
            return this.listStatusInternal(path);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        return this.qfsImpl.stat(this.makeAbsolute(path).makeQualified(this.uri, null));
    }

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progress) throws IOException {
        return this.qfsImpl.append(this.makeAbsolute(path).toUri().getPath(), (short)-1, bufferSize);
    }

    public FSDataOutputStream create(Path file, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path parent = file.getParent();
        if (parent != null && !this.mkdirs(parent)) {
            throw new IOException("Mkdirs failed to create " + parent);
        }
        return this.qfsImpl.create(this.makeAbsolute(file).toUri().getPath(), replication, bufferSize, overwrite, permission.toShort());
    }

    public FSDataOutputStream create(Path file, boolean overwrite, String createParams, int mode, boolean forceType) throws IOException {
        Path parent = file.getParent();
        if (parent != null && !this.mkdirs(parent)) {
            throw new IOException("Mkdirs failed to create " + parent);
        }
        return this.qfsImpl.create(this.makeAbsolute(file).toUri().getPath(), overwrite, createParams, mode, forceType);
    }

    public FSDataOutputStream create(Path file, boolean overwrite, String createParams) throws IOException {
        int mode = 438;
        boolean forceType = false;
        return this.create(file, overwrite, createParams, 438, false);
    }

    public FSDataOutputStream createNonRecursive(Path file, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.qfsImpl.create(this.makeAbsolute(file).toUri().getPath(), replication, bufferSize, overwrite, permission.toShort());
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        return this.qfsImpl.open(this.makeAbsolute(path).toUri().getPath(), bufferSize);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        Path absoluteD;
        String srepD;
        Path absoluteS = this.makeAbsolute(src);
        String srepS = absoluteS.toUri().getPath();
        return this.qfsImpl.rename(srepS, srepD = (absoluteD = this.makeAbsolute(dst)).toUri().getPath()) == 0;
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        Path absolute = this.makeAbsolute(path);
        try {
            boolean notEmptyFlag;
            KfsFileAttr fa = this.qfsImpl.fullStat(absolute);
            String srep = absolute.toUri().getPath();
            if (!fa.isDirectory) {
                return this.qfsImpl.remove(srep) == 0;
            }
            if (recursive) {
                return this.qfsImpl.rmdirs(srep) == 0;
            }
            boolean bl = notEmptyFlag = fa.fileCount > 0L || fa.dirCount > 0L;
            if (!(notEmptyFlag || fa.fileCount >= 0L && fa.dirCount >= 0L)) {
                FileStatus[] dirEntries = this.qfsImpl.readdirplus(absolute);
                boolean bl2 = notEmptyFlag = dirEntries != null && dirEntries.length > 0;
            }
            if (notEmptyFlag) {
                throw new IOException("Directory " + path.toString() + " is not empty.");
            }
            return this.qfsImpl.rmdir(srep) == 0;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Deprecated
    public boolean delete(Path path) throws IOException {
        return this.delete(path, true);
    }

    public short getDefaultReplication() {
        return 3;
    }

    public boolean setReplication(Path path, short replication) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        short res = this.qfsImpl.setReplication(srep, replication);
        return res >= 0;
    }

    public long getDefaultBlockSize() {
        return 0x4000000L;
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null || start < 0L || len < 0L) {
            throw new IllegalArgumentException("file: " + file + " start: " + start + " length: " + len);
        }
        String srep = this.makeAbsolute(file.getPath()).toUri().getPath();
        if (file.isDir()) {
            throw new IOException(srep + ": is a directory");
        }
        String[][] hints = this.qfsImpl.getBlocksLocation(srep, start, len);
        if (hints == null || hints.length < 1 || hints[0].length != 1) {
            throw new Error(srep + ": getBlocksLocation internal error");
        }
        long blockSize = Long.parseLong(hints[0][0], 16);
        if (blockSize < 0L) {
            try {
                this.qfsImpl.retToIoException((int)blockSize);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return null;
        }
        if (blockSize == 0L) {
            throw new Error(srep + ": getBlocksLocation internal error: 0 block size");
        }
        long end = Math.min(file.getLen(), start + len);
        if (hints.length <= 1 || end <= start) {
            BlockLocation[] result = new BlockLocation[]{new BlockLocation(null, null, start, Math.max(0L, end - start))};
            return result;
        }
        int blkcnt = (int)((end - 1L) / blockSize - start / blockSize + 1L);
        BlockLocation[] result = new BlockLocation[blkcnt];
        ArrayList<String> hlist = new ArrayList<String>();
        long pos = start - start % blockSize;
        int m = 1;
        for (int i = 0; i < blkcnt; ++i) {
            hlist.clear();
            if (m < hints.length) {
                String[] locs = hints[m++];
                hlist.ensureCapacity(locs.length);
                for (int k = 0; k < locs.length; ++k) {
                    String host;
                    int idx = locs[k].lastIndexOf(58);
                    String string = host = 0 < idx ? locs[k].substring(0, idx) : locs[k];
                    if (hlist.contains(host)) continue;
                    hlist.add(host);
                }
            }
            long lpos = pos < start ? start : pos;
            long bend = pos + blockSize;
            int hsz = hlist.size();
            result[i] = new BlockLocation(null, hsz <= 0 ? null : hlist.toArray(new String[hsz]), lpos, (bend < end ? bend : end) - lpos);
            pos = bend;
        }
        return result;
    }

    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        FileUtil.copy((FileSystem)this.localFs, (Path)src, (FileSystem)this, (Path)dst, (boolean)delSrc, (Configuration)this.getConf());
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        FileUtil.copy((FileSystem)this, (Path)src, (FileSystem)this.localFs, (Path)dst, (boolean)delSrc, (Configuration)this.getConf());
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return tmpLocalFile;
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        this.moveFromLocalFile(tmpLocalFile, fsOutputFile);
    }

    public void setPermission(Path path, FsPermission permission) throws IOException {
        this.qfsImpl.setPermission(this.makeAbsolute(path).toUri().getPath(), permission.toShort());
    }

    public void setOwner(Path path, String username, String groupname) throws IOException {
        this.qfsImpl.setOwner(this.makeAbsolute(path).toUri().getPath(), username, groupname);
    }

    public CloseableIterator<FileStatus> getFileStatusIterator(Path path) throws IOException {
        return this.qfsImpl.getFileStatusIterator(this, path);
    }

    private ContentSummary getContentSummarySuper(Path path) throws IOException {
        return super.getContentSummary(path);
    }

    public ContentSummary getContentSummary(Path path) throws IOException {
        Path absolute = this.makeAbsolute(path);
        KfsFileAttr stat = this.qfsImpl.fullStat(absolute);
        if (stat.isDirectory) {
            long len = stat.filesize;
            if (len < 0L) {
                return this.getContentSummarySuper(absolute);
            }
            if (stat.dirCount < 0L) {
                return new ContentSummaryProxy(absolute, len);
            }
            return new ContentSummary(len, stat.fileCount, stat.dirCount + 1L);
        }
        return new ContentSummary(stat.filesize, 1L, 0L);
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        return null;
    }

    public Path getLinkTarge(Path path) throws IOException {
        return this.qfsImpl.getLinkTarget(this.makeAbsolute(path));
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws FileNotFoundException, IOException {
        Path parent;
        if (createParent && (parent = link.getParent()) != null && !this.mkdirs(parent)) {
            throw new IOException("Mkdirs failed to create " + parent);
        }
        int mode = 511;
        boolean overwrite = false;
        this.qfsImpl.symlink(target.toString(), this.makeAbsolute(link).toUri().getPath(), 511, false);
    }

    public FileStatus getFileLinkStatus(Path path) throws FileNotFoundException, IOException {
        return this.qfsImpl.lstat(this.makeAbsolute(path).makeQualified(this.uri, null));
    }

    public boolean supportsSymlinks() {
        return true;
    }

    private class ContentSummaryProxy
    extends ContentSummary {
        private ContentSummary cs;
        private final Path path;

        private ContentSummaryProxy(Path path, long len) {
            super(len, -1L, -1L);
            this.path = path;
        }

        private ContentSummary get() {
            if (this.cs == null) {
                try {
                    this.cs = QuantcastFileSystem.this.getContentSummarySuper(this.path);
                }
                catch (IOException ex) {
                    this.cs = this;
                }
            }
            return this.cs;
        }

        public long getDirectoryCount() {
            return this.get().getDirectoryCount();
        }

        public long getFileCount() {
            return this.get().getFileCount();
        }

        public void write(DataOutput out) throws IOException {
            this.get().write(out);
        }

        public String toString(boolean qOption) {
            return this.get().toString(qOption);
        }
    }
}

