/*
 * Decompiled with CFR 0.152.
 */
package com.quantcast.qfs.hadoop;

import com.quantcast.qfs.hadoop.IFSImpl;
import com.quantcast.qfs.hadoop.QFSImpl;
import com.quantcast.qfs.hadoop.QuantcastFileSystem;
import com.quantcast.qfs.hadoop.QuantcastFileSystem2;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.local.LocalConfigKeys;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

public class Qfs
extends AbstractFileSystem {
    private final IFSImpl qfsImpl;
    private final QuantcastFileSystem qfs;
    private static final String kUriScheme = "qfs";
    private static final boolean kUriAuthorityNeededFlag = true;
    private static final int kDefaultPort = 20000;

    public Qfs(URI uri, Configuration conf) throws IOException, URISyntaxException {
        super(uri, kUriScheme, true, 20000);
        String scheme = uri.getScheme();
        if (!scheme.equalsIgnoreCase(kUriScheme)) {
            throw new IllegalArgumentException("requested URI scheme: " + scheme + " is not for QFS");
        }
        this.qfsImpl = uri.getHost() == null ? new QFSImpl(conf.get("fs.qfs.metaServerHost", ""), conf.getInt("fs.qfs.metaServerPort", -1), this.getStatistics(), conf) : new QFSImpl(uri.getHost(), uri.getPort(), this.getStatistics(), conf);
        this.qfs = new QuantcastFileSystem2(this.qfsImpl, uri);
    }

    public int getUriDefaultPort() {
        return 20000;
    }

    public FSDataOutputStream createInternal(Path path, EnumSet<CreateFlag> createFlag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt, boolean createParent) throws IOException {
        CreateFlag.validate(createFlag);
        this.checkPath(path);
        if (createParent) {
            this.mkdir(path.getParent(), absolutePermission, createParent);
        }
        return this.qfsImpl.create(this.getUriPath(path), replication, bufferSize, createFlag.contains(CreateFlag.OVERWRITE), absolutePermission.toShort(), createFlag.contains(CreateFlag.APPEND));
    }

    public boolean delete(Path path, boolean recursive) throws IOException, UnresolvedLinkException {
        return this.qfs.delete(path, recursive);
    }

    public BlockLocation[] getFileBlockLocations(Path path, long start, long len) throws IOException, UnresolvedLinkException {
        return this.qfs.getFileBlockLocations(this.qfs.getFileStatus(path), start, len);
    }

    public FileChecksum getFileChecksum(Path path) throws IOException, UnresolvedLinkException {
        return this.qfs.getFileChecksum(path);
    }

    public FileStatus getFileStatus(Path path) throws IOException, UnresolvedLinkException {
        Path qp = this.makeQualified(path);
        FileStatus fi = this.qfs.getFileStatus(qp);
        if (fi == null) {
            throw new FileNotFoundException(qp.toUri() + ": No such file or directory");
        }
        return fi;
    }

    public FileStatus getFileLinkStatus(Path path) throws IOException, UnresolvedLinkException {
        Path qp = this.makeQualified(path);
        FileStatus fi = this.qfs.getFileLinkStatus(qp);
        if (fi == null) {
            throw new FileNotFoundException(qp.toUri() + ": No such file or directory");
        }
        return fi;
    }

    public FsStatus getFsStatus() throws IOException {
        return new FsStatus(0L, 0L, 0L);
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        return LocalConfigKeys.getServerDefaults();
    }

    public FileStatus[] listStatus(Path path) throws IOException, UnresolvedLinkException {
        Path qp = this.makeQualified(path);
        FileStatus[] ls = this.qfs.listStatus(qp);
        if (ls == null) {
            throw new FileNotFoundException(qp.toUri() + ": No such file or directory");
        }
        return ls;
    }

    public void mkdir(Path dir, FsPermission permission, boolean createParent) throws IOException, UnresolvedLinkException {
        this.checkPath(dir);
        this.qfsImpl.retToIoException(createParent ? this.qfsImpl.mkdirs(this.getUriPath(dir), permission.toShort()) : this.qfsImpl.mkdir(this.getUriPath(dir), permission.toShort()));
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException, UnresolvedLinkException {
        return this.qfs.open(path, bufferSize);
    }

    public void renameInternal(Path src, Path dst) throws IOException, UnresolvedLinkException {
        boolean kOverwriteDestinationFlag = false;
        this.checkPath(src);
        this.checkPath(dst);
        this.qfsImpl.retToIoException(this.qfsImpl.rename2(this.getUriPath(src), this.getUriPath(dst), false));
    }

    public void setOwner(Path path, String username, String groupname) throws IOException, UnresolvedLinkException {
        this.qfs.setOwner(path, username, groupname);
    }

    public void setPermission(Path path, FsPermission permission) throws IOException, UnresolvedLinkException {
        this.qfs.setPermission(path, permission);
    }

    public boolean setReplication(Path path, short replication) throws IOException, UnresolvedLinkException {
        return this.qfs.setReplication(path, replication);
    }

    public void setTimes(Path path, long mtime, long atime) throws IOException, UnresolvedLinkException {
        this.qfs.setTimes(path, mtime, atime);
    }

    public void setVerifyChecksum(boolean verifyChecksum) throws IOException {
        this.qfs.setVerifyChecksum(verifyChecksum);
    }

    public boolean supportsSymlinks() {
        return this.qfs.supportsSymlinks();
    }

    public List<Token<?>> getDelegationTokens(String renewer) throws IOException {
        Token<?> result = this.qfs.getDelegationToken(renewer);
        ArrayList tokenList = new ArrayList();
        if (result != null) {
            tokenList.add(result);
        }
        return tokenList;
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws IOException, UnresolvedLinkException {
        this.qfs.createSymlink(target, link, createParent);
    }

    public Path getLinkTarget(Path f) throws IOException {
        return this.qfs.getLinkTarget(f);
    }
}

