/*
 * Decompiled with CFR 0.152.
 */
package com.quantcast.qfs.access;

import java.nio.ByteBuffer;
import java.util.AbstractQueue;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class BufferPool {
    public static final int BUFFER_SIZE = Integer.getInteger("qfs.access.buffer.size", 0x100000);
    private final AbstractQueue<ByteBuffer> buffers = new ConcurrentLinkedQueue<ByteBuffer>();
    private static final BufferPool INSTANCE = new BufferPool();

    private BufferPool() {
    }

    public static BufferPool getInstance() {
        return INSTANCE;
    }

    public ByteBuffer getBuffer() {
        ByteBuffer ret = (ByteBuffer)this.buffers.poll();
        if (ret == null) {
            ret = ByteBuffer.allocateDirect(BUFFER_SIZE);
        }
        return ret;
    }

    public void releaseBuffer(ByteBuffer b) {
        b.clear();
        this.buffers.add(b);
    }
}

