/*
 * Decompiled with CFR 0.152.
 */
package com.quantcast.qfs.access;

import com.quantcast.qfs.access.BufferPool;
import com.quantcast.qfs.access.KfsAccessBase;
import com.quantcast.qfs.access.Positionable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

class KfsOutputChannelBase
implements WritableByteChannel,
Positionable {
    protected final State state;
    private final boolean append;

    private static native int write(long var0, int var2, ByteBuffer var3, int var4, int var5);

    private static native int atomicRecordAppend(long var0, int var2, ByteBuffer var3, int var4, int var5);

    KfsOutputChannelBase(KfsAccessBase kfsAccess, int fd, boolean append) {
        this.append = append;
        this.state = new State(fd, kfsAccess);
    }

    @Override
    public final synchronized boolean isOpen() {
        return this.state.kfsFd >= 0;
    }

    @Override
    public final synchronized int write(ByteBuffer src) throws IOException {
        if (this.state.kfsFd < 0) {
            throw new IOException("File closed");
        }
        int r0 = src.remaining();
        while (src.hasRemaining()) {
            int spcAvail;
            if (this.state.writeBuffer.remaining() < (this.append ? r0 : 1)) {
                this.syncSelf();
            }
            if (this.append && r0 > (spcAvail = this.state.writeBuffer.remaining())) {
                int maxAppendSize = 65536;
                if (65536 < r0) {
                    throw new IOException(r0 + " exceeds KFS append size limit of " + 65536);
                }
                ByteBuffer buf = ByteBuffer.allocateDirect((r0 + BufferPool.BUFFER_SIZE - 1) / BufferPool.BUFFER_SIZE * BufferPool.BUFFER_SIZE);
                this.releaseBuffer();
                this.state.writeBuffer = buf;
            }
            int lim = src.limit();
            if (this.state.writeBuffer.remaining() < src.remaining()) {
                if (this.append) {
                    throw new IOException("KFS internal append error buffer space is not sufficient");
                }
                src.limit(src.position() + this.state.writeBuffer.remaining());
            }
            this.state.writeBuffer.put(src);
            src.limit(lim);
        }
        return r0 - src.remaining();
    }

    private void writeDirect(ByteBuffer buf) throws IOException {
        int last;
        if (!buf.isDirect()) {
            throw new IllegalArgumentException("need direct buffer");
        }
        int pos = buf.position();
        if (pos < (last = buf.limit())) {
            int sz = this.append ? KfsOutputChannelBase.atomicRecordAppend(this.state.kfsAccess.getCPtr(), this.state.kfsFd, this.state.writeBuffer, pos, last) : KfsOutputChannelBase.write(this.state.kfsAccess.getCPtr(), this.state.kfsFd, buf, pos, last);
            this.state.kfsAccess.kfs_retToIOException(sz);
            if (pos + sz != last) {
                throw new RuntimeException("KFS internal error:" + (this.append ? "append" : "write") + "(" + (last - pos) + ") != " + sz);
            }
        }
        buf.clear();
    }

    @Deprecated
    public final int atomicRecordAppend(ByteBuffer src) throws IOException {
        return this.write(src);
    }

    public final synchronized int sync() throws IOException {
        if (this.state.kfsFd < 0) {
            throw new IOException("File closed");
        }
        if (this.append) {
            this.syncSelf();
        }
        return 0;
    }

    private synchronized void syncSelf() throws IOException {
        this.state.writeBuffer.flip();
        boolean restore = true;
        try {
            this.writeDirect(this.state.writeBuffer);
            restore = false;
        }
        finally {
            if (restore) {
                this.state.writeBuffer.flip();
            }
        }
    }

    @Override
    public final synchronized long seek(long offset) throws IOException {
        if (this.state.kfsFd < 0) {
            throw new IOException("File closed");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("seek(" + this.state.kfsFd + ", " + offset + ")");
        }
        this.syncSelf();
        return this.state.kfsAccess.kfs_seek(this.state.kfsFd, offset);
    }

    @Override
    public final synchronized long tell() throws IOException {
        if (this.state.kfsFd < 0) {
            throw new IOException("File closed");
        }
        return this.state.kfsAccess.kfs_tell(this.state.kfsFd) + (long)this.state.writeBuffer.remaining();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.state.kfsFd < 0) {
            return;
        }
        IOException origEx = null;
        try {
            this.syncSelf();
        }
        catch (IOException ex) {
            origEx = ex;
        }
        finally {
            block14: {
                try {
                    this.state.release();
                }
                catch (IOException ex) {
                    if (origEx != null) break block14;
                    origEx = ex;
                }
            }
        }
        if (origEx != null) {
            throw origEx;
        }
    }

    private void releaseBuffer() {
        this.state.releaseBuffer();
    }

    public final void setIoBufferSize(long bufferSize) {
        if (bufferSize >= 0L) {
            this.state.kfsAccess.kfs_setIoBufferSize(this.state.kfsFd, bufferSize);
        }
    }

    protected static final class State
    implements Runnable {
        ByteBuffer writeBuffer = BufferPool.getInstance().getBuffer();
        boolean returnBufferToPool = true;
        int kfsFd;
        KfsAccessBase kfsAccess;

        State(int fd, KfsAccessBase ka) {
            this.writeBuffer.clear();
            this.kfsFd = fd;
            this.kfsAccess = ka;
        }

        void releaseBuffer() {
            if (this.returnBufferToPool) {
                BufferPool.getInstance().releaseBuffer(this.writeBuffer);
            }
            this.writeBuffer = null;
            this.returnBufferToPool = false;
        }

        void release() throws IOException {
            if (this.kfsFd >= 0 && this.kfsAccess != null) {
                int fd = this.kfsFd;
                this.kfsFd = -1;
                KfsAccessBase ka = this.kfsAccess;
                this.kfsAccess = null;
                try {
                    ka.kfs_close(fd);
                }
                finally {
                    this.releaseBuffer();
                }
            }
        }

        @Override
        public void run() {
            try {
                this.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

