/*
 * Decompiled with CFR 0.152.
 */
package com.quantcast.qfs.access;

import com.quantcast.qfs.access.BufferPool;
import com.quantcast.qfs.access.KfsAccessBase;
import com.quantcast.qfs.access.Positionable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

class KfsInputChannelBase
implements ReadableByteChannel,
Positionable {
    protected final State state;
    private boolean isReadAheadOff = false;

    private static native int read(long var0, int var2, ByteBuffer var3, int var4, int var5);

    protected KfsInputChannelBase(KfsAccessBase ka, int fd) {
        this.state = new State(ka, fd);
    }

    @Override
    public final synchronized boolean isOpen() {
        return this.state.kfsFd >= 0;
    }

    @Override
    public final synchronized int read(ByteBuffer dst) throws IOException {
        int r1;
        if (this.state.kfsFd < 0) {
            throw new IOException("File closed");
        }
        int r0 = dst.remaining();
        while (dst.hasRemaining()) {
            if (!this.state.readBuffer.hasRemaining()) {
                this.state.readBuffer.clear();
                this.readDirect(this.state.readBuffer, dst.remaining());
                this.state.readBuffer.flip();
                if (!this.state.readBuffer.hasRemaining()) break;
            }
            int lim = this.state.readBuffer.limit();
            if (dst.remaining() < this.state.readBuffer.remaining()) {
                this.state.readBuffer.limit(this.state.readBuffer.position() + dst.remaining());
            }
            dst.put(this.state.readBuffer);
            this.state.readBuffer.limit(lim);
        }
        if ((r1 = dst.remaining()) < r0 || r0 == 0) {
            return r0 - r1;
        }
        return -1;
    }

    final ByteBuffer readNext() throws IOException {
        this.state.readBuffer.clear();
        this.readDirect(this.state.readBuffer, 0);
        this.state.readBuffer.flip();
        return this.state.readBuffer;
    }

    private void readDirect(ByteBuffer buf, int remRequestedBytes) throws IOException {
        if (!buf.isDirect()) {
            throw new IllegalArgumentException("need direct buffer");
        }
        int pos = buf.position();
        int end = this.isReadAheadOff && remRequestedBytes > 0 ? Math.min(buf.limit(), pos + remRequestedBytes) : buf.limit();
        int sz = KfsInputChannelBase.read(this.state.kfsAccess.getCPtr(), this.state.kfsFd, buf, pos, end);
        this.state.kfsAccess.kfs_retToIOException(sz);
        buf.position(pos + sz);
    }

    @Override
    public final synchronized long seek(long offset) throws IOException {
        if (offset < 0L) {
            throw new IllegalArgumentException("seek(" + this.state.kfsFd + "," + offset + ")");
        }
        if (this.state.kfsFd < 0) {
            throw new IOException("File closed");
        }
        this.state.readBuffer.clear();
        this.state.readBuffer.flip();
        return this.state.kfsAccess.kfs_seek(this.state.kfsFd, offset);
    }

    @Override
    public synchronized long tell() throws IOException {
        int rem;
        if (this.state.kfsFd < 0) {
            throw new IOException("File closed");
        }
        long ret = this.state.kfsAccess.kfs_tell(this.state.kfsFd);
        if (ret < (long)(rem = this.state.readBuffer.remaining())) {
            throw new RuntimeException("KFS internal error: pos: " + ret + " less than buffered: " + rem);
        }
        return ret - (long)rem;
    }

    @Override
    public synchronized void close() throws IOException {
        this.state.release();
    }

    public final void setReadAheadSize(long readAheadSize) {
        if (readAheadSize >= 0L) {
            this.state.kfsAccess.kfs_setReadAheadSize(this.state.kfsFd, readAheadSize);
            this.isReadAheadOff = readAheadSize == 0L;
        }
    }

    protected static final class State
    implements Runnable {
        ByteBuffer readBuffer = BufferPool.getInstance().getBuffer();
        int kfsFd;
        KfsAccessBase kfsAccess;

        State(KfsAccessBase ka, int fd) {
            this.readBuffer.flip();
            this.kfsFd = fd;
            this.kfsAccess = ka;
        }

        void releaseBuffer() {
            if (this.readBuffer != null) {
                BufferPool.getInstance().releaseBuffer(this.readBuffer);
                this.readBuffer = null;
            }
        }

        void release() throws IOException {
            if (this.kfsFd >= 0 && this.kfsAccess != null) {
                int fd = this.kfsFd;
                this.kfsFd = -1;
                KfsAccessBase ka = this.kfsAccess;
                this.kfsAccess = null;
                try {
                    ka.kfs_close(fd);
                }
                finally {
                    this.releaseBuffer();
                }
            }
        }

        @Override
        public void run() {
            try {
                this.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

