

class AnimController

  constructor: (element_name) ->
    @element_name = element_name
    @update_scene = false

  load_frame: (frame, callback = (data) -> null) ->
    $.getJSON "/frame", {"frame": frame}, (data) =>
      @curr_event = data
      callback(data)

  display_frame: (frame) ->
    @load_frame frame, (data) =>
      @update_scene = true
      @render()

  set_up_scene: () ->
    @scene = new THREE.Scene()
    el = $(@element_name)
    @camera = new THREE.PerspectiveCamera(45
      el.width()/el.height(),
      1, 20000
    )
    @camera.position.set(100, 100, 0)
    @scene.add new THREE.AmbientLight 0x111111

    @renderer = new THREE.WebGLRenderer()
    renderer = new THREE.WebGLRenderer( { antialias: true } );
    renderer.setSize( el.width(), el.height() );
    el.html(@renderer.domElement)
    controls = new THREE.OrbitControls(@camera, @renderer.domElement );
    controls.addEventListener 'change', () =>
      console.log("Change")
      @render()

  render: () ->
    requestAnimationFrame(() => @render)
    console.log "Render"
    if @update_scene
      material = new THREE.MeshBasicMaterial() #"color": 0xffff00,
      geometry = new THREE.SphereGeometry 5, 50, 50
      console.log "Update"
      @update_scene = false
      @scene = new THREE.Scene()
      for particle in @curr_event
        p = particle['position']
        sphere = new THREE.Mesh( geometry, material );
        sphere.position.set(p[0], p[1], p[2])
        @scene.add(sphere)
    @renderer.render(@scene, @camera)

class MockAnimController extends AnimController

   load_frame: (frame, callback = (data) -> null) ->
      data = [
        {"particle_type": 1.0, "additional": [-1.0, 0.0, 65.0, 3.0, 1.0], "event_id": 0.0, "energy": 1.289489507675171, "frame_id": 4.0, "mass": 0.9380000233650208, "time": 50.0, "position": [5.60906457901001, -7.102511405944824, -23.134424209594727], "momentum": [0.03223538026213646, -0.11810099333524704, -0.8763288855552673]},{"particle_type": 1.0, "additional": [-1.0, 0.0, 9.0, 3.0, 0.0], "event_id": 0.0, "energy": 1.3731991052627563, "frame_id": 4.0, "mass": 0.9380000233650208, "time": 50.0, "position": [1.0419079065322876, 3.7977304458618164, -28.173377990722656], "momentum": [-0.1330081671476364, -0.03527553752064705, -0.9934264421463013]},{"particle_type": 1.0, "additional": [1.0, 1.0, 0.0, 0.0, 0.0], "event_id": 0.0, "energy": 1.2316361665725708, "frame_id": 4.0, "mass": 0.9380000233650208, "time": 50.0, "position": [-4.511547088623047, 0.9732173681259155, -19.70073127746582], "momentum": [0.0797773152589798, 0.0002833731414284557, -0.7941783666610718]},{"particle_type": 1.0, "additional": [1.0, 1.0, 0.0, 0.0, 0.0], "event_id": 0.0, "energy": 1.285156488418579, "frame_id": 4.0, "mass": 0.9380000233650208, "time": 50.0, "position": [1.2655693292617798, 8.172785758972168, -22.804956436157227], "momentum": [-0.0361766554415226, -0.08765657991170883, -0.8733788728713989]},{"particle_type": 1.0, "additional": [1.0, 1.0, 0.0, 0.0, 0.0], "event_id": 0.0, "energy": 1.1167477369308472, "frame_id": 4.0, "mass": 0.9380000233650208, "time": 50.0, "position": [-8.483230590820312, -5.241664409637451, -21.756118774414062], "momentum": [0.06414363533258438, -0.09081939607858658, -0.595750629901886]},{"particle_type": 1.0, "additional": [1.0, 1.0, 0.0, 0.0, 0.0], "event_id": 0.0, "energy": 1.2279361486434937, "frame_id": 4.0, "mass": 0.9380000233650208, "time": 50.0, "position": [-8.256858825683594, 1.6434903144836426, -22.17698097229004], "momentum": [-0.14693689346313477, 0.20475822687149048, -0.7513101100921631]},{"particle_type": 1.0, "additional": [1.0, 1.0, 0.0, 0.0, 0.0], "event_id": 0.0, "energy": 1.1180059909820557, "frame_id": 4.0, "mass": 0.9380000233650208, "time": 50.0, "position": [-6.4770402908325195, 3.818347454071045, -19.189449310302734], "momentum": [-0.10499054938554764, 0.11195815354585648, -0.5886728167533875]},{"particle_type": 1.0, "additional": [1.0, 1.0, 0.0, 0.0, 0.0], "event_id": 0.0, "energy": 1.1960077285766602, "frame_id": 4.0, "mass": 0.9380000233650208, "time": 50.0, "position": [-8.811576843261719, -2.183429002761841, -25.974225997924805], "momentum": [-0.11623790115118027, -0.12452901154756546, -0.7221992015838623]},{"particle_type": 1.0, "additional": [1.0, 1.0, 167.0, 2.0, 0.0], "event_id": 0.0, "energy": 1.0628974437713623, "frame_id": 4.0, "mass": 0.9380000233650208, "time": 50.0, "position": [1.8680299520492554, 3.8847341537475586, -28.02294921875], "momentum": [0.02344498038291931, -0.041095469146966934, -0.49766311049461365]},{"particle_type": 1.0, "additional": [1.0, 1.0, 0.0, 0.0, 0.0], "event_id": 0.0, "energy": 1.0765424966812134, "frame_id": 4.0, "mass": 0.9380000233650208, "time": 50.0, "position": [0.008346362970769405, -6.880765438079834, -22.900455474853516], "momentum": [-0.07460355013608932, -0.07920558750629425, -0.5169724225997925]},{"particle_type": 1.0, "additional": [1.0, 1.0, 0.0, 0.0, 0.0], "event_id": 0.0, "energy": 1.1779557466506958, "frame_id": 4.0, "mass": 0.9380000233650208, "time": 50.0, "position": [-7.644638538360596, 4.470989227294922, -26.40774154663086], "momentum": [-0.0165697168558836, 0.023445548489689827, -0.7119770646095276]},{"particle_type": 1.0, "additional": [1.0, 1.0, 0.0, 0.0, 0.0], "event_id": 0.0, "energy": 1.2478638887405396, "frame_id": 4.0, "mass": 0.9380000233650208, "time": 50.0, "position": [-7.261934757232666, 1.6191389560699463, -17.677865982055664], "momentum": [0.031182389706373215, -0.03766264393925667, -0.8215408325195312]},{"particle_type": 1.0, "additional": [1.0, 1.0, 0.0, 0.0, 0.0], "event_id": 0.0, "energy": 1.0973002910614014, "frame_id": 4.0, "mass": 0.9380000233650208, "time": 50.0, "position": [-6.7780985832214355, -5.583848476409912, -22.1124267578125], "momentum": [0.06620053946971893, -0.09472901374101639, -0.5575551390647888]},{"particle_type": 1.0, "additional": [1.0, 1.0, 230.0, 0.0, 0.0], "event_id": 0.0, "energy": 1.1915955543518066, "frame_id": 4.0, "mass": 0.9380000233650208, "time": 50.0, "position": [0.40333569049835205, 4.343142986297607, -23.412595748901367], "momentum": [-0.06981177628040314, 0.01172269694507122, -0.731467604637146]},{"particle_type": 1.0, "additional": [1.0, 1.0, 175.0, 0.0, 0.0], "event_id": 0.0, "energy": 1.094565749168396, "frame_id": 4.0, "mass": 0.9380000233650208, "time": 50.0, "position": [-2.474665641784668, -5.68718957901001, -18.10910987854004], "momentum": [-0.0925300121307373, -0.004285226576030254, -0.5564619898796082]},{"particle_type": 1.0, "additional": [1.0, 1.0, 0.0, 0.0, 0.0], "event_id": 0.0, "energy": 1.159861445426941, "frame_id": 4.0, "mass": 0.9380000233650208, "time": 50.0, "position": [2.320319414138794, 4.496981143951416, -23.394493103027344], "momentum": [0.06577834486961365, 0.16004455089569092, -0.6599192023277283]}
      ]
      @curr_event = data
      callback(data)

window.AnimController = MockAnimController

